/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.tigertree.HashTree;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class IncompleteFileDesc
extends FileDesc
implements HTTPHeaderValue {
    private static final int MIN_CHUNK_SIZE = 102400;
    private VerifyingFile _verifyingFile;
    private final String _name;
    private final int _size;

    public IncompleteFileDesc(File file, Set urns, int index, String completedName, int completedSize, VerifyingFile vf) {
        super(file, urns, index);
        this._name = completedName;
        this._size = completedSize;
        this._verifyingFile = vf;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        if (this.getFile().length() == 0L) {
            throw new FileNotFoundException("nothing downloaded");
        }
        if (this._verifyingFile.isCorrupted()) {
            throw new FileNotFoundException("data is corrupt");
        }
        return new FileInputStream(this.getFile());
    }

    public boolean add(AlternateLocation al) {
        ManagedDownloader md;
        boolean ret = super.add(al);
        if (ret && (md = this._verifyingFile.getManagedDownloader()) != null) {
            md.addDownload(al.createRemoteFileDesc((int)this.getSize()), false);
        }
        return ret;
    }

    public boolean addVerified(AlternateLocation al) {
        return super.add(al);
    }

    public HashTree getHashTree() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAll(AlternateLocationCollection alc) {
        ManagedDownloader md = this._verifyingFile.getManagedDownloader();
        if (md == null) {
            return super.addAll(alc);
        }
        int added = 0;
        AlternateLocationCollection alternateLocationCollection = alc;
        synchronized (alternateLocationCollection) {
            Iterator iter = alc.iterator();
            while (iter.hasNext()) {
                AlternateLocation al = (AlternateLocation)iter.next();
                if (!super.add(al)) continue;
                md.addDownload(al.createRemoteFileDesc((int)this.getSize()), false);
                ++added;
            }
        }
        return added;
    }

    public boolean isActivelyDownloading() {
        ManagedDownloader md = this._verifyingFile.getManagedDownloader();
        if (md == null) {
            return false;
        }
        switch (md.getState()) {
            case 0: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAvailableRanges() {
        StringBuffer ret = new StringBuffer("bytes");
        boolean added = false;
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.high - interval.low + 1 < 102400) continue;
                added = true;
                ret.append(" " + interval.low + "-" + (interval.high - 1) + ",");
            }
        }
        if (added) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeSatisfiable(int low, int high) {
        VerifyingFile verifyingFile = this._verifyingFile;
        synchronized (verifyingFile) {
            Iterator iter = this._verifyingFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (low < interval.low || high > interval.high) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRangeSatisfiable(Interval range) {
        return this.isRangeSatisfiable(range.low, range.high);
    }

    public String httpStringValue() {
        return this.getAvailableRanges();
    }

    public String toString() {
        return "IncompleteFileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this.getIndex() + "\r\n";
    }
}

