/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.StatisticsSettings;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.statistics.RouteErrorStat;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FixedsizeHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.NoMoreStorageException;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.Utilities;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public abstract class MessageRouter {
    protected static ConnectionManager _manager;
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private final ReplyHandler FOR_ME_REPLY_HANDLER = ForMeReplyHandler.instance();
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    private final int MAX_BYPASSED_RESULTS = 150;
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    private static final long CLEAR_TIME = 30000L;
    static int MAX_BUFFERED_REPLIES;
    private final Map _outOfBandReplies = new Hashtable();
    private final Map _bypassedResults = new HashMap();
    private static final FixedsizeHashMap _udpConnectBacks;
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap _tcpConnectBacks;
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ProcessingQueue TCP_CONNECT_BACKER;
    protected final QueryUnicaster UNICASTER = QueryUnicaster.instance();
    private final QueryDispatcher DYNAMIC_QUERIER = QueryDispatcher.instance();
    private ActivityCallback _callback;
    private static FileManager _fileManager;
    private static final boolean RECORD_STATS;
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private volatile Map _messageListeners = DataUtils.EMPTY_MAP;
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private PromotionManager _promotionManager;

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(ApplicationSettings.CLIENT_ID.getValue())).bytes();
        }
        catch (IllegalArgumentException e) {
            this._clientGUID = Message.makeGuid();
            ApplicationSettings.CLIENT_ID.setValue(new GUID(this._clientGUID).toHexString());
        }
    }

    public void initialize() {
        _manager = RouterService.getConnectionManager();
        this._callback = RouterService.getCallback();
        _fileManager = RouterService.getFileManager();
        this._promotionManager = RouterService.getPromotionManager();
        this.DYNAMIC_QUERIER.start();
        this.QRP_PROPAGATOR.start();
        RouterService.schedule(new Expirer(), 30000L, 30000L);
        RouterService.schedule(new ConnectBackExpirer(), 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryKilled(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!RouterService.getDownloadManager().isGuidForQueryDownloading(guid)) {
                this._bypassedResults.remove((Object)guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFinished(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        Map map = this._bypassedResults;
        synchronized (map) {
            if (!this._callback.isQueryAlive(guid) && !RouterService.getDownloadManager().isGuidForQueryDownloading(guid)) {
                this._bypassedResults.remove((Object)guid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGuessLocs(GUID guid) {
        HashSet clone = new HashSet();
        Map map = this._bypassedResults;
        synchronized (map) {
            Set eps = (Set)this._bypassedResults.get((Object)guid);
            if (eps != null) {
                clone.addAll((Collection)eps);
            }
        }
        return clone;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ReplyHandler rh) {
        this.DYNAMIC_QUERIER.removeReplyHandler(rh);
        this._pingRouteTable.removeReplyHandler(rh);
        this._queryRouteTable.removeReplyHandler(rh);
        this._pushRouteTable.removeReplyHandler(rh);
    }

    public void handleMessage(Message msg, ManagedConnection receivingConnection) {
        msg.hop();
        if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REQUESTS.addMessage(msg);
            }
            this.handlePingRequestPossibleDuplicate((PingRequest)msg, receivingConnection);
        } else if (msg instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PING_REPLIES.addMessage(msg);
            }
            this.handlePingReply((PingReply)msg, receivingConnection);
        } else if (msg instanceof QueryRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(msg);
            }
            this.handleQueryRequestPossibleDuplicate((QueryRequest)msg, receivingConnection);
        } else if (msg instanceof QueryReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_QUERY_REPLIES.addMessage(msg);
            }
            QueryReply qmsg = (QueryReply)msg;
            this.handleQueryReply(qmsg, receivingConnection);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, receivingConnection);
        } else if (msg instanceof ResetTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(msg);
            }
            this.handleResetTableMessage((ResetTableMessage)msg, receivingConnection);
        } else if (msg instanceof PatchTableMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_PATCH_ROUTE_TABLE_MESSAGES.addMessage(msg);
            }
            this.handlePatchTableMessage((PatchTableMessage)msg, receivingConnection);
        } else if (msg instanceof MessagesSupportedVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(msg);
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof CapabilitiesVM) {
            if (RECORD_STATS) {
                // empty if block
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof HopsFlowVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_HOPS_FLOW.addMessage(msg);
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof TCPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_TCP_CONNECTBACK.addMessage(msg);
            }
            this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)msg, receivingConnection);
        } else if (msg instanceof UDPConnectBackVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.TCP_UDP_CONNECTBACK.addMessage(msg);
            }
            this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)msg, receivingConnection);
        } else if (msg instanceof TCPConnectBackRedirect) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)msg, receivingConnection);
        } else if (msg instanceof UDPConnectBackRedirect) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)msg, receivingConnection);
        } else if (msg instanceof PushProxyRequest) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handlePushProxyRequest((PushProxyRequest)msg, receivingConnection);
        } else if (msg instanceof PushProxyAcknowledgement) {
            if (RECORD_STATS) {
                // empty if block
            }
            receivingConnection.handleVendorMessage((VendorMessage)msg);
        } else if (msg instanceof QueryStatusResponse) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleQueryStatus((QueryStatusResponse)msg, receivingConnection);
        } else if (msg instanceof GiveStatsVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleGiveStats((GiveStatsVendorMessage)msg, receivingConnection);
        } else if (msg instanceof StatisticVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleStatisticsMessage((StatisticVendorMessage)msg, receivingConnection);
        }
        this.notifyMessageListener(msg, receivingConnection);
    }

    private final void notifyMessageListener(Message msg, ReplyHandler handler) {
        List all = (List)this._messageListeners.get((Object)msg.getGUID());
        if (all != null) {
            Iterator i = all.iterator();
            while (i.hasNext()) {
                MessageListener next = (MessageListener)i.next();
                next.processMessage(msg, handler);
            }
        }
    }

    public void handleUDPMessage(Message msg, DatagramPacket datagram) {
        msg.hop();
        InetAddress address = datagram.getAddress();
        int port = datagram.getPort();
        if (!RouterService.isIpPortValid()) {
            return;
        }
        UDPReplyHandler handler = new UDPReplyHandler(address, port);
        if (msg instanceof QueryRequest) {
            if (this.hasValidQueryKey(address, port, (QueryRequest)msg)) {
                this.sendAcknowledgement(datagram, msg.getGUID());
                if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                    ReceivedMessageStatHandler.UDP_DUPLICATE_QUERIES.addMessage(msg);
                }
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(msg);
            }
        } else if (msg instanceof QueryReply) {
            QueryReply qr = (QueryReply)msg;
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_QUERY_REPLIES.addMessage(msg);
                short numResps = qr.getResultCount();
                try {
                    if (!qr.isReplyToMulticastQuery()) {
                        OutOfBandThroughputStat.RESPONSES_RECEIVED.addData(numResps);
                    }
                }
                catch (BadPacketException bpe) {
                    return;
                }
            }
            this.handleQueryReply(qr, handler);
        } else if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REQUESTS.addMessage(msg);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, datagram);
        } else if (msg instanceof PingReply) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PING_REPLIES.addMessage(msg);
            }
            this.handleUDPPingReply((PingReply)msg, handler, address, port);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, handler);
        } else if (msg instanceof LimeACKVendorMessage) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.UDP_LIME_ACK.addMessage(msg);
            }
            this.handleLimeACKMessage((LimeACKVendorMessage)msg, datagram);
        } else if (msg instanceof ReplyNumberVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleReplyNumberMessage((ReplyNumberVendorMessage)msg, datagram);
        } else if (msg instanceof GiveStatsVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleGiveStats((GiveStatsVendorMessage)msg, handler);
        } else if (msg instanceof StatisticVendorMessage) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleStatisticsMessage((StatisticVendorMessage)msg, handler);
        } else if (msg instanceof UDPCrawlerPing) {
            if (RECORD_STATS) {
                // empty if block
            }
            this.handleUDPCrawlerPing((UDPCrawlerPing)msg, handler);
        }
        this.notifyMessageListener(msg, handler);
    }

    public void handleMulticastMessage(Message msg, DatagramPacket datagram) {
        if (msg.getTTL() > 1) {
            return;
        }
        msg.hop();
        InetAddress address = datagram.getAddress();
        int port = datagram.getPort();
        if (NetworkUtils.isLocalAddress(address) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        UDPReplyHandler handler = new UDPReplyHandler(address, port);
        if (msg instanceof QueryRequest) {
            if (!this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler)) {
                ReceivedMessageStatHandler.MULTICAST_DUPLICATE_QUERIES.addMessage(msg);
            }
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(msg);
            }
        } else if (msg instanceof PingRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PING_REQUESTS.addMessage(msg);
            }
            this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, datagram);
        } else if (msg instanceof PushRequest) {
            if (RECORD_STATS) {
                ReceivedMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(msg);
            }
            this.handlePushRequest((PushRequest)msg, handler);
        }
        this.notifyMessageListener(msg, handler);
    }

    protected boolean hasValidQueryKey(InetAddress ip, int port, QueryRequest qr) {
        if (qr.getQueryKey() == null) {
            return false;
        }
        QueryKey computedQK = QueryKey.getQueryKey(ip, port);
        return qr.getQueryKey().equals(computedQK);
    }

    protected void sendAcknowledgement(DatagramPacket datagram, byte[] guid) {
        PingReply reply;
        ConnectionManager manager = RouterService.getConnectionManager();
        Endpoint host = manager.getConnectedGUESSUltrapeer();
        if (host != null) {
            try {
                reply = PingReply.createGUESSReply(guid, (byte)1, host);
            }
            catch (UnknownHostException e) {
                reply = this.createPingReply(guid);
            }
        } else {
            reply = this.createPingReply(guid);
        }
        if (reply == null) {
            return;
        }
        UDPService.instance().send(reply, datagram.getAddress(), datagram.getPort());
        if (RECORD_STATS) {
            SentMessageStatHandler.UDP_PING_REPLIES.addMessage(reply);
        }
    }

    private PingReply createPingReply(byte[] guid) {
        GUESSEndpoint endpoint = this.UNICASTER.getUnicastEndpoint();
        if (endpoint == null) {
            if (RouterService.isIpPortValid()) {
                return PingReply.create(guid, (byte)1);
            }
            return null;
        }
        return PingReply.createGUESSReply(guid, (byte)1, endpoint.getPort(), endpoint.getAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handlePingRequest(request, handler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler, DatagramPacket datagram) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handleUDPPingRequest(request, handler, datagram);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest request, ManagedConnection receivingConnection) {
        boolean isProbeQuery = request.getTTL() == 0 && (request.getHops() == 1 || request.getHops() == 2);
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), receivingConnection);
        if (counter != null) {
            if (isProbeQuery) {
                this._queryRouteTable.setTTL(counter, (byte)1);
            }
            this.handleQueryRequest(request, receivingConnection, counter, true);
        } else if (counter == null && !isProbeQuery) {
            if (this.wasProbeQuery(request)) {
                this.handleQueryRequest(request, receivingConnection, counter, false);
            } else {
                this.tallyDupQuery(request);
            }
        } else if (counter == null && isProbeQuery) {
            this.tallyDupQuery(request);
        } else {
            this.tallyDupQuery(request);
        }
    }

    private boolean wasProbeQuery(QueryRequest request) {
        return request.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(request.getGUID(), (byte)1, (byte)(request.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest request) {
        if (RECORD_STATS) {
            ReceivedMessageStatHandler.TCP_DUPLICATE_QUERIES.addMessage(request);
        }
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest request, ReplyHandler handler) {
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), handler);
        if (counter != null) {
            this.handleQueryRequest(request, handler, counter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest ping, ReplyHandler handler) {
        if (ping.isHeartbeat() || handler.allowNewPings()) {
            this.respondToPingRequest(ping, handler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler handler, DatagramPacket datagram) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, datagram);
        } else {
            this.respondToUDPPingRequest(pingRequest, datagram, handler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pr, DatagramPacket datagram) {
        InetAddress address = datagram.getAddress();
        int port = datagram.getPort();
        QueryKey key = QueryKey.getQueryKey(address, port);
        PingReply reply = PingReply.createQueryKeyReply(pr.getGUID(), (byte)1, key);
        UDPService.instance().send(reply, datagram.getAddress(), datagram.getPort());
    }

    protected void handleUDPPingReply(PingReply reply, ReplyHandler handler, InetAddress address, int port) {
        if (reply.getQueryKey() != null) {
            OnDemandUnicaster.handleQueryKeyPong(reply);
            return;
        }
        if (reply.getPort() != port || !reply.getInetAddress().equals(address)) {
            this.UNICASTER.addUnicastEndpoint(address, port);
        }
        this.handlePingReply(reply, handler);
    }

    protected void handleQueryRequest(QueryRequest request, ReplyHandler handler, ResultCounter counter, boolean locallyEvaluate) {
        if (!handler.isPersonalSpam(request)) {
            this._callback.handleQueryString(request.getQuery());
        }
        this.updateMessage(request, handler);
        if (handler.isSupernodeClientConnection() && counter != null) {
            if (request.desiresOutOfBandReplies()) {
                String remoteAddr = handler.getInetAddress().getHostAddress();
                String myAddress = NetworkUtils.ip2string(RouterService.getAddress());
                if (!(request.getReplyAddress().equals(remoteAddr) || request.getReplyAddress().equals(myAddress) && RouterService.isOOBCapable())) {
                    return;
                }
            }
            locallyEvaluate = false;
            this.respondToQueryRequest(request, this._clientGUID, handler);
            this.multicastQueryRequest(request);
            if (handler.isGoodLeaf()) {
                this.sendDynamicQuery(QueryHandler.createHandlerForNewLeaf(request, handler, counter), handler);
            } else {
                this.sendDynamicQuery(QueryHandler.createHandlerForOldLeaf(request, handler, counter), handler);
            }
        } else if (request.getTTL() > 0 && RouterService.isSupernode()) {
            if (handler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(request, handler);
            } else {
                this.forwardLimitedQueryToUltrapeers(request, handler);
            }
        }
        if (locallyEvaluate) {
            this.forwardQueryRequestToLeaves(request, handler);
            if (request.isFirewalledSource() && !RouterService.acceptedIncomingConnection() && !ApplicationSettings.SERVER.getValue()) {
                return;
            }
            this.respondToQueryRequest(request, this._clientGUID, handler);
        }
    }

    protected void handleLimeACKMessage(LimeACKVendorMessage ack, DatagramPacket datagram) {
        GUID.TimedGUID refGUID = new GUID.TimedGUID(new GUID(ack.getGUID()), 25000L);
        QueryResponseBundle bundle = (QueryResponseBundle)this._outOfBandReplies.remove((Object)refGUID);
        if (bundle != null && ack.getNumResults() > 0) {
            InetAddress addr = datagram.getAddress();
            int port = datagram.getPort();
            Iterator iterator = null;
            if (ack.getNumResults() < bundle._responses.length) {
                Response[] desired = new Response[ack.getNumResults()];
                for (int i = 0; i < desired.length; ++i) {
                    desired[i] = bundle._responses[i];
                }
                iterator = this.responsesToQueryReplies(desired, bundle._query, 1);
            } else {
                iterator = this.responsesToQueryReplies(bundle._responses, bundle._query, 1);
            }
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                UDPService.instance().send(queryReply, addr, port);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReplyNumberMessage(ReplyNumberVendorMessage reply, DatagramPacket datagram) {
        GUID qGUID = new GUID(reply.getGUID());
        int numResults = RouterService.getSearchResultHandler().getNumResultsForQuery(qGUID);
        if (numResults < 0) {
            numResults = this.DYNAMIC_QUERIER.getLeafResultsForQuery(qGUID);
        }
        if (numResults < 0 || numResults > 150) {
            if (RECORD_STATS) {
                OutOfBandThroughputStat.RESPONSES_BYPASSED.addData(reply.getNumResults());
            }
            DownloadManager dManager = RouterService.getDownloadManager();
            if (!this._callback.isQueryAlive(qGUID) && !dManager.isGuidForQueryDownloading(qGUID)) {
                return;
            }
            GUESSEndpoint ep = new GUESSEndpoint(datagram.getAddress(), datagram.getPort());
            Map map = this._bypassedResults;
            synchronized (map) {
                Set eps = (Set)this._bypassedResults.get((Object)qGUID);
                if (eps == null) {
                    eps = new HashSet();
                    this._bypassedResults.put((Object)qGUID, (Object)eps);
                }
                if (this._bypassedResults.size() <= 150) {
                    eps.add((Object)ep);
                }
            }
            return;
        }
        LimeACKVendorMessage ack = new LimeACKVendorMessage(qGUID, reply.getNumResults());
        UDPService.instance().send(ack, datagram.getAddress(), datagram.getPort());
        if (RECORD_STATS) {
            OutOfBandThroughputStat.RESPONSES_REQUESTED.addData(reply.getNumResults());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bufferResponsesForLaterDelivery(QueryRequest query, Response[] resps) {
        Map map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MAX_BUFFERED_REPLIES) {
                GUID.TimedGUID tGUID = new GUID.TimedGUID(new GUID(query.getGUID()), 25000L);
                this._outOfBandReplies.put((Object)tGUID, (Object)new QueryResponseBundle(query, resps));
                return true;
            }
            return false;
        }
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage udp, Connection source) {
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        UDPConnectBackRedirect msg = new UDPConnectBackRedirect(guidToUse, sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList peers = new ArrayList((Collection)_manager.getInitializedConnections());
        Collections.shuffle((List)peers);
        Iterator i = peers.iterator();
        while (i.hasNext() && sentTo < 5) {
            ManagedConnection currMC = (ManagedConnection)i.next();
            if (currMC == source || currMC.remoteHostSupportsUDPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect udp, Connection source) {
        if (!source.isSupernodeSupernodeConnection()) {
            return;
        }
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress addrToContact = udp.getConnectBackAddress();
        Endpoint endPoint = new Endpoint(addrToContact.getAddress(), portToContact);
        if (_manager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        String addrString = addrToContact.getHostAddress();
        Object placeHolder = _udpConnectBacks.get(addrString);
        if (placeHolder == null) {
            try {
                _udpConnectBacks.put(addrString, new Object());
            }
            catch (NoMoreStorageException nomo) {
                return;
            }
        } else {
            return;
        }
        PingRequest pr = new PingRequest(guidToUse.bytes(), 1, 0);
        UDPService.instance().send(pr, addrToContact, portToContact);
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tcp, Connection source) {
        int portToContact = tcp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        TCPConnectBackRedirect msg = new TCPConnectBackRedirect(sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList peers = new ArrayList((Collection)_manager.getInitializedConnections());
        Collections.shuffle((List)peers);
        Iterator i = peers.iterator();
        while (i.hasNext() && sentTo < 5) {
            ManagedConnection currMC = (ManagedConnection)i.next();
            if (currMC == source || currMC.remoteHostSupportsTCPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tcp, Connection source) {
        if (!source.isSupernodeSupernodeConnection()) {
            return;
        }
        final int portToContact = tcp.getConnectBackPort();
        final String addrToContact = tcp.getConnectBackAddress().getHostAddress();
        Endpoint endPoint = new Endpoint(addrToContact, portToContact);
        if (_manager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        Object placeHolder = _tcpConnectBacks.get(addrToContact);
        if (placeHolder == null) {
            try {
                _tcpConnectBacks.put(addrToContact, new Object());
            }
            catch (NoMoreStorageException nomo) {
                return;
            }
        } else {
            return;
        }
        TCP_CONNECT_BACKER.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Socket sock = null;
                try {
                    sock = Sockets.connect(addrToContact, portToContact, 12000);
                    OutputStream os = sock.getOutputStream();
                    os.write("CONNECT BACK\r\n\r\n".getBytes());
                    os.flush();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (IOException ignored) {
                    IOUtils.close(sock);
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                    {
                        catch (Throwable throwable) {
                            IOUtils.close(sock);
                            throw throwable;
                        }
                    }
                    IOUtils.close(sock);
                }
                IOUtils.close(sock);
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest ppReq, ManagedConnection source) {
        if (source.isSupernodeClientConnection() && RouterService.isIpPortValid()) {
            String stringAddr = NetworkUtils.ip2string(RouterService.getAddress());
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(stringAddr);
            }
            catch (UnknownHostException uhe) {
                ErrorService.error(uhe);
            }
            PushProxyAcknowledgement ack = new PushProxyAcknowledgement(addr, RouterService.getPort(), ppReq.getClientGUID());
            source.send(ack);
            this._pushRouteTable.routeReply(ppReq.getClientGUID().bytes(), source);
        }
    }

    protected void handleQueryStatus(QueryStatusResponse resp, ManagedConnection leaf) {
        if (!leaf.isSupernodeClientConnection()) {
            return;
        }
        GUID queryGUID = resp.getQueryGUID();
        int numResults = resp.getNumResults();
        this.DYNAMIC_QUERIER.updateLeafResultsForQuery(queryGUID, numResults);
    }

    public void sendPingRequest(PingRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null ping");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._pingRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void sendQueryRequest(QueryRequest request, ManagedConnection connection) {
        if (request == null) {
            throw new NullPointerException("null query");
        }
        if (connection == null) {
            throw new NullPointerException("null connection");
        }
        this._queryRouteTable.routeReply(request.getGUID(), this.FOR_ME_REPLY_HANDLER);
        connection.send(request);
    }

    public void broadcastPingRequest(PingRequest ping) {
        if (ping == null) {
            throw new NullPointerException("null ping");
        }
        this._pingRouteTable.routeReply(ping.getGUID(), this.FOR_ME_REPLY_HANDLER);
        this.broadcastPingRequest(ping, this.FOR_ME_REPLY_HANDLER, _manager);
    }

    public void sendDynamicQuery(QueryRequest query) {
        if (query == null) {
            throw new NullPointerException("null QueryHandler");
        }
        ResultCounter counter = this._queryRouteTable.routeReply(query.getGUID(), this.FOR_ME_REPLY_HANDLER);
        if (RouterService.isSupernode()) {
            this.sendDynamicQuery(QueryHandler.createHandlerForMe(query, counter), this.FOR_ME_REPLY_HANDLER);
        } else {
            this.originateLeafQuery(query);
        }
        this.multicastQueryRequest(QueryRequest.createMulticastQuery(query));
    }

    private void sendDynamicQuery(QueryHandler qh, ReplyHandler handler) {
        if (qh == null) {
            throw new NullPointerException("null QueryHandler");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        this.DYNAMIC_QUERIER.addQuery(qh);
    }

    private void broadcastPingRequest(PingRequest request, ReplyHandler receivingConnection, ConnectionManager manager) {
        List list = manager.getInitializedConnections();
        int size = list.size();
        boolean randomlyForward = false;
        if (size > 3) {
            randomlyForward = true;
        }
        for (int i = 0; i < size; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (!mc.isStable() || receivingConnection != this.FOR_ME_REPLY_HANDLER && (mc == receivingConnection || mc.isClientSupernodeConnection())) continue;
            double percentToIgnore = mc.supportsPongCaching() ? 0.7 : 0.9;
            if (randomlyForward && Math.random() < percentToIgnore) continue;
            mc.send(request);
        }
    }

    public final void forwardQueryRequestToLeaves(QueryRequest query, ReplyHandler handler) {
        if (!RouterService.isSupernode()) {
            return;
        }
        List list = _manager.getInitializedClientConnections();
        ArrayList hitConnections = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc == handler || !mc.shouldForwardQuery(query)) continue;
            hitConnections.add((Object)mc);
        }
        if (list.size() > 8 && (double)hitConnections.size() / (double)list.size() > 0.8) {
            int startIndex = (int)Math.floor(Math.random() * (double)hitConnections.size() * 0.75);
            hitConnections = hitConnections.subList(startIndex, startIndex + hitConnections.size() / 4);
        }
        int notSent = list.size() - hitConnections.size();
        RoutedQueryStat.LEAF_DROP.addData(notSent);
        for (int i = 0; i < hitConnections.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)hitConnections.get(i);
            this.sendQueryRequest(query, mc, handler);
            RoutedQueryStat.LEAF_SEND.incrementStat();
        }
    }

    private boolean sendRoutedQueryToHost(QueryRequest query, ManagedConnection mc, ReplyHandler handler) {
        if (mc.shouldForwardQuery(query)) {
            this.sendQueryRequest(query, mc, handler);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest query, ReplyHandler conn) {
        query.setTTL((byte)1);
        this.UNICASTER.addQuery(query, conn);
    }

    protected void multicastQueryRequest(QueryRequest query) {
        query.setTTL((byte)1);
        if (RECORD_STATS) {
            SentMessageStatHandler.MULTICAST_QUERY_REQUESTS.addMessage(query);
        }
        MulticastService.instance().send(query);
    }

    private void forwardQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections();
        int limit = list.size();
        for (int i = 0; i < limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            this.forwardQueryToUltrapeer(query, handler, mc);
        }
    }

    private void forwardLimitedQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List list = _manager.getInitializedConnections();
        int limit = list.size();
        int connectionsNeededForOld = 15;
        for (int i = 0; i < limit && connectionsNeededForOld != 0; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            if (mc.isGoodUltrapeer() && limit - i > connectionsNeededForOld) continue;
            this.forwardQueryToUltrapeer(query, handler, mc);
            --connectionsNeededForOld;
        }
    }

    private void forwardQueryToUltrapeer(QueryRequest query, ReplyHandler handler, ManagedConnection ultrapeer) {
        boolean lastHop;
        if (ultrapeer == handler) {
            return;
        }
        if (ultrapeer.isClientSupernodeConnection()) {
            return;
        }
        if (query.getCapabilitySelector() > 0 && ultrapeer.getRemoteHostCapabilitySelector() < 1) {
            return;
        }
        boolean bl = lastHop = query.getTTL() == 1;
        if (lastHop && ultrapeer.isUltrapeerQueryRoutingConnection()) {
            boolean sent = this.sendRoutedQueryToHost(query, ultrapeer, handler);
            if (sent && RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_SEND.incrementStat();
            } else if (RECORD_STATS) {
                RoutedQueryStat.ULTRAPEER_DROP.incrementStat();
            }
        } else {
            this.sendQueryRequest(query, ultrapeer, handler);
        }
    }

    private void originateLeafQuery(QueryRequest qr) {
        List list = _manager.getInitializedConnections();
        int max = qr.isWhatIsNewRequest() ? 2 : 4;
        int start = !qr.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int limit = Math.min(max, list.size());
        boolean wantsOOB = qr.desiresOutOfBandReplies();
        for (int i = start; i < start + limit; ++i) {
            ManagedConnection mc = (ManagedConnection)list.get(i);
            QueryRequest qrToSend = qr;
            if (wantsOOB && mc.remoteHostSupportsLeafGuidance() < 0) {
                qrToSend = QueryRequest.unmarkOOBQuery(qr);
            }
            this.sendQueryRequest(qrToSend, mc, this.FOR_ME_REPLY_HANDLER);
        }
    }

    public void sendQueryRequest(QueryRequest request, ManagedConnection sendConnection, ReplyHandler handler) {
        if (request == null) {
            throw new NullPointerException("null query");
        }
        if (sendConnection == null) {
            throw new NullPointerException("null send connection");
        }
        if (handler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (handler == this.FOR_ME_REPLY_HANDLER || MessageRouter.containsDefaultUnauthenticatedDomainOnly(sendConnection.getDomains()) || Utilities.hasIntersection(handler.getDomains(), sendConnection.getDomains())) {
            sendConnection.send(request);
        }
    }

    public boolean originateQuery(QueryRequest query, ManagedConnection mc) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (mc == null) {
            throw new NullPointerException("null connection");
        }
        if (query.getCapabilitySelector() > 0 && mc.getRemoteHostCapabilitySelector() < 1) {
            return false;
        }
        mc.originateQuery(query);
        return true;
    }

    private static boolean containsDefaultUnauthenticatedDomainOnly(Set domains) {
        return domains.size() == 1 && domains.contains((Object)"__DEFAULT_UNAUTHENTICATED_DOMAIN__");
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, DatagramPacket var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply reply, ReplyHandler handler) {
        ReplyHandler replyHandler;
        boolean newAddress = RouterService.getHostCatcher().add(reply);
        if (newAddress && !reply.isUDPHostCache()) {
            PongCacher.instance().addPong(reply);
        }
        if ((replyHandler = this._pingRouteTable.getReplyHandler(reply.getGUID())) != null) {
            replyHandler.handlePingReply(reply, handler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PING_REPLY_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
        boolean supportsUnicast = reply.supportsUnicast();
        if (newAddress && (reply.isUltrapeer() || supportsUnicast)) {
            List list = _manager.getInitializedClientConnections();
            for (int i = 0; i < list.size(); ++i) {
                ManagedConnection c = (ManagedConnection)list.get(i);
                Assert.that(c != null, "null c.");
                if (c == handler || c == replyHandler || !c.allowNewPongs()) continue;
                c.handlePingReply(reply, handler);
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler handler) {
        if (queryReply == null) {
            throw new NullPointerException("null query reply");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (rrp != null) {
            queryReply.setPriority(rrp.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), handler);
            ReplyHandler rh = rrp.getReplyHandler();
            if (!this.shouldDropReply(rrp, rh, queryReply)) {
                rh.handleQueryReply(queryReply, handler);
                this.UNICASTER.handleQueryReply(queryReply);
            } else {
                if (RECORD_STATS) {
                    RouteErrorStat.HARD_LIMIT_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
                    byte ttl = queryReply.getTTL();
                    if (ttl < RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length) {
                        RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[ttl].incrementStat();
                    } else {
                        RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL[RouteErrorStat.HARD_LIMIT_QUERY_REPLY_TTL.length - 1].incrementStat();
                    }
                }
                handler.countDroppedMessage();
            }
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.NO_ROUTE_QUERY_REPLY_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair rrp, ReplyHandler rh, QueryReply qr) {
        byte ttl = qr.getTTL();
        if (rh == this.FOR_ME_REPLY_HANDLER) {
            return false;
        }
        if (ttl == 0) {
            return true;
        }
        int resultsRouted = rrp.getResultsRouted();
        if (resultsRouted > 100) {
            return true;
        }
        int bytesRouted = rrp.getBytesRouted();
        if (ttl > 2 && bytesRouted < 51200) {
            return false;
        }
        if (ttl == 1 && bytesRouted < 204800) {
            return false;
        }
        return ttl != 2 || bytesRouted >= 102400;
    }

    private void handleGiveStats(GiveStatsVendorMessage gsm, ReplyHandler replyHandler) {
        StatisticVendorMessage statVM = null;
        try {
            if (StatisticVendorMessage.isSupported(gsm)) {
                statVM = new StatisticVendorMessage(gsm);
                replyHandler.handleStatisticVM(statVM);
            }
        }
        catch (IOException iox) {
            return;
        }
    }

    private void handleStatisticsMessage(final StatisticVendorMessage svm, ReplyHandler handler) {
        if (StatisticsSettings.RECORD_VM_STATS.getValue()) {
            ManagedThread statHandler = new ManagedThread("Stat writer "){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void managedRun() {
                    RandomAccessFile file = null;
                    file = new RandomAccessFile("stats_log.log", "rw");
                    file.seek(file.length());
                    file.writeBytes(svm.getReportedStats() + "\n");
                    Object var4_2 = null;
                    if (file == null) return;
                    try {
                        file.close();
                        return;
                    }
                    catch (IOException iox2) {
                        ErrorService.error(iox2);
                    }
                    return;
                    {
                        catch (IOException iox) {
                            ErrorService.error(iox);
                            Object var4_3 = null;
                            if (file == null) return;
                            try {
                                file.close();
                                return;
                            }
                            catch (IOException iox2) {
                                ErrorService.error(iox2);
                            }
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (file == null) throw throwable;
                        try {
                            file.close();
                            throw throwable;
                        }
                        catch (IOException iox2) {
                            ErrorService.error(iox2);
                        }
                        throw throwable;
                    }
                }
            };
            statHandler.start();
        }
    }

    protected void handlePushRequest(PushRequest request, ReplyHandler handler) {
        if (request == null) {
            throw new NullPointerException("null request");
        }
        if (handler == null) {
            throw new NullPointerException("null ReplyHandler");
        }
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(request.getClientGUID());
        if (replyHandler != null) {
            replyHandler.handlePushRequest(request, handler);
        } else {
            if (RECORD_STATS) {
                RouteErrorStat.PUSH_REQUEST_ROUTE_ERRORS.incrementStat();
            }
            handler.countDroppedMessage();
        }
    }

    protected void sendPingReply(PingReply pong, ReplyHandler handler) {
        if (pong == null) {
            throw new NullPointerException("null pong");
        }
        if (handler == null) {
            throw new NullPointerException("null reply handler");
        }
        handler.handlePingReply(pong, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        if (queryReply == null) {
            throw new NullPointerException("null reply");
        }
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount());
        if (rrp == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(rrp.getBytesRouted());
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this.FOR_ME_REPLY_HANDLER);
        rrp.getReplyHandler().handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest push) throws IOException {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(push.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(push, this.FOR_ME_REPLY_HANDLER);
    }

    protected void sendMulticastPushRequest(PushRequest push) {
        if (push == null) {
            throw new NullPointerException("null push");
        }
        Assert.that(push.getTTL() == 1, "multicast push ttl not 1");
        MulticastService.instance().send(push);
        SentMessageStatHandler.MULTICAST_PUSH_REQUESTS.addMessage(push);
    }

    public Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responses, queryRequest, 10);
    }

    private Iterator responsesToQueryReplies(Response[] responses, QueryRequest queryRequest, int REPLY_LIMIT) {
        int i;
        LinkedList queryReplies = new LinkedList();
        byte[] guid = queryRequest.getGUID();
        byte ttl = (byte)(queryRequest.getHops() + 1);
        UploadManager um = RouterService.getUploadManager();
        long speed = um.measuredUploadSpeed();
        boolean measuredSpeed = true;
        if (speed == -1L) {
            speed = ConnectionSettings.CONNECTION_SPEED.getValue();
            measuredSpeed = false;
        }
        int numResponses = responses.length;
        int index = 0;
        byte numHops = queryRequest.getHops();
        if (REPLY_LIMIT > 1 && numHops > 2 && numResponses > 10) {
            int j = (int)(Math.random() * (double)numResponses) % (numResponses - 10);
            Response[] newResponses = new Response[10];
            i = 0;
            while (i < 10) {
                newResponses[i] = responses[j];
                ++i;
                ++j;
            }
            responses = newResponses;
            numResponses = responses.length;
        }
        while (numResponses > 0) {
            boolean mcast;
            Response[] res;
            int arraySize = numResponses < REPLY_LIMIT ? numResponses : REPLY_LIMIT;
            if (index == 0 && arraySize < REPLY_LIMIT) {
                res = responses;
            } else {
                res = new Response[arraySize];
                for (i = 0; i < arraySize; ++i) {
                    res[i] = responses[index];
                    ++index;
                }
            }
            numResponses -= arraySize;
            boolean busy = !um.isServiceable();
            boolean uploaded = um.hadSuccesfulUpload();
            boolean bl = mcast = queryRequest.isMulticast() && queryRequest.getTTL() + queryRequest.getHops() == 1;
            if (mcast) {
                ttl = 1;
            }
            List replies = this.createQueryReply(guid, ttl, speed, res, this._clientGUID, busy, uploaded, measuredSpeed, mcast);
            queryReplies.addAll((Collection)replies);
        }
        return queryReplies.iterator();
    }

    protected abstract List createQueryReply(byte[] var1, byte var2, long var3, Response[] var5, byte[] var6, boolean var7, boolean var8, boolean var9, boolean var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage rtm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.resetQueryRouteTable(rtm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage ptm, ManagedConnection mc) {
        if (!MessageRouter.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.patchQueryRouteTable(ptm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = MessageRouter.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest request, ReplyHandler handler) {
        if (!(handler instanceof Connection)) {
            return;
        }
        Connection c = (Connection)((Object)handler);
        if (request.getHops() == 1 && c.isOldLimeWire()) {
            if (StaticMessages.updateReply == null) {
                return;
            }
            QueryReply qr = new QueryReply(request.getGUID(), StaticMessages.updateReply);
            try {
                this.sendQueryReply(qr);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    private static boolean isQRPConnection(Connection c) {
        if (c.isSupernodeClientConnection()) {
            return true;
        }
        return c.isUltrapeerQueryRoutingConnection();
    }

    private void forwardQueryRouteTables() {
        long time = System.currentTimeMillis();
        List list = _manager.getInitializedConnections();
        QueryRouteTable table = null;
        List patches = null;
        QueryRouteTable lastSent = null;
        for (int i = 0; i < list.size(); ++i) {
            ManagedConnection c = (ManagedConnection)list.get(i);
            if (!RouterService.isSupernode() ? !c.isClientSupernodeConnection() || !c.isQueryRoutingEnabled() : !c.isUltrapeerQueryRoutingConnection()) continue;
            if (time < c.getNextQRPForwardTime()) continue;
            c.incrementNextQRPForwardTime(time);
            if (table == null) {
                this._lastQueryRouteTable = table = MessageRouter.createRouteTable();
            }
            if (lastSent == c.getQueryRouteTableSent()) {
                if (patches == null) {
                    patches = table.encode(lastSent, true);
                }
            } else {
                lastSent = c.getQueryRouteTableSent();
                patches = table.encode(lastSent, true);
            }
            if (!ConnectionSettings.SEND_QRP.getValue()) {
                return;
            }
            Iterator iter = patches.iterator();
            while (iter.hasNext()) {
                c.send((RouteTableMessage)iter.next());
            }
            c.setQueryRouteTableSent(table);
        }
    }

    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    private static QueryRouteTable createRouteTable() {
        QueryRouteTable ret = _fileManager.getQRT();
        if (RouterService.isSupernode()) {
            MessageRouter.addQueryRoutingEntriesForLeaves(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addQueryRoutingEntriesForLeaves(QueryRouteTable qrt) {
        List leaves = _manager.getInitializedClientConnections();
        for (int i = 0; i < leaves.size(); ++i) {
            ManagedConnection mc = (ManagedConnection)leaves.get(i);
            Object object = mc.getQRPLock();
            synchronized (object) {
                QueryRouteTable qrtr = mc.getQueryRouteTableReceived();
                if (qrtr != null) {
                    qrt.addAll(qrtr);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageListener(byte[] guid, MessageListener ml) {
        ml.registered(guid);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap listeners = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            listeners.putAll(this._messageListeners);
            List all = (List)listeners.get((Object)guid);
            if (all == null) {
                all = new ArrayList(1);
                all.add((Object)ml);
            } else {
                ArrayList temp = new ArrayList(all.size() + 1);
                temp.addAll((Collection)all);
                all = temp;
                all.add((Object)ml);
            }
            listeners.put((Object)guid, (Object)Collections.unmodifiableList((List)all));
            this._messageListeners = Collections.unmodifiableMap((Map)listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMessageListener(byte[] guid, MessageListener ml) {
        boolean removed = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            List all = (List)this._messageListeners.get((Object)guid);
            if (all != null && (all = new ArrayList((Collection)all)).remove((Object)ml)) {
                removed = true;
                TreeMap listeners = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
                listeners.putAll(this._messageListeners);
                if (all.isEmpty()) {
                    listeners.remove((Object)guid);
                } else {
                    listeners.put((Object)guid, (Object)Collections.unmodifiableList((List)all));
                }
                this._messageListeners = Collections.unmodifiableMap((Map)listeners);
            }
        }
        if (removed) {
            ml.unregistered(guid);
        }
    }

    private void handleUDPCrawlerPing(UDPCrawlerPing msg, ReplyHandler handler) {
        if (!this._promotionManager.allowUDPPing(handler)) {
            return;
        }
        UDPCrawlerPong newMsg = new UDPCrawlerPong(msg);
        handler.handleUDPCrawlerPong(newMsg);
    }

    static {
        MAX_BUFFERED_REPLIES = 250;
        _udpConnectBacks = new FixedsizeHashMap(200);
        _tcpConnectBacks = new FixedsizeHashMap(200);
        TCP_CONNECT_BACKER = new ProcessingQueue("TCPConnectBack");
        RECORD_STATS = !CommonUtils.isJava118();
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        public void run() {
            try {
                _tcpConnectBacks.clear();
                _udpConnectBacks.clear();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashSet toRemove = new HashSet();
                Map map = MessageRouter.this._outOfBandReplies;
                synchronized (map) {
                    Iterator keys = MessageRouter.this._outOfBandReplies.keySet().iterator();
                    while (keys.hasNext()) {
                        GUID.TimedGUID currQB = (GUID.TimedGUID)keys.next();
                        if (currQB == null || !currQB.shouldExpire()) continue;
                        toRemove.add((Object)currQB);
                    }
                    keys = toRemove.iterator();
                    while (keys.hasNext()) {
                        MessageRouter.this._outOfBandReplies.remove(keys.next());
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest query, Response[] responses) {
            this._query = query;
            this._responses = responses;
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        public void managedRun() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouter.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                return;
            }
        }
    }
}

