/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.MessageCallback;
import com.limegroup.gnutella.settings.BooleanSetting;

public class MessageService {
    private static MessageCallback _callback = new ShellMessageService();

    private MessageService() {
    }

    public static void setCallback(MessageCallback callback) {
        _callback = callback;
    }

    public static void showError(String messageKey) {
        _callback.showError(messageKey);
    }

    public static void showError(String messageKey, BooleanSetting ignore) {
        _callback.showError(messageKey, ignore);
    }

    public static void showError(String messageKey, String message) {
        _callback.showError(messageKey, message);
    }

    public static void showError(String messageKey, String message, BooleanSetting ignore) {
        _callback.showError(messageKey, message, ignore);
    }

    public static void showMessage(String messageKey) {
        _callback.showMessage(messageKey);
    }

    public static void showMessage(String messageKey, BooleanSetting ignore) {
        _callback.showMessage(messageKey, ignore);
    }

    private static final class ShellMessageService
    implements MessageCallback {
        private ShellMessageService() {
        }

        public void showError(String messageKey) {
            System.out.println("error key: " + messageKey);
        }

        public void showError(String messageKey, BooleanSetting ignore) {
            System.out.println("error key: " + messageKey);
        }

        public void showError(String messageKey, String message) {
            System.out.println("error key: " + messageKey + " extra message: " + message);
        }

        public void showError(String messageKey, String message, BooleanSetting ignore) {
            System.out.println("error key: " + messageKey + " extra message: " + message);
        }

        public void showMessage(String messageKey) {
            System.out.println("message key: " + messageKey);
        }

        public void showMessage(String messageKey, BooleanSetting ignore) {
            System.out.println("message key: " + messageKey);
        }
    }
}

