/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.BucketQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;

public final class PongCacher {
    private static final PongCacher INSTANCE = new PongCacher();
    public static final int NUM_PONGS_PER_HOP = 1;
    public static final int NUM_HOPS = 6;
    public static final int EXPIRE_TIME = 6000;
    public static final int EXPIRE_TIME_LOC = 90000;
    private static final Map PONGS = new HashMap();

    public static PongCacher instance() {
        return INSTANCE;
    }

    private PongCacher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBestPongs(String loc) {
        Map map = PONGS;
        synchronized (map) {
            LinkedList pongs = new LinkedList();
            long curTime = System.currentTimeMillis();
            List removeList = this.addBestPongs(loc, (List)pongs, curTime, 0);
            this.removePongs(loc, removeList);
            if (!ApplicationSettings.DEFAULT_LOCALE.getValue().equals(loc) && pongs.size() < 6) {
                removeList = this.addBestPongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), (List)pongs, curTime, pongs.size());
                this.removePongs(ApplicationSettings.DEFAULT_LOCALE.getValue(), removeList);
            }
            return pongs;
        }
    }

    private List addBestPongs(String loc, List pongs, long curTime, int i) {
        int exp_time = ApplicationSettings.DEFAULT_LOCALE.getValue().equals(loc) ? 6000 : 90000;
        LinkedList remove = null;
        if (PONGS.containsKey((Object)loc)) {
            BucketQueue bq = (BucketQueue)PONGS.get((Object)loc);
            Iterator iter = bq.iterator();
            while (iter.hasNext() && i < 6) {
                PingReply pr = (PingReply)iter.next();
                if (curTime - pr.getCreationTime() > (long)exp_time) {
                    if (remove == null) {
                        remove = new LinkedList();
                    }
                    remove.add((Object)pr);
                } else {
                    pongs.add((Object)pr);
                }
                ++i;
            }
        }
        return remove;
    }

    private void removePongs(String loc, List l) {
        if (l != null) {
            BucketQueue bq = (BucketQueue)PONGS.get((Object)loc);
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                PingReply pr = (PingReply)iter.next();
                bq.removeAll(pr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PingReply pr) {
        if (!RouterService.isSupernode()) {
            return;
        }
        if (!pr.isUltrapeer()) {
            return;
        }
        if (pr.getHops() >= 6) {
            return;
        }
        Map map = PONGS;
        synchronized (map) {
            if (PONGS.containsKey((Object)pr.getClientLocale())) {
                BucketQueue bq = (BucketQueue)PONGS.get((Object)pr.getClientLocale());
                bq.insert(pr, pr.getHops());
            } else {
                BucketQueue bq = new BucketQueue(6, 1);
                bq.insert(pr, pr.getHops());
                PONGS.put((Object)pr.getClientLocale(), (Object)bq);
            }
        }
    }
}

