/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.net.InetAddress;

public final class QueryUnicaster {
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 30;
    public static final long ONE_HOUR = 3600000L;
    private static final QueryUnicaster _instance = new QueryUnicaster();
    private Thread _querier = null;
    private boolean _shouldRun = true;
    private Map _queries;
    private Map _querySets;
    private LinkedList _queryHosts;
    private Map _queryKeys;
    private Buffer _pingList;
    private List _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private final boolean RECORD_STATS = !CommonUtils.isJava118();
    private boolean _initialized = false;
    private static final boolean debugOn = false;

    public static QueryUnicaster instance() {
        return _instance;
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnicastEndpoints() {
        ArrayList retList = new ArrayList();
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): obtained lock.");
            int size = this._queryHosts.size();
            if (size > 0) {
                int max = size > 10 ? 10 : size;
                for (int i = 0; i < max; ++i) {
                    retList.add(this._queryHosts.get(i));
                }
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastEndpoints(): releasing lock.");
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.isEmpty()) {
                return null;
            }
            return (GUESSEndpoint)this._queryHosts.getFirst();
        }
    }

    private QueryUnicaster() {
        this._queries = new Hashtable();
        this._queryHosts = new LinkedList();
        this._queryKeys = new Hashtable();
        this._pingList = new Buffer(25);
        this._querySets = new Hashtable();
        this._qGuidsToRemove = new Vector();
        this._querier = new ManagedThread(){

            public void managedRun() {
                try {
                    QueryUnicaster.this.queryLoop();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        this._querier.setName("QueryUnicaster");
        this._querier.setDaemon(true);
    }

    public synchronized void start() {
        if (!this._initialized) {
            this._querier.start();
            QueryKeyExpirer expirer = new QueryKeyExpirer();
            RouterService.schedule(expirer, 0L, 10800000L);
            this._initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLoop() {
        UDPService udpService = UDPService.instance();
        while (this._shouldRun) {
            try {
                this.waitForQueries();
                GUESSEndpoint toQuery = this.getUnicastHost();
                if (!this._queryKeys.containsKey((Object)toQuery)) {
                    PingRequest pr = PingRequest.createQueryKeyRequest();
                    udpService.send(pr, toQuery.getAddress(), toQuery.getPort());
                    if (!this.RECORD_STATS) continue;
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pr);
                    continue;
                }
                QueryKey queryKey = ((QueryKeyBundle)this._queryKeys.get((Object)toQuery))._queryKey;
                this.purgeGuidsInternal();
                boolean currentHostUsed = false;
                Map map = this._queries;
                synchronized (map) {
                    Iterator iter = this._queries.values().iterator();
                    while (iter.hasNext()) {
                        QueryBundle currQB = (QueryBundle)iter.next();
                        if (currQB._numResults > 250 || currQB._hostsQueried.size() > 1000) {
                            this._qGuidsToRemove.add((Object)new GUID(currQB._qr.getGUID()));
                            continue;
                        }
                        if (currQB._hostsQueried.contains((Object)toQuery)) continue;
                        InetAddress ip = toQuery.getAddress();
                        QueryRequest qrToSend = QueryRequest.createQueryKeyQuery(currQB._qr, queryKey);
                        udpService.send(qrToSend, ip, toQuery.getPort());
                        currentHostUsed = true;
                        if (this.RECORD_STATS) {
                            SentMessageStatHandler.UDP_QUERY_REQUESTS.addMessage(qrToSend);
                        }
                        currQB._hostsQueried.add((Object)toQuery);
                    }
                }
                if (!currentHostUsed) {
                    this.addUnicastEndpoint(toQuery);
                }
                map = this._qGuidsToRemove;
                synchronized (map) {
                    this.purgeGuidsInternal();
                    this._qGuidsToRemove.clear();
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeGuidsInternal() {
        List list = this._qGuidsToRemove;
        synchronized (list) {
            Iterator removee = this._qGuidsToRemove.iterator();
            while (removee.hasNext()) {
                GUID currGuid = (GUID)removee.next();
                this._queries.remove((Object)currGuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueries() throws InterruptedException {
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): waiting for Queries.");
        Map map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        QueryUnicaster.debug("QueryUnicaster.waitForQueries(): numQueries = " + this._queries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQuery(QueryRequest query, ReplyHandler reference) {
        QueryUnicaster.debug("QueryUnicaster.addQuery(): entered.");
        boolean retBool = false;
        GUID guid = new GUID(query.getGUID());
        Map map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey((Object)guid)) {
                QueryBundle qb = new QueryBundle(query);
                this._queries.put((Object)guid, (Object)qb);
                retBool = true;
            }
            if (retBool) {
                this._queries.notifyAll();
            }
        }
        if (reference == null) {
            return retBool;
        }
        map = this._querySets;
        synchronized (map) {
            Set guids = (Set)this._querySets.get((Object)reference);
            if (guids == null) {
                guids = new HashSet();
                this._querySets.put((Object)reference, (Object)guids);
            }
            guids.add((Object)guid);
        }
        QueryUnicaster.debug("QueryUnicaster.addQuery(): returning " + retBool);
        return retBool;
    }

    public void addUnicastEndpoint(InetAddress address, int port) {
        if (!SearchSettings.GUESS_ENABLED.getValue()) {
            return;
        }
        if (this.notMe(address, port) && NetworkUtils.isValidPort(port) && NetworkUtils.isValidAddress(address)) {
            GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
            this.addUnicastEndpoint(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnicastEndpoint(GUESSEndpoint endpoint) {
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): obtained lock.");
            if (this._queryHosts.size() == 30) {
                this._queryHosts.removeLast();
            }
            this._queryHosts.addFirst((Object)endpoint);
            this._queryHosts.notify();
            if (!(!UDPService.instance().isListening() || RouterService.isGUESSCapable() || this._testUDPPingsSent >= 10 || ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isCloseIP(RouterService.getAddress(), endpoint.getAddress().getAddress()))) {
                PingRequest pr = new PingRequest(UDPService.instance().getSolicitedGUID().bytes(), 1, 0);
                UDPService.instance().send(pr, endpoint.getAddress(), endpoint.getPort());
                if (this.RECORD_STATS) {
                    SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pr);
                }
                ++this._testUDPPingsSent;
            }
            QueryUnicaster.debug("QueryUnicaster.addUnicastEndpoint(): released lock.");
        }
    }

    private boolean notMe(InetAddress address, int port) {
        boolean retVal = true;
        if (port == RouterService.getPort() && Arrays.equals((byte[])address.getAddress(), (byte[])RouterService.getAddress())) {
            retVal = false;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeQuery(ReplyHandler reference) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): entered.");
        if (reference == null) {
            return;
        }
        Map map = this._querySets;
        synchronized (map) {
            Set guids = (Set)this._querySets.remove((Object)reference);
            if (guids == null) {
                return;
            }
            Iterator iter = guids.iterator();
            while (iter.hasNext()) {
                this.purgeQuery((GUID)iter.next());
            }
        }
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(RH): returning.");
    }

    void purgeQuery(GUID queryGUID) {
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): entered.");
        this._qGuidsToRemove.add((Object)queryGUID);
        QueryUnicaster.debug("QueryUnicaster.purgeQuery(GUID): returning.");
    }

    public void handleQueryReply(QueryReply qr) {
        this.addResults(new GUID(qr.getGUID()), qr.getResultCount());
    }

    public void handleQueryKeyPong(PingReply pr) {
        if (pr == null) {
            throw new NullPointerException("null pong");
        }
        QueryKey qk = pr.getQueryKey();
        if (qk == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress address = pr.getInetAddress();
        Assert.that(qk != null);
        int port = pr.getPort();
        GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
        this._queryKeys.put((Object)endpoint, (Object)new QueryKeyBundle(qk));
        this.addUnicastEndpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResults(GUID queryGUID, int numResultsToAdd) {
        Map map = this._queries;
        synchronized (map) {
            QueryBundle qb = (QueryBundle)this._queries.get((Object)queryGUID);
            if (qb != null) {
                qb._numResults += numResultsToAdd;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): waiting for hosts.");
        LinkedList linkedList = this._queryHosts;
        synchronized (linkedList) {
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): obtained lock.");
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    PingRequest pr = new PingRequest(ConnectionSettings.TTL.getValue());
                    RouterService.getMessageRouter().broadcastPingRequest(pr);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
            QueryUnicaster.debug("QueryUnicaster.getUnicastHost(): got a host, let go lock!");
        }
        if (this._queryHosts.size() < 25) {
            GUESSEndpoint toReturn = (GUESSEndpoint)this._queryHosts.removeLast();
            Buffer buffer = this._pingList;
            synchronized (buffer) {
                if (!this._pingList.contains(toReturn)) {
                    PingRequest pr = new PingRequest(1);
                    InetAddress ip = toReturn.getAddress();
                    UDPService.instance().send(pr, ip, toReturn.getPort());
                    this._pingList.add(toReturn);
                    if (this.RECORD_STATS) {
                        SentMessageStatHandler.UDP_PING_REQUESTS.addMessage(pr);
                    }
                }
            }
            return toReturn;
        }
        return (GUESSEndpoint)this._queryHosts.removeLast();
    }

    private static final void debug(String out) {
    }

    private static final void debug(Exception out) {
    }

    private class QueryKeyExpirer
    implements Runnable {
        private QueryKeyExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = QueryUnicaster.this._queryKeys;
            synchronized (map) {
                Set entries = QueryUnicaster.this._queryKeys.entrySet();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    QueryKeyBundle currQKB = (QueryKeyBundle)iter.next();
                    if (!currQKB.shouldExpire()) continue;
                    entries.remove((Object)currQKB);
                }
            }
        }
    }

    private static class QueryKeyBundle {
        public static final long QUERY_KEY_LIFETIME = 0x6DDD00L;
        final long _birthTime;
        final QueryKey _queryKey;

        public QueryKeyBundle(QueryKey qk) {
            this._queryKey = qk;
            this._birthTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._birthTime >= 0x6DDD00L;
        }

        public String toString() {
            return "{QueryKeyBundle: " + this._queryKey + " BirthTime = " + this._birthTime;
        }
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 250;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set _hostsQueried = new HashSet();

        public QueryBundle(QueryRequest qr) {
            this._qr = qr;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }
}

