/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class Response {
    private static final byte EXT_SEPERATOR = 28;
    private static final String EXT_STRING = "\u001c";
    private static final int MAX_LOCATIONS = 10;
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private String metadata;
    private byte[] metaBytes;
    private LimeXMLDocument document;
    private final Set urns;
    private final byte[] extBytes;
    private final Set otherLocations;
    private volatile RemoteFileDesc cachedRFD;
    private static final String AUDIOS_NAMESPACE = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\">";
    private static final String AUDIO_TITLE = "<audio title=\"";
    private static final String AUDIO_BITRATE = "bitrate=\"";
    private static final String AUDIO_SECONDS = "seconds=\"";
    private static final String AUDIOS_CLOSE = "</audio></audios>";
    private static final String QUOTE_SPACE = "\" ";
    private static final String CLOSE_TAG = "\">";
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";

    public Response(long index, long size, String name) {
        this(index, size, name, "", null, null, null, null);
    }

    public Response(long index, long size, String name, LimeXMLDocument doc) {
        this(index, size, name, Response.extractMetadata(doc), null, doc, null, null);
    }

    public Response(long index, long size, String name, String metadata) {
        this(index, size, name, metadata, null, null, null, null);
    }

    public Response(FileDesc fd) {
        this(fd.getIndex(), fd.getSize(), fd.getName(), "", fd.getUrns(), null, Response.getAsEndpoints(fd.getAlternateLocationCollection()), null);
    }

    private Response(long index, long size, String name, String metadata, Set urns, LimeXMLDocument doc, Set endpoints, byte[] extensions) {
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        this.index = index;
        this.size = size;
        this.name = name == null ? "" : name;
        byte[] temp = null;
        try {
            temp = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException namex) {
            ErrorService.error(namex);
        }
        this.nameBytes = temp;
        this.urns = urns == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)urns);
        this.otherLocations = endpoints == null ? DataUtils.EMPTY_SET : Collections.unmodifiableSet((Set)endpoints);
        this.extBytes = extensions != null ? extensions : Response.createExtBytes(this.urns, this.otherLocations);
        this.metadata = (metadata == null || metadata.equals("")) && doc != null ? Response.extractMetadata(doc) : (metadata == null ? "" : metadata.trim());
        Assert.that(this.metadata != null, "Null metadata");
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            ErrorService.error(ueex);
        }
        this.document = doc;
    }

    public static Response createFromStream(InputStream is) throws IOException {
        int c;
        long index = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        long size = ByteOrder.ubytes2long(ByteOrder.leb2int(is));
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + index);
        }
        if (size > Integer.MAX_VALUE || size < 0L) {
            throw new IOException("invalid size: " + size);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        String name = new String(baos.toByteArray(), "UTF-8");
        if (name.length() == 0) {
            throw new IOException("empty name in response");
        }
        baos.reset();
        while ((c = is.read()) != 0) {
            if (c == -1) {
                throw new IOException("EOF before null termination");
            }
            baos.write(c);
        }
        byte[] rawMeta = baos.toByteArray();
        String betweenNulls = new String(rawMeta);
        if (betweenNulls == null || betweenNulls.equals("")) {
            if (is.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return new Response(index, size, name);
        }
        StringTokenizer stok = new StringTokenizer(betweenNulls, EXT_STRING);
        HashSet urns = null;
        Set endpoints = null;
        String metaString = null;
        while (stok.hasMoreTokens()) {
            byte[] extBytes;
            String ext = stok.nextToken();
            if (URN.isUrn(ext)) {
                try {
                    URN urn = URN.createSHA1Urn(ext);
                    if (urns == null) {
                        urns = new HashSet(1);
                    }
                    urns.add((Object)urn);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if ((extBytes = ext.getBytes()) != null && extBytes.length > 1 && extBytes[0] == -61) {
                boolean readMore = false;
                if (stok.hasMoreTokens()) {
                    readMore = true;
                    StringBuffer sb = new StringBuffer(ext);
                    while (stok.hasMoreTokens()) {
                        sb.append(EXT_STRING);
                        sb.append(stok.nextToken());
                    }
                    extBytes = sb.toString().getBytes();
                }
                GGEP[] ggepBlocks = null;
                try {
                    if (!readMore) {
                        ggepBlocks = GGEP.read(extBytes, 0);
                    } else {
                        int[] end = new int[1];
                        ggepBlocks = GGEP.read(extBytes, 0, end);
                        if (end[0] != extBytes.length) {
                            stok = Response.recreateTokenizer(extBytes, end[0]);
                        }
                    }
                    endpoints = GGEPUtil.getLocations(ggepBlocks);
                    continue;
                }
                catch (BadGGEPBlockException be) {
                    // empty catch block
                }
            }
            metaString = Response.createXmlString(name, ext);
        }
        return new Response(index, size, name, metaString, (Set)urns, null, endpoints, rawMeta);
    }

    private static StringTokenizer recreateTokenizer(byte[] data, int offset) {
        String s = new String(data, offset, data.length - offset);
        return new StringTokenizer(s, EXT_STRING);
    }

    private static String createXmlString(String name, String ext) {
        StringTokenizer tok = new StringTokenizer(ext);
        if (tok.countTokens() < 2) {
            return "";
        }
        String first = tok.nextToken();
        String second = tok.nextToken();
        if (first != null) {
            first = first.toLowerCase();
        }
        if (second != null) {
            second = second.toLowerCase();
        }
        String length = "";
        String bitrate = "";
        boolean bearShare1 = false;
        boolean bearShare2 = false;
        boolean gnotella = false;
        if (second.startsWith(KBPS)) {
            bearShare1 = true;
        } else if (first.endsWith(KBPS)) {
            bearShare2 = true;
        }
        if (bearShare1) {
            bitrate = first;
        } else if (bearShare2) {
            int j = first.indexOf(KBPS);
            bitrate = first.substring(0, j);
        }
        if (bearShare1 || bearShare2) {
            while (tok.hasMoreTokens()) {
                length = tok.nextToken();
            }
        } else if (ext.endsWith(KHZ)) {
            gnotella = true;
            length = first;
            int i = second.indexOf(KBPS);
            if (i > -1) {
                bitrate = second.substring(0, i);
            } else {
                gnotella = false;
            }
        }
        if (bearShare1 || bearShare2 || gnotella) {
            StringBuffer sb = new StringBuffer();
            sb.append(AUDIOS_NAMESPACE);
            sb.append(AUDIO_TITLE);
            sb.append(name);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_BITRATE);
            sb.append(bitrate);
            sb.append(QUOTE_SPACE);
            sb.append(AUDIO_SECONDS);
            sb.append(length);
            sb.append(CLOSE_TAG);
            sb.append(AUDIOS_CLOSE);
            return sb.toString();
        }
        return "";
    }

    private static byte[] createExtBytes(Set urns, Set endpoints) {
        try {
            if (Response.isEmpty(urns) && Response.isEmpty(endpoints)) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!Response.isEmpty(urns)) {
                Iterator iter = urns.iterator();
                while (iter.hasNext()) {
                    URN urn = (URN)iter.next();
                    Assert.that(urn != null, "Null URN");
                    baos.write(urn.toString().getBytes());
                    if (!iter.hasNext()) continue;
                    baos.write(28);
                }
                if (!Response.isEmpty(endpoints)) {
                    baos.write(28);
                }
            }
            if (!Response.isEmpty(endpoints)) {
                GGEPUtil.addGGEP(baos, endpoints);
            }
            return baos.toByteArray();
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private static boolean isEmpty(Set set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getAsEndpoints(AlternateLocationCollection col) {
        if (col == null || col.getAltLocsSize() == 0) {
            return DataUtils.EMPTY_SET;
        }
        AlternateLocationCollection alternateLocationCollection = col;
        synchronized (alternateLocationCollection) {
            HashSet endpoints = null;
            int i = 0;
            Iterator iter = col.iterator();
            while (iter.hasNext() && i < 10) {
                AlternateLocation al = (AlternateLocation)iter.next();
                Endpoint host = al.getHost();
                if (NetworkUtils.isMe(host.getAddress(), host.getPort())) continue;
                if (endpoints == null) {
                    endpoints = new HashSet();
                }
                endpoints.add((Object)al.getHost());
                ++i;
            }
            return endpoints == null ? DataUtils.EMPTY_SET : endpoints;
        }
    }

    private static String extractMetadata(LimeXMLDocument doc) {
        if (doc == null) {
            return "";
        }
        try {
            return doc.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "";
        }
    }

    public int writeToArray(byte[] array, int i) {
        ByteOrder.int2leb((int)this.index, array, i);
        ByteOrder.int2leb((int)this.size, array, i + 4);
        System.arraycopy(this.nameBytes, 0, array, i += 8, this.nameBytes.length);
        i += this.nameBytes.length;
        array[i++] = 0;
        System.arraycopy(this.extBytes, 0, array, i, this.extBytes.length);
        i += this.extBytes.length;
        array[i++] = 0;
        return i;
    }

    public void writeToStream(OutputStream os) throws IOException {
        int i;
        ByteOrder.int2leb((int)this.index, os);
        ByteOrder.int2leb((int)this.size, os);
        for (i = 0; i < this.nameBytes.length; ++i) {
            os.write(this.nameBytes[i]);
        }
        os.write(0);
        for (i = 0; i < this.extBytes.length; ++i) {
            os.write(this.extBytes[i]);
        }
        os.write(0);
    }

    public void setDocument(LimeXMLDocument doc) {
        this.document = doc;
        this.metadata = Response.extractMetadata(this.document);
        try {
            this.metaBytes = this.metadata.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            ErrorService.error(uee);
        }
    }

    public int getLength() {
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        byte[] copy = new byte[this.nameBytes.length];
        System.arraycopy(this.nameBytes, 0, copy, 0, this.nameBytes.length);
        return copy;
    }

    public byte[] getMetaBytes() {
        byte[] copy = new byte[this.metaBytes.length];
        System.arraycopy(this.metaBytes, 0, copy, 0, this.metaBytes.length);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public LimeXMLDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.metadata != null && !this.metadata.equals("")) {
            try {
                this.document = new LimeXMLDocument(this.metadata);
                return this.document;
            }
            catch (SAXException e) {
            }
            catch (SchemaNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getUrns() {
        return this.urns;
    }

    public Set getLocations() {
        return this.otherLocations;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData data) {
        RemoteFileDesc rfd;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == data.getPort() && this.cachedRFD.getHost().equals(data.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = rfd = new RemoteFileDesc(data.getIP(), data.getPort(), this.getIndex(), this.getName(), (int)this.getSize(), data.getClientGUID(), data.getSpeed(), data.isChatEnabled(), data.getQuality(), data.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), data.isReplyToMulticastQuery(), data.isFirewalled(), data.getVendorCode(), System.currentTimeMillis(), data.getPushProxies());
        return rfd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response r = (Response)o;
        return this.getIndex() == r.getIndex() && this.getSize() == r.getSize() && this.getName().equals(r.getName()) && Arrays.equals((byte[])this.getNameBytes(), (byte[])r.getNameBytes()) && this.getMetadata().equals(r.getMetadata()) && Arrays.equals((byte[])this.getMetaBytes(), (byte[])r.getMetaBytes()) && (this.getDocument() == null ? r.getDocument() == null : this.getDocument().equals(r.getDocument())) && this.getUrns().equals(r.getUrns());
    }

    public int hashCode() {
        return this.getName().hashCode() + (int)this.getSize() + (int)this.getIndex();
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "metadata:     " + this.metadata + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }

    private static class GGEPUtil {
        private GGEPUtil() {
        }

        static void addGGEP(OutputStream out, Set locs) throws IOException {
            if (locs == null || locs.size() == 0) {
                throw new NullPointerException("null or empty locations");
            }
            GGEP info = new GGEP();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Iterator i = locs.iterator();
                while (i.hasNext()) {
                    try {
                        Endpoint ep = (Endpoint)i.next();
                        baos.write(ep.getHostBytes());
                        ByteOrder.short2leb((short)ep.getPort(), baos);
                    }
                    catch (UnknownHostException uhe) {}
                }
            }
            catch (IOException impossible) {
                ErrorService.error(impossible);
            }
            info.put("ALT", baos.toByteArray());
            info.write(out);
        }

        static byte[] getGGEPBytes(Set locs) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                GGEPUtil.addGGEP(baos, locs);
            }
            catch (IOException impossible) {
                ErrorService.error(impossible);
            }
            return baos.toByteArray();
        }

        static Set getLocations(GGEP[] ggeps) {
            if (ggeps == null) {
                return DataUtils.EMPTY_SET;
            }
            HashSet locations = null;
            byte[] ip = new byte[4];
            IPFilter ipFilter = IPFilter.instance();
            for (int i = 0; i < ggeps.length; ++i) {
                byte[] locBytes;
                block7: {
                    if (!ggeps[i].hasKey("ALT")) continue;
                    try {
                        locBytes = ggeps[i].getBytes("ALT");
                        if (locBytes.length % 6 != 0) {
                        }
                        break block7;
                    }
                    catch (BadGGEPPropertyException bad) {
                        ErrorService.error(bad);
                    }
                    continue;
                }
                for (int j = 0; j < locBytes.length; j += 6) {
                    int port = ByteOrder.ubytes2int(ByteOrder.leb2short(locBytes, j + 4));
                    if (!NetworkUtils.isValidPort(port)) continue;
                    ip[0] = locBytes[j];
                    ip[1] = locBytes[j + 1];
                    ip[2] = locBytes[j + 2];
                    ip[3] = locBytes[j + 3];
                    if (!NetworkUtils.isValidAddress(ip) || !ipFilter.allow(ip) || NetworkUtils.isMe(ip, port)) continue;
                    if (locations == null) {
                        locations = new HashSet();
                    }
                    locations.add((Object)new Endpoint(ip, port));
                }
            }
            return locations == null ? DataUtils.EMPTY_SET : locations;
        }
    }
}

