/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.List;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest qr) {
        this.record(qr, null);
    }

    public synchronized void record(QueryRequest qr, MediaType type) {
        byte[] guid = qr.getGUID();
        this.mapper.put(new GUID(guid), new RequestData(qr.getQuery(), qr.getRichQuery(), type));
    }

    public static int score(String query, LimeXMLDocument richQuery, RemoteFileDesc response) {
        return ResponseVerifier.score(ResponseVerifier.getSearchTerms(query, richQuery), response.getFileName());
    }

    private static int score(String[] queryWords, String filename) {
        int numMatchingWords = 0;
        int numQueryWords = queryWords.length;
        if (numQueryWords == 0) {
            return 100;
        }
        for (int i = 0; i < numQueryWords; ++i) {
            String pattern = queryWords[i];
            if (!StringUtils.contains(filename, pattern, true)) continue;
            ++numMatchingWords;
        }
        return (int)((float)numMatchingWords * 100.0f / (float)numQueryWords);
    }

    public boolean matchesType(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null || request.type == null) {
            return true;
        }
        String reply = response.getName();
        return request.type.matches(reply);
    }

    public boolean isMandragoreWorm(byte[] guid, Response response) {
        RequestData request = (RequestData)this.mapper.get(new GUID(guid));
        if (request == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(request.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static String[] getSearchTerms(String query, LimeXMLDocument richQuery) {
        String[] terms = null;
        HashSet qWords = new HashSet();
        terms = StringUtils.split(query.toLowerCase(), DELIMITERS);
        for (int i = 0; i < terms.length; ++i) {
            qWords.add((Object)terms[i]);
        }
        List xmlWords = null;
        if (richQuery != null) {
            xmlWords = richQuery.getKeyWords();
            int size = xmlWords.size();
            for (int i = 0; i < size; ++i) {
                String currWord = (String)xmlWords.remove(0);
                qWords.add((Object)currWord.toLowerCase());
            }
        }
        return (String[])qWords.toArray((Object[])new String[qWords.size()]);
    }

    private static class RequestData {
        String query;
        LimeXMLDocument richQuery;
        String[] queryWords;
        MediaType type;

        RequestData(String query, MediaType type) {
            this(query, null, type);
        }

        RequestData(String query, LimeXMLDocument richQuery, MediaType type) {
            this.query = query;
            this.richQuery = richQuery;
            this.queryWords = ResponseVerifier.getSearchTerms(query, richQuery);
            this.type = type;
        }

        public boolean xmlQuery() {
            return this.richQuery != null;
        }
    }
}

