/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.ResultCounter;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;

public final class RouteTable {
    private Map _newMap = new TreeMap((Comparator)new GUID.GUIDByteComparator());
    private Map _oldMap = new TreeMap((Comparator)new GUID.GUIDByteComparator());
    private int _mseconds;
    private long _nextSwitchTime;
    private int _maxSize;
    private Map _idMap = new HashMap();
    private Map _handlerMap = new HashMap();
    private int _nextID;
    private static boolean warned = false;

    public RouteTable(int seconds, int maxSize) {
        this._mseconds = seconds * 1000;
        this._nextSwitchTime = System.currentTimeMillis() + (long)this._mseconds;
        this._maxSize = maxSize;
    }

    public synchronized ResultCounter routeReply(byte[] guid, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (!replyHandler.isOpen()) {
            return null;
        }
        int id = this.handler2id(replyHandler);
        RouteTableEntry entry = (RouteTableEntry)this._newMap.remove((Object)guid);
        if (entry == null) {
            entry = (RouteTableEntry)this._oldMap.remove((Object)guid);
        }
        if (entry == null) {
            entry = new RouteTableEntry(id);
        } else {
            entry.handlerID = id;
        }
        this._newMap.put((Object)guid, (Object)entry);
        return entry;
    }

    public synchronized ResultCounter tryToRouteReply(byte[] guid, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        Assert.that(replyHandler != null);
        Assert.that(guid != null, "Null GUID in tryToRouteReply");
        if (!replyHandler.isOpen()) {
            return null;
        }
        if (!this._newMap.containsKey((Object)guid) && !this._oldMap.containsKey((Object)guid)) {
            int id = this.handler2id(replyHandler);
            RouteTableEntry entry = new RouteTableEntry(id);
            this._newMap.put((Object)guid, (Object)entry);
            return entry;
        }
        return null;
    }

    public synchronized void setTTL(ResultCounter entry, byte ttl) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry!!");
        }
        if (!(entry instanceof RouteTableEntry)) {
            throw new IllegalArgumentException("entry is not recognized.");
        }
        if (ttl <= 0) {
            throw new IllegalArgumentException("Input TTL too small: " + ttl);
        }
        ((RouteTableEntry)entry).setTTL(ttl);
    }

    public synchronized boolean getAndSetTTL(byte[] guid, byte getTTL, byte setTTL) {
        if (getTTL < 1 || setTTL <= getTTL) {
            throw new IllegalArgumentException("Bad ttl input (get/set): " + getTTL + "/" + setTTL);
        }
        RouteTableEntry entry = (RouteTableEntry)this._newMap.get((Object)guid);
        if (entry == null) {
            entry = (RouteTableEntry)this._oldMap.get((Object)guid);
        }
        if (entry != null && entry.getTTL() == getTTL) {
            entry.setTTL(setTTL);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] guid) {
        this.repOk();
        RouteTableEntry entry = (RouteTableEntry)this._newMap.get((Object)guid);
        if (entry == null) {
            entry = (RouteTableEntry)this._oldMap.get((Object)guid);
        }
        return entry == null ? null : this.id2handler(new Integer(entry.handlerID));
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] guid, int replyBytes, short numReplies) {
        this.repOk();
        RouteTableEntry entry = (RouteTableEntry)this._newMap.get((Object)guid);
        if (entry == null) {
            entry = (RouteTableEntry)this._oldMap.get((Object)guid);
        }
        if (entry == null) {
            return null;
        }
        ReplyHandler handler = this.id2handler(new Integer(entry.handlerID));
        if (handler == null) {
            return null;
        }
        ReplyRoutePair ret = new ReplyRoutePair(handler, entry.bytesRouted, entry.repliesRouted);
        entry.bytesRouted += replyBytes;
        entry.repliesRouted += numReplies;
        return ret;
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        this.repOk();
        Assert.that(replyHandler != null, "Null replyHandler in removeReplyHandler");
        Integer id = this.handler2id(replyHandler);
        this._idMap.remove((Object)id);
        this._handlerMap.remove((Object)replyHandler);
    }

    private Integer handler2id(ReplyHandler handler) {
        Integer id = (Integer)this._handlerMap.get((Object)handler);
        if (id != null) {
            return id;
        }
        while (this._idMap.get((Object)(id = new Integer(this._nextID++))) != null) {
        }
        this._handlerMap.put((Object)handler, (Object)id);
        this._idMap.put((Object)id, (Object)handler);
        return id;
    }

    private ReplyHandler id2handler(Integer id) {
        return (ReplyHandler)this._idMap.get((Object)id);
    }

    private final boolean purge() {
        long now = System.currentTimeMillis();
        if (now < this._nextSwitchTime && this._newMap.size() < this._maxSize) {
            return false;
        }
        this._oldMap.clear();
        Map tmp = this._oldMap;
        this._oldMap = this._newMap;
        this._newMap = tmp;
        this._nextSwitchTime = now + (long)this._mseconds;
        return true;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer("{");
        TreeMap bothMaps = new TreeMap((Comparator)new GUID.GUIDByteComparator());
        bothMaps.putAll(this._oldMap);
        bothMaps.putAll(this._newMap);
        Iterator iter = bothMaps.keySet().iterator();
        while (iter.hasNext()) {
            byte[] key = (byte[])iter.next();
            buf.append(new GUID(key));
            buf.append("->");
            int id = ((RouteTableEntry)bothMaps.get((Object)key)).handlerID;
            ReplyHandler handler = this.id2handler(new Integer(id));
            buf.append(handler == null ? "null" : handler.toString());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private final void repOk() {
    }

    public static final class ReplyRoutePair {
        private final ReplyHandler handler;
        private final int volume;
        private final int REPLIES_ROUTED;

        ReplyRoutePair(ReplyHandler handler, int volume, int hits) {
            this.handler = handler;
            this.volume = volume;
            this.REPLIES_ROUTED = hits;
        }

        public ReplyHandler getReplyHandler() {
            return this.handler;
        }

        public int getBytesRouted() {
            return this.volume;
        }

        public int getResultsRouted() {
            return this.REPLIES_ROUTED;
        }
    }

    private static final class RouteTableEntry
    implements ResultCounter {
        private int handlerID;
        private int bytesRouted;
        private int repliesRouted;
        private byte ttl = 0;

        RouteTableEntry(int handlerID) {
            this.handlerID = handlerID;
            this.bytesRouted = 0;
            this.repliesRouted = 0;
        }

        public void setTTL(byte ttl) {
            this.ttl = ttl;
        }

        public byte getTTL() {
            return this.ttl;
        }

        public int getNumResults() {
            return this.repliesRouted;
        }
    }
}

