/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HorizonCounter;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.browser.HTTPAcceptor;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.security.Cookies;
import com.limegroup.gnutella.security.ServerAuthenticator;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.upelection.PromotionManager;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.SimpleTimer;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RouterService {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService));
    private static FileManager fileManager = new MetaFileManager();
    private static final Authenticator authenticator = new ServerAuthenticator();
    private static final SimpleTimer timer = new SimpleTimer(true);
    private static final Acceptor acceptor = new Acceptor();
    private static HTTPAcceptor httpAcceptor;
    private static ConnectionManager manager;
    private static HostCatcher catcher;
    private static final DownloadManager downloader;
    private static UploadManager uploadManager;
    private static PushManager pushManager;
    private static PromotionManager promotionManager;
    private static final ResponseVerifier verifier;
    private static final Statistics statistics;
    private static final UDPService udpService;
    private static final SearchResultHandler RESULT_HANDLER;
    private static boolean isShuttingDown;
    private static ActivityCallback callback;
    private static MessageRouter router;
    private static boolean _started;
    private static long _lastQueryTime;
    private static boolean _fullPower;
    static /* synthetic */ Class class$com$limegroup$gnutella$RouterService;

    public RouterService(ActivityCallback callback) {
        this(callback, new StandardMessageRouter());
    }

    public RouterService(ActivityCallback ac, MessageRouter mr, FileManager fm) {
        this(ac, mr);
        fileManager = fm;
    }

    public RouterService(ActivityCallback callback, MessageRouter router) {
        RouterService.callback = callback;
        RouterService.router = router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class clazz = class$com$limegroup$gnutella$RouterService == null ? (class$com$limegroup$gnutella$RouterService = RouterService.class$("com.limegroup.gnutella.RouterService")) : class$com$limegroup$gnutella$RouterService;
        synchronized (clazz) {
            int outgoing;
            LOG.trace((Object)"START RouterService");
            if (RouterService.isStarted()) {
                return;
            }
            _started = true;
            LOG.trace((Object)"START MessageRouter");
            callback.componentLoading("MESSAGE_ROUTER");
            router.initialize();
            LOG.trace((Object)"STOPMessageRouter");
            LOG.trace((Object)"START Acceptor");
            callback.componentLoading("ACCEPTOR");
            acceptor.start();
            LOG.trace((Object)"STOP Acceptor");
            LOG.trace((Object)"START ConnectionManager");
            callback.componentLoading("CONNECTION_MANAGER");
            manager.initialize();
            LOG.trace((Object)"STOP ConnectionManager");
            LOG.trace((Object)"START DownloadManager");
            downloader.initialize();
            LOG.trace((Object)"STOP DownloadManager");
            LOG.trace((Object)"START SupernodeAssigner");
            SupernodeAssigner sa = new SupernodeAssigner(uploadManager, downloader, manager);
            sa.start();
            LOG.trace((Object)"STOP SupernodeAssigner");
            LOG.trace((Object)"START HostCatcher.initialize");
            callback.componentLoading("HOST_CATCHER");
            catcher.initialize();
            LOG.trace((Object)"STOP HostCatcher.initialize");
            if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
                LOG.trace((Object)"START connect");
                RouterService.connect();
                LOG.trace((Object)"STOP connect");
            }
            LOG.trace((Object)"START FileManager");
            callback.componentLoading("FILE_MANAGER");
            fileManager.start();
            LOG.trace((Object)"STOP FileManager");
            LOG.trace((Object)"START DownloadManager.postGuiInit");
            callback.componentLoading("DOWNLOAD_MANAGER_POST_GUI");
            downloader.postGuiInit();
            LOG.trace((Object)"STOP DownloadManager.postGuiInit");
            LOG.trace((Object)"START QueryUnicaster");
            callback.componentLoading("QUERY_UNICASTER");
            QueryUnicaster.instance().start();
            LOG.trace((Object)"STOP QueryUnicaster");
            LOG.trace((Object)"START HTTPAcceptor");
            callback.componentLoading("HTTPACCEPTOR");
            httpAcceptor = new HTTPAcceptor();
            httpAcceptor.start();
            LOG.trace((Object)"STOP HTTPAcceptor");
            LOG.trace((Object)"START Pinger");
            callback.componentLoading("PINGER");
            Pinger.instance().start();
            LOG.trace((Object)"STOP Pinger");
            LOG.trace((Object)"START ConnectionWatchdog");
            callback.componentLoading("CONNECTION_WATCHDOG");
            ConnectionWatchdog.instance().start();
            LOG.trace((Object)"STOP ConnectionWatchdog");
            LOG.trace((Object)"START SavedFileManager");
            callback.componentLoading("SAVED_FILE_MANAGER");
            SavedFileManager.instance();
            LOG.trace((Object)"STOP SavedFileManager");
            LOG.trace((Object)"STOP RouterService.");
        }
    }

    public static boolean isStarted() {
        return _started;
    }

    public static ActivityCallback getCallback() {
        return callback;
    }

    public static void setFullPower(boolean newValue) {
        if (_fullPower != newValue) {
            _fullPower = newValue;
            NormalUploadState.setThrottleSwitching(!newValue);
            HTTPDownloader.setThrottleSwitching(!newValue);
        }
    }

    public static MessageRouter getMessageRouter() {
        return router;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public static DownloadManager getDownloadManager() {
        return downloader;
    }

    public static UDPService getUdpService() {
        return udpService;
    }

    public static ConnectionManager getConnectionManager() {
        return manager;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    public static PushManager getPushManager() {
        return pushManager;
    }

    public static Acceptor getAcceptor() {
        return acceptor;
    }

    public static HTTPAcceptor getHTTPAcceptor() {
        return httpAcceptor;
    }

    public static HostCatcher getHostCatcher() {
        return catcher;
    }

    public static SearchResultHandler getSearchResultHandler() {
        return RESULT_HANDLER;
    }

    public static PromotionManager getPromotionManager() {
        return promotionManager;
    }

    public static void schedule(Runnable task, long delay, long period) {
        timer.schedule(task, delay, period);
    }

    public static ManagedConnection connectToHostBlocking(String hostname, int portnum) throws IOException {
        return manager.createConnectionBlocking(hostname, portnum);
    }

    public static void connectToHostAsynchronously(String hostname, int portnum) {
        InetAddress addr;
        byte[] cIP = null;
        try {
            addr = InetAddress.getByName(hostname);
            cIP = addr.getAddress();
        }
        catch (UnknownHostException e) {
            return;
        }
        if (cIP[0] == 127 && portnum == acceptor.getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] managerIP = acceptor.getAddress(true);
        if (Arrays.equals((byte[])cIP, (byte[])managerIP) && portnum == acceptor.getPort(true)) {
            return;
        }
        if (!acceptor.isBannedIP(addr.getHostAddress())) {
            manager.createConnectionAsynchronously(hostname, portnum);
        }
    }

    public static void connect() {
        RouterService.adjustSpamFilters();
        manager.connect();
    }

    public static void disconnect() {
        manager.disconnect();
    }

    public static void removeConnection(ManagedConnection c) {
        manager.remove(c);
    }

    public static void clearHostCatcher() {
        catcher.clear();
    }

    public static int getRealNumHosts() {
        return catcher.getNumHosts();
    }

    public static int getNumDownloads() {
        return downloader.downloadsInProgress();
    }

    public static int getNumActiveDownloads() {
        return downloader.getNumActiveDownloads();
    }

    public static int getNumWaitingDownloads() {
        return downloader.getNumWaitingDownloads();
    }

    public static int getNumIndividualDownloaders() {
        return downloader.getNumIndividualDownloaders();
    }

    public static int getNumUploads() {
        return uploadManager.uploadsInProgress();
    }

    public static int getNumQueuedUploads() {
        return uploadManager.getNumQueuedUploads();
    }

    public static long getCurrentUptime() {
        return statistics.getUptime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        try {
            if (!RouterService.isStarted()) {
                return;
            }
            Statistics.instance().shutdown();
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(RouterService.acceptedIncomingConnection());
            try {
                catcher.write();
            }
            catch (IOException e) {
            }
            finally {
                SettingsHandler.save();
            }
            File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
            if (incompleteDir == null) {
                return;
            }
            String[] files = incompleteDir.list();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith("Preview-")) continue;
                File file = new File(incompleteDir, files[i]);
                file.delete();
            }
            downloader.writeSnapshot();
            Cookies.instance().save();
            UrnCache.instance().persistCache();
            CreationTimeCache.instance().persistCache();
            TigerTreeCache.instance().persistCache();
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static void adjustSpamFilters() {
        IPFilter.refreshIPFilter();
        Iterator iter = manager.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            c.setPersonalFilter(SpamFilter.newPersonalFilter());
            c.setRouteFilter(SpamFilter.newRouteFilter());
        }
        UDPReplyHandler.setPersonalFilter(SpamFilter.newPersonalFilter());
    }

    public static void setListeningPort(int port) throws IOException {
        acceptor.setListeningPort(port);
    }

    public static boolean acceptedIncomingConnection() {
        return acceptor.acceptedIncoming();
    }

    public static int getActiveConnectionMessages() {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            count += c.getNumMessagesSent();
            count += c.getNumMessagesReceived();
        }
        return count;
    }

    public static int countConnectionsWithNMessages(int messageThreshold) {
        int count = 0;
        Iterator iter = manager.getInitializedConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            int msgs = c.getNumMessagesSent();
            if ((msgs += c.getNumMessagesReceived()) <= messageThreshold) continue;
            ++count;
        }
        return count;
    }

    public static long getNumHosts() {
        return HorizonCounter.instance().getNumHosts();
    }

    public static long getNumFiles() {
        return HorizonCounter.instance().getNumFiles();
    }

    public static long getTotalFileSize() {
        return HorizonCounter.instance().getTotalFileSize();
    }

    public static void dumpConnections() {
        System.out.println("UltraPeer connections");
        RouterService.dumpConnections((Collection)manager.getInitializedConnections());
        System.out.println("Leaf connections");
        RouterService.dumpConnections((Collection)manager.getInitializedClientConnections());
    }

    private static void dumpConnections(Collection connections) {
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString());
        }
    }

    public static void updateHorizon() {
        HorizonCounter.instance().refresh();
    }

    public static byte[] newQueryGUID() {
        if (RouterService.isOOBCapable() && OutOfBandThroughputStat.isOOBEffectiveForMe()) {
            return GUID.makeAddressEncodedGuid(RouterService.getAddress(), RouterService.getPort());
        }
        return GUID.makeGuid();
    }

    public static void query(byte[] guid, String query, MediaType type) {
        RouterService.query(guid, query, "", type);
    }

    public static void query(byte[] guid, String query) {
        RouterService.query(guid, query, null);
    }

    public static void query(byte[] guid, String query, String richQuery, MediaType type) {
        try {
            QueryRequest qr = null;
            if (RouterService.isIpPortValid() && new GUID(guid).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                qr = QueryRequest.createOutOfBandQuery(guid, query, richQuery, type);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                qr = QueryRequest.createQuery(guid, query, richQuery, type);
            }
            RouterService.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public static void queryWhatIsNew(byte[] guid, MediaType type) {
        try {
            QueryRequest qr = null;
            if (new GUID(guid).addressesMatch(RouterService.getAddress(), RouterService.getPort())) {
                qr = QueryRequest.createWhatIsNewOOBQuery(guid, (byte)2, type);
                OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
            } else {
                qr = QueryRequest.createWhatIsNewQuery(guid, (byte)2, type);
            }
            if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
                MutableGUIDFilter.instance().addGUID(guid);
            }
            RouterService.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    private static void recordAndSendQuery(QueryRequest qr, MediaType type) {
        _lastQueryTime = System.currentTimeMillis();
        verifier.record(qr, type);
        RESULT_HANDLER.addQuery(qr);
        router.sendDynamicQuery(qr);
    }

    public static long getLastQueryTime() {
        return _lastQueryTime;
    }

    public static void stopQuery(GUID guid) {
        QueryUnicaster.instance().purgeQuery(guid);
        RESULT_HANDLER.removeQuery(guid);
        router.queryKilled(guid);
        if (RouterService.isSupernode()) {
            QueryDispatcher.instance().addToRemove(guid);
        }
        MutableGUIDFilter.instance().removeGUID(guid.bytes());
    }

    public static boolean matchesType(byte[] guid, Response response) {
        return verifier.matchesType(guid, response);
    }

    public static boolean isMandragoreWorm(byte[] guid, Response response) {
        return verifier.isMandragoreWorm(guid, response);
    }

    public static Collection getPreferencedHosts(boolean isUltrapeer, String locale, int num) {
        TreeSet hosts = new TreeSet(IpPort.COMPARATOR);
        if (isUltrapeer) {
            hosts.addAll(catcher.getUltrapeersWithFreeUltrapeerSlots(locale, num));
        } else {
            hosts.addAll(catcher.getUltrapeersWithFreeLeafSlots(locale, num));
        }
        if (hosts.size() < num) {
            List conns = manager.getInitializedConnectionsMatchLocale(locale);
            Iterator i = conns.iterator();
            while (i.hasNext() && hosts.size() < num) {
                hosts.add(i.next());
            }
            if (hosts.size() < num) {
                conns = manager.getInitializedConnections();
                i = conns.iterator();
                while (i.hasNext() && hosts.size() < num) {
                    hosts.add(i.next());
                }
            }
        }
        return hosts;
    }

    public static int getNumConnections() {
        return manager.getNumConnections();
    }

    public static int getNumInitializedConnections() {
        return manager.getNumInitializedConnections();
    }

    public static int getNumUltrapeerToLeafConnections() {
        return manager.getNumInitializedClientConnections();
    }

    public static int getNumLeafToUltrapeerConnections() {
        return manager.getNumClientSupernodeConnections();
    }

    public static int getNumUltrapeerToUltrapeerConnections() {
        return manager.getNumUltrapeerConnections();
    }

    public static int getNumOldConnections() {
        return manager.getNumOldConnections();
    }

    public static boolean isFullyConnected() {
        return manager.isFullyConnected();
    }

    public static boolean isConnected() {
        return manager.isConnected();
    }

    public static boolean isConnecting() {
        return manager.isConnecting();
    }

    public static boolean isFetchingEndpoints() {
        return BootstrapServerManager.instance().isEndpointFetchInProgress();
    }

    public static int getNumSharedFiles() {
        return fileManager.getNumFiles();
    }

    public static int getNumPendingShared() {
        return fileManager.getNumPendingFiles();
    }

    public static int getSharedFileSize() {
        return fileManager.getSize();
    }

    public static FileDesc[] getIncompleteFileDescriptors() {
        return fileManager.getIncompleteFileDescriptors();
    }

    public static FileDesc[] getSharedFileDescriptors(File directory) {
        if (directory == null) {
            return fileManager.getAllSharedFileDescriptors();
        }
        return fileManager.getSharedFileDescriptors(directory);
    }

    public static Downloader download(RemoteFileDesc[] files, List alts, boolean overwrite, GUID queryGUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return downloader.download(files, alts, overwrite, queryGUID);
    }

    public static Downloader download(RemoteFileDesc[] files, boolean overwrite, GUID queryGUID) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return RouterService.download(files, DataUtils.EMPTY_LIST, overwrite, queryGUID);
    }

    public static synchronized Downloader download(URN urn, String textQuery, String filename, String[] defaultURL, boolean overwrite) throws IllegalArgumentException, AlreadyDownloadingException, FileExistsException {
        return downloader.download(urn, textQuery, filename, defaultURL, overwrite);
    }

    public static Downloader download(File incompleteFile) throws AlreadyDownloadingException, CantResumeException {
        return downloader.download(incompleteFile);
    }

    public static Downloader download(String query, String richQuery, byte[] guid, MediaType type) throws AlreadyDownloadingException {
        return downloader.download(query, richQuery, guid, type);
    }

    public static Chatter createChat(String host, int port) {
        Chatter chatter = ChatManager.instance().request(host, port);
        return chatter;
    }

    public static BrowseHostHandler doAsynchronousBrowseHost(final String host, final int port, GUID guid, GUID serventID, final Set proxies) {
        final BrowseHostHandler handler = new BrowseHostHandler(callback, guid, serventID);
        ManagedThread asynch = new ManagedThread(new Runnable(){

            public void run() {
                try {
                    handler.browseHost(host, port, proxies);
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        }, "BrowseHoster");
        asynch.setDaemon(true);
        asynch.start();
        return handler;
    }

    public static boolean isSupernode() {
        return manager.isSupernode();
    }

    public static boolean isShieldedLeaf() {
        return manager.isShieldedLeaf();
    }

    public static int getNumFreeLeafSlots() {
        return manager.getNumFreeLeafSlots();
    }

    public static int getNumFreeNonLeafSlots() {
        return manager.getNumFreeNonLeafSlots();
    }

    public static int getNumFreeLimeWireLeafSlots() {
        return manager.getNumFreeLimeWireLeafSlots();
    }

    public static int getNumFreeLimeWireNonLeafSlots() {
        return manager.getNumFreeLimeWireNonLeafSlots();
    }

    public static void setIsShuttingDown(boolean flag) {
        isShuttingDown = flag;
    }

    public static boolean getIsShuttingDown() {
        return isShuttingDown;
    }

    public static boolean addressChanged() {
        byte[] addr = RouterService.getAddress();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (NetworkUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort())) {
            return false;
        }
        FileDesc[] fds = fileManager.getAllSharedFileDescriptors();
        for (int i = 0; i < fds.length; ++i) {
            fds[i].addUrnsForSelf();
        }
        acceptor.resetLastConnectBackTime();
        udpService.resetLastConnectBackTime();
        return true;
    }

    public static byte[] getExternalAddress() {
        return acceptor.getExternalAddress();
    }

    public static byte[] getAddress() {
        return acceptor.getAddress(true);
    }

    public static byte[] getNonForcedAddress() {
        return acceptor.getAddress(false);
    }

    public static int getPort() {
        return acceptor.getPort(true);
    }

    public static int getNonForcedPort() {
        return acceptor.getPort(false);
    }

    public static boolean isGUESSCapable() {
        return udpService.isGUESSCapable();
    }

    public static boolean isOOBCapable() {
        return RouterService.isGUESSCapable() && OutOfBandThroughputStat.isSuccessRateGood() && !NetworkUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && acceptor.isAddressExternal() && RouterService.isIpPortValid();
    }

    public static GUID getUDPConnectBackGUID() {
        return udpService.getConnectBackGUID();
    }

    public static boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager = new ConnectionManager(authenticator);
        catcher = new HostCatcher();
        downloader = new DownloadManager();
        uploadManager = new UploadManager();
        pushManager = new PushManager();
        promotionManager = new PromotionManager();
        verifier = new ResponseVerifier();
        statistics = Statistics.instance();
        udpService = UDPService.instance();
        RESULT_HANDLER = new SearchResultHandler();
        _lastQueryTime = 0L;
        _fullPower = true;
    }
}

