/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$SavedFileManager == null ? (class$com$limegroup$gnutella$SavedFileManager = SavedFileManager.class$("com.limegroup.gnutella.SavedFileManager")) : class$com$limegroup$gnutella$SavedFileManager));
    private static SavedFileManager INSTANCE = new SavedFileManager();
    private Set _urns = new HashSet();
    private Set _names = new TreeSet(Comparators.caseInsensitiveStringComparator());
    private volatile boolean _loading = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$SavedFileManager;

    public static SavedFileManager instance() {
        return INSTANCE;
    }

    private SavedFileManager() {
        RouterService.schedule(this, 10000L, 180000L);
    }

    public synchronized void addSavedFile(File f, Set urns) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding: " + f + " with: " + urns));
        }
        this._names.add((Object)f.getName());
        Iterator i = urns.iterator();
        while (i.hasNext()) {
            this._urns.add(i.next());
        }
    }

    public synchronized boolean isSaved(URN urn, String name) {
        return urn != null && this._urns.contains((Object)urn) || this._names.contains((Object)name);
    }

    public synchronized boolean isLoading() {
        return this._loading || !RouterService.getFileManager().isLoadFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            if (!this.isLoading()) {
                this._loading = true;
                ManagedThread t = new ManagedThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SavedFileManager.this.load();
                        }
                        finally {
                            SavedFileManager.this._loading = false;
                        }
                    }
                }, "SavedFileProcessor");
                t.setDaemon(true);
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace((Object)"Loading Saved Files");
        HashSet urns = new HashSet();
        TreeSet names = new TreeSet(Comparators.caseInsensitiveStringComparator());
        File saveDirectory = SharingSettings.getSaveDirectory();
        String[] saved = saveDirectory.list();
        if (saved == null) {
            saved = new String[]{};
        }
        for (int i = 0; i < saved.length; ++i) {
            String name = saved[i];
            File file = new File(saveDirectory, name);
            if (!file.isFile() || !file.exists()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Loading: " + file));
            }
            names.add((Object)name);
            try {
                Set fileUrns = FileDesc.calculateAndCacheURN(file);
                Iterator j = fileUrns.iterator();
                while (j.hasNext()) {
                    urns.add(j.next());
                }
                continue;
            }
            catch (IOException ignored) {
                continue;
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._names = names;
            this._urns = urns;
        }
        LOG.trace((Object)"Finished loading saved Files.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

