/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.IntWrapper;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public final class URN
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    public static final URN INVALID = new URN("bad:bad", UrnType.INVALID);
    private static final String SPACE = " ";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String TWO = "2";
    private static final String DOT = ".";
    private transient String _urnString;
    private transient UrnType _urnType;
    private volatile transient int hashCode = 0;
    private static final Map progressMap = new HashMap();

    public static int getHashingProgress(File file) {
        IntWrapper progress = (IntWrapper)progressMap.get((Object)file);
        if (progress == null) {
            return -1;
        }
        return progress.getInt();
    }

    public static URN createSHA1Urn(File file) throws IOException, InterruptedException {
        return new URN(URN.createSHA1String(file), UrnType.SHA1);
    }

    public static URN createSHA1Urn(String urnString) throws IOException {
        String typeString = URN.getTypeString(urnString).toLowerCase(Locale.US);
        if (typeString.indexOf("sha1:") == 4) {
            return URN.createSHA1UrnFromString(urnString);
        }
        if (typeString.indexOf("bitprint:") == 4) {
            return URN.createSHA1UrnFromBitprint(urnString);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createSHA1UrnFromURL(URL url) throws IOException {
        return URN.createSHA1UrnFromUriRes(url.getFile());
    }

    public static URN createSHA1UrnFromUriRes(String sha1String) throws IOException {
        sha1String.trim();
        if (URN.isValidUriResSHA1Format(sha1String)) {
            return URN.createSHA1UrnFromString(sha1String.substring(13));
        }
        throw new IOException("could not parse string format: " + sha1String);
    }

    public static URN createSHA1UrnFromHttpRequest(String requestLine) throws IOException {
        if (!URN.isValidUrnHttpRequest(requestLine)) {
            throw new IOException("INVALID URN HTTP REQUEST");
        }
        String urnString = URN.extractUrnFromHttpRequest(requestLine);
        if (urnString == null) {
            throw new IOException("COULD NOT CONSTRUCT URN");
        }
        return URN.createSHA1Urn(urnString);
    }

    private static URN createSHA1UrnFromString(String urnString) throws IOException {
        if (urnString == null) {
            throw new IOException("cannot accept null URN string");
        }
        if (!URN.isValidUrn(urnString)) {
            throw new IOException("invalid urn string: " + urnString);
        }
        String typeString = URN.getTypeString(urnString);
        if (!UrnType.isSupportedUrnType(typeString)) {
            throw new IOException("urn type not recognized: " + typeString);
        }
        UrnType type = UrnType.createUrnType(typeString);
        return new URN(urnString, type);
    }

    private static URN createSHA1UrnFromBitprint(String bitprintString) throws IOException {
        int dotIdx = bitprintString.indexOf(DOT);
        if (dotIdx == -1) {
            throw new IOException("invalid bitprint: " + bitprintString);
        }
        String sha1 = bitprintString.substring(bitprintString.indexOf(58, 4) + 1, dotIdx);
        return URN.createSHA1UrnFromString("urn:sha1:" + sha1);
    }

    private URN(String urnString, UrnType urnType) {
        int lastColon = urnString.lastIndexOf(":");
        String nameSpace = urnString.substring(0, lastColon + 1);
        String hash = urnString.substring(lastColon + 1);
        this._urnString = nameSpace.toLowerCase(Locale.US) + hash.toUpperCase(Locale.US);
        this._urnType = urnType;
    }

    public UrnType getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String urnString) {
        return URN.isValidUrn(urnString);
    }

    public boolean isSHA1() {
        return this._urnType.isSHA1();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URN)) {
            return false;
        }
        URN urn = (URN)o;
        return this._urnString.equals(urn._urnString) && this._urnType.equals(urn._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this._urnString.hashCode();
            this.hashCode = result = 37 * result + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static boolean isValidUriResSHA1Format(String sha1String) {
        String copy = sha1String.toLowerCase(Locale.US);
        if (copy.startsWith("/uri-res/n2r?urn:sha1:")) {
            return sha1String.length() == 54;
        }
        return false;
    }

    private static String extractUrnFromHttpRequest(String requestLine) {
        int qIndex = requestLine.indexOf(QUESTION_MARK) + 1;
        int spaceIndex = requestLine.indexOf(SPACE, qIndex);
        if (qIndex == -1 || spaceIndex == -1) {
            return null;
        }
        return requestLine.substring(qIndex, spaceIndex);
    }

    private static boolean isValidUrnHttpRequest(String requestLine) {
        return URN.isValidLength(requestLine) && URN.isValidUriRes(requestLine) && URN.isValidResolutionProtocol(requestLine) && URN.isValidHTTPSpecifier(requestLine);
    }

    private static final boolean isValidLength(String requestLine) {
        int size = requestLine.length();
        return size == 63 || size == 107;
    }

    private static final boolean isValidUriRes(String requestLine) {
        int firstSlash = requestLine.indexOf(SLASH);
        if (firstSlash == -1 || firstSlash == requestLine.length()) {
            return false;
        }
        int secondSlash = requestLine.indexOf(SLASH, firstSlash + 1);
        if (secondSlash == -1) {
            return false;
        }
        String uriStr = requestLine.substring(firstSlash + 1, secondSlash);
        return uriStr.equalsIgnoreCase("uri-res");
    }

    private static boolean isValidResolutionProtocol(String requestLine) {
        int nIndex = requestLine.indexOf(TWO);
        if (nIndex == -1) {
            return false;
        }
        String n2s = requestLine.substring(nIndex - 1, nIndex + 3);
        return n2s.equalsIgnoreCase("N2R?") || n2s.equalsIgnoreCase("N2X?");
    }

    private static boolean isValidHTTPSpecifier(String requestLine) {
        int spaceIndex = requestLine.lastIndexOf(SPACE);
        if (spaceIndex == -1) {
            return false;
        }
        String httpStr = requestLine.substring(spaceIndex + 1);
        return httpStr.equalsIgnoreCase("HTTP/1.0") || httpStr.equalsIgnoreCase("HTTP/1.1");
    }

    private static String getTypeString(String fullUrnString) throws IOException {
        String type = fullUrnString.trim();
        if (type.length() <= 4) {
            throw new IOException("no type string");
        }
        return type.substring(0, type.indexOf(58, 4) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createSHA1String(File file) throws IOException, InterruptedException {
        FileInputStream fis = new FileInputStream(file);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("NO SUCH ALGORITHM");
        }
        try {
            int read;
            byte[] buffer = new byte[16384];
            IntWrapper progress = new IntWrapper(0);
            progressMap.put((Object)file, (Object)progress);
            while ((read = fis.read(buffer)) != -1) {
                long start = System.currentTimeMillis();
                md.update(buffer, 0, read);
                progress.addInt(read);
                long end = System.currentTimeMillis();
                long interval = Math.max(0L, end - start);
                Thread.sleep(interval * 2L);
            }
        }
        finally {
            progressMap.remove((Object)file);
            fis.close();
        }
        byte[] sha1 = md.digest();
        return "urn:sha1:" + Base32.encode(sha1);
    }

    private static boolean isValidUrn(String urnString) {
        int colon1Index = urnString.indexOf(":");
        if (colon1Index == -1 || colon1Index + 1 > urnString.length()) {
            return false;
        }
        int urnIndex1 = colon1Index - 3;
        int urnIndex2 = colon1Index + 1;
        if (urnIndex1 < 0 || urnIndex2 < 0) {
            return false;
        }
        int colon2Index = urnString.indexOf(":", colon1Index + 1);
        if (colon2Index == -1 || colon2Index + 1 > urnString.length()) {
            return false;
        }
        String urnType = urnString.substring(0, colon2Index + 1);
        return UrnType.isSupportedUrnType(urnType) && URN.isValidNamespaceSpecificString(urnString.substring(colon2Index + 1));
    }

    private static boolean isValidNamespaceSpecificString(String nss) {
        int length = nss.length();
        return length == 32 || length == 72;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this._urnString);
        s.writeObject(this._urnType);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._urnString = s.readUTF();
        this._urnType = (UrnType)s.readObject();
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
        if (!this._urnType.isSHA1()) {
            throw new InvalidObjectException("invalid urn type: " + this._urnType);
        }
        this._urnType = UrnType.SHA1;
    }
}

