/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public final class AlternateLocation
implements HTTPHeaderValue,
Comparable {
    public static final String ALT_VENDOR = "ALT";
    private final URL URL;
    private final URN SHA1_URN;
    private final String DISPLAY_STRING;
    private volatile int hashCode = 0;
    private volatile int _count = 0;
    private volatile boolean _demoted = false;

    public static AlternateLocation create(String location) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty location");
        }
        URL url = AlternateLocation.createUrl(location);
        URN sha1 = URN.createSHA1UrnFromURL(url);
        return new AlternateLocation(url, sha1);
    }

    public static AlternateLocation create(String location, URN urn) throws IOException {
        if (location == null || location.equals("")) {
            throw new IOException("null or empty location");
        }
        if (urn == null) {
            throw new IOException("null URN.");
        }
        if (location.toLowerCase().startsWith("http")) {
            AlternateLocation al = AlternateLocation.create(location);
            if (!al.SHA1_URN.equals(urn)) {
                throw new IOException("mismatched URN");
            }
            return al;
        }
        URL url = AlternateLocation.createUrlFromMini(location, urn);
        return new AlternateLocation(url, urn);
    }

    public static AlternateLocation create(URL url) throws MalformedURLException, IOException {
        if (url == null) {
            throw new NullPointerException("cannot accept null URL");
        }
        URL tempUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        URN sha1 = URN.createSHA1UrnFromURL(tempUrl);
        return new AlternateLocation(tempUrl, sha1);
    }

    public static AlternateLocation create(RemoteFileDesc rfd) throws IOException {
        if (rfd == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN urn = rfd.getSHA1Urn();
        if (urn == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        int port = rfd.getPort();
        URL url = new URL("http", rfd.getHost(), port, "/uri-res/N2R?" + urn.httpStringValue());
        return new AlternateLocation(url, urn);
    }

    public static AlternateLocation create(URN urn) {
        if (urn == null) {
            throw new NullPointerException("null sha1");
        }
        URL url = null;
        try {
            int port = RouterService.getPort();
            String addr = NetworkUtils.ip2string(RouterService.getAddress());
            url = new URL("http", addr, port, "/uri-res/N2R?" + urn.httpStringValue());
        }
        catch (MalformedURLException e) {
            ErrorService.error(e);
        }
        try {
            return new AlternateLocation(url, urn);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    private AlternateLocation(URL url, URN sha1) throws IOException {
        if (!NetworkUtils.isValidPort(url.getPort())) {
            throw new IOException("invalid port: " + url.getPort());
        }
        if (!NetworkUtils.isValidAddress(url.getHost())) {
            throw new IOException("invalid address: " + url.getHost());
        }
        if (NetworkUtils.isPrivateAddress(url.getHost())) {
            throw new IOException("invalid address: " + url.getHost());
        }
        if (sha1 == null) {
            throw new IOException("null sha1");
        }
        this.URL = url;
        this.SHA1_URN = sha1;
        InetAddress ia = InetAddress.getByName(this.URL.getHost());
        String ip = NetworkUtils.ip2string(ia.getAddress());
        this.DISPLAY_STRING = this.URL.getPort() == 6346 ? ip : ip + ":" + this.URL.getPort();
        this._count = 1;
        this._demoted = false;
    }

    public URL getUrl() {
        try {
            return new URL(this.URL.getProtocol(), this.URL.getHost(), this.URL.getPort(), this.URL.getFile());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Endpoint getHost() {
        return new Endpoint(this.URL.getHost(), this.URL.getPort());
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public synchronized int getCount() {
        return this._count;
    }

    public synchronized boolean getDemoted() {
        return this._demoted;
    }

    public String httpStringValue() {
        return this.DISPLAY_STRING;
    }

    public RemoteFileDesc createRemoteFileDesc(int size) {
        HashSet urnSet = new HashSet();
        urnSet.add((Object)this.getSHA1Urn());
        int quality = 3;
        return new RemoteFileDesc(this.URL.getHost(), this.URL.getPort(), 0L, this.URL.getFile(), size, DataUtils.EMPTY_GUID, 1000, true, quality, false, null, (Set)urnSet, false, false, ALT_VENDOR, System.currentTimeMillis(), null);
    }

    public synchronized void increment() {
        ++this._count;
    }

    synchronized void demote() {
        this._demoted = true;
    }

    synchronized void promote() {
        this._demoted = false;
    }

    public synchronized AlternateLocation createClone() {
        AlternateLocation ret = null;
        try {
            ret = new AlternateLocation(this.URL, this.SHA1_URN);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
        ret._demoted = this._demoted;
        ret._count = this._count;
        return ret;
    }

    private static URL createUrl(String locationHeader) throws IOException {
        String locHeader = locationHeader.toLowerCase();
        if (!locHeader.startsWith("http")) {
            throw new IOException("invalid location: " + locationHeader);
        }
        if (locHeader.lastIndexOf("http://") > 4) {
            throw new IOException("invalid location: " + locationHeader);
        }
        String urlStr = AlternateLocation.removeTimestamp(locHeader);
        URL url = new URL(urlStr);
        String host = url.getHost();
        if (host == null || host.equals("")) {
            throw new IOException("invalid location: " + locationHeader);
        }
        if (url.getPort() == -1) {
            url = new URL("http", url.getHost(), 80, url.getFile());
        }
        return url;
    }

    private static URL createUrlFromMini(String location, URN urn) throws IOException {
        int port = location.indexOf(58);
        String loc = port == -1 ? location : location.substring(0, port);
        try {
            new IP(loc);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("invalid location: " + location);
        }
        if (loc.indexOf(47) != -1) {
            throw new IOException("invalid location: " + location);
        }
        if (port == -1) {
            port = 6346;
        } else {
            if (location.length() < port + 1) {
                throw new IOException("invalid location: " + location);
            }
            try {
                port = Short.parseShort(location.substring(port + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("invalid location: " + location);
            }
        }
        return new URL("http", loc, port, "/uri-res/N2R?" + urn.httpStringValue());
    }

    private static String removeTimestamp(String locationHeader) {
        StringTokenizer st = new StringTokenizer(locationHeader);
        int numToks = st.countTokens();
        if (numToks == 1) {
            return locationHeader;
        }
        String curTok = null;
        for (int i = 0; i < numToks; ++i) {
            curTok = st.nextToken();
        }
        int tsIndex = locationHeader.indexOf(curTok);
        if (tsIndex == -1) {
            return null;
        }
        return locationHeader.substring(0, tsIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation other = (AlternateLocation)obj;
        return this.URL.getHost().equals(other.URL.getHost()) && this.URL.getPort() == other.URL.getPort() && this.SHA1_URN.equals(other.SHA1_URN) && this.URL.getProtocol().equals(other.URL.getProtocol());
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof AlternateLocation)) {
            return 1;
        }
        AlternateLocation other = (AlternateLocation)obj;
        if (this._demoted != other._demoted) {
            if (this._demoted) {
                return 1;
            }
            return -1;
        }
        int ret = this._count - other._count;
        if (ret != 0) {
            return ret;
        }
        ret = this.URL.getHost().compareTo(other.URL.getHost());
        if (ret != 0) {
            return ret;
        }
        ret = this.URL.getPort() - other.URL.getPort();
        if (ret != 0) {
            return ret;
        }
        ret = this.SHA1_URN.httpStringValue().compareTo(other.SHA1_URN.httpStringValue());
        if (ret != 0) {
            return ret;
        }
        return this.URL.getProtocol().hashCode() - other.URL.getProtocol().hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.URL.getHost().hashCode();
            result = 37 * result + this.URL.getPort();
            result = 37 * result + this.SHA1_URN.hashCode();
            this.hashCode = result = 37 * result + this.URL.getProtocol().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.URL.toExternalForm() + "," + this._count + "," + this._demoted;
    }
}

