/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalControl {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$browser$ExternalControl == null ? (class$com$limegroup$gnutella$browser$ExternalControl = ExternalControl.class$("com.limegroup.gnutella.browser.ExternalControl")) : class$com$limegroup$gnutella$browser$ExternalControl));
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HTTP = "http://";
    private static boolean initialized = false;
    private static String enqueuedRequest = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$browser$ExternalControl;

    public static String preprocessArgs(String[] args) {
        LOG.trace((Object)"enter proprocessArgs");
        String arg = new String();
        for (int i = 0; i < args.length; ++i) {
            arg = arg + args[i];
        }
        return arg;
    }

    public static void checkForActiveLimeWire() {
        if (ExternalControl.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public static void checkForActiveLimeWire(String arg) {
        if (CommonUtils.isWindows() && ExternalControl.testForLimeWire(arg)) {
            System.exit(0);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void enqueueMagnetRequest(String arg) {
        LOG.trace((Object)"enter enqueueMagnetRequest");
        enqueuedRequest = arg;
    }

    public static void runQueuedMagnetRequest() {
        initialized = true;
        if (enqueuedRequest != null) {
            String request = enqueuedRequest;
            enqueuedRequest = null;
            ExternalControl.handleMagnetRequest(request);
        }
    }

    public static void handleMagnetRequest(String arg) {
        LOG.trace((Object)"enter handleMagnetRequest");
        ActivityCallback callback = RouterService.getCallback();
        if (RouterService.getNumInitializedConnections() <= 0) {
            RouterService.connect();
        }
        callback.restoreApplication();
        callback.showDownloads();
        MagnetOptions[] options = ExternalControl.parseMagnet(arg);
        if (options == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid magnet, ignoring: " + arg));
            }
            return;
        }
        ExternalControl.downloadMagnet(options);
    }

    public static void downloadMagnet(MagnetOptions[] options) {
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < options.length; ++i) {
                LOG.debug((Object)("Kicking off downloader for option " + i + " " + options[i]));
            }
        }
        for (int i = 0; i < options.length; ++i) {
            MagnetOptions curOpt = options[i];
            URN urn = ExternalControl.extractSHA1URN(curOpt);
            String[] defaultURLs = null;
            ArrayList urls = new ArrayList();
            String errorMsg = null;
            urls.addAll((Collection)ExternalControl.collectPotentialURLs(curOpt.getXT()));
            urls.addAll((Collection)ExternalControl.collectPotentialURLs(curOpt.getXS()));
            urls.addAll((Collection)ExternalControl.collectPotentialURLs(curOpt.getAS()));
            if (urls.size() > 0) {
                Iterator it = urls.iterator();
                while (it.hasNext()) {
                    try {
                        String nextURL = (String)it.next();
                        new URI(nextURL.toCharArray());
                    }
                    catch (URIException e) {
                        LOG.warn((Object)"Invalid URI in magnet", (Throwable)e);
                        errorMsg = e.getMessage();
                        it.remove();
                    }
                }
                defaultURLs = (String[])urls.toArray((Object[])new String[urls.size()]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing magnet with params:\nurn [" + urn + "]\n" + "options [" + curOpt + "]"));
            }
            if (urls.size() <= 0 && urn == null && (curOpt.getKT() == null || "".equals(curOpt.getKT()))) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid magnet. urls.size == " + urls.size() + "curOpt.kt == " + curOpt.getKT()));
                }
                errorMsg = errorMsg != null ? curOpt.toString() + " (" + errorMsg + ")" : curOpt.toString();
                MessageService.showError("ERROR_BAD_MAGNET_LINK", errorMsg);
                return;
            }
            if (errorMsg != null) {
                MessageService.showError("ERROR_INVALID_URLS_IN_MAGNET");
            }
            try {
                RouterService.download(urn, curOpt.getKT(), curOpt.getDN(), defaultURLs, false);
                continue;
            }
            catch (AlreadyDownloadingException a) {
                MessageService.showError("ERROR_ALREADY_DOWNLOADING", a.getFilename());
                continue;
            }
            catch (IllegalArgumentException il) {
                ErrorService.error(il);
                continue;
            }
            catch (FileExistsException fex) {
                MessageService.showError("ERROR_ALREADY_EXISTS", fex.getFileName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireMagnet(Socket socket) {
        LOG.trace((Object)"enter fireMagnet");
        Thread.currentThread().setName("IncomingMagnetThread");
        try {
            if (!LOCALHOST.equals(socket.getInetAddress().getHostAddress())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Invalid magnet request from: " + socket.getInetAddress().getHostAddress()));
                }
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader br = new ByteReader(socket.getInputStream());
            String line = br.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = CommonUtils.getUserName() + "\r\n";
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            ExternalControl.handleMagnetRequest(line);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception while responding to magnet request", (Throwable)e);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean testForLimeWire(String arg) {
        Socket socket = null;
        int port = ConnectionSettings.PORT.getValue();
        if (!NetworkUtils.isValidPort(port)) {
            ConnectionSettings.PORT.revertToDefault();
            port = ConnectionSettings.PORT.getValue();
        }
        socket = Sockets.connect(LOCALHOST, port, 500);
        InputStream istream = socket.getInputStream();
        socket.setSoTimeout(500);
        ByteReader byteReader = new ByteReader(istream);
        OutputStream os = socket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter out = new BufferedWriter(osw);
        out.write("MAGNET " + arg + " ");
        out.write("\r\n");
        out.flush();
        String str = byteReader.readLine();
        boolean bl = str != null && str.startsWith(CommonUtils.getUserName());
        Object var11_11 = null;
        if (socket == null) return bl;
        try {
            socket.close();
            return bl;
        }
        catch (IOException e) {
            // empty catch block
        }
        return bl;
        catch (IOException iOException) {
            try {
                Object var11_12 = null;
                if (socket == null) return false;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                socket.close();
                return false;
            }
            catch (IOException e) {}
            return false;
        }
    }

    private static URN extractSHA1URN(MagnetOptions curOpt) {
        try {
            return ExternalControl.extractSHA1URNFromList(curOpt.getXT());
        }
        catch (IOException e1) {
            try {
                return ExternalControl.extractSHA1URNFromList(curOpt.getXS());
            }
            catch (IOException e2) {
                try {
                    return ExternalControl.extractSHA1URNFromList(curOpt.getAS());
                }
                catch (IOException e3) {
                    return null;
                }
            }
        }
    }

    private static URN extractSHA1URNFromList(List strings) throws IOException {
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            try {
                return URN.createSHA1Urn((String)iter.next());
            }
            catch (IOException e) {
                if (iter.hasNext()) continue;
                throw e;
            }
        }
        throw new IOException("List was empty. No URNs found.");
    }

    private static List collectPotentialURLs(List strings) {
        ArrayList ret = new ArrayList();
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (!str.startsWith(HTTP)) continue;
            ret.add((Object)str);
        }
        return ret;
    }

    public static MagnetOptions[] parseMagnet(String arg) {
        LOG.trace((Object)"enter parseMagnet");
        Object[] ret = null;
        HashMap options = new HashMap();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.startsWith("magnet:?")) {
            return ret;
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            int index;
            String cmdstr;
            String keystr;
            block19: {
                keystr = st.nextToken();
                int start = (keystr = keystr.trim()).indexOf("=") + 1;
                if (start == 0) continue;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                try {
                    cmdstr = URLDecoder.decode(cmdstr);
                }
                catch (IOException e1) {
                    continue;
                }
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block19;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            Integer iIndex = new Integer(index);
            MagnetOptions curOptions = (MagnetOptions)options.get((Object)iIndex);
            if (curOptions == null) {
                curOptions = new MagnetOptions();
            }
            if (keystr.startsWith("xt")) {
                curOptions.addXT(cmdstr);
            } else if (keystr.startsWith("dn")) {
                curOptions.setDN(cmdstr);
            } else if (keystr.startsWith("kt")) {
                curOptions.setKT(cmdstr);
            } else if (keystr.startsWith("xs")) {
                curOptions.addXS(cmdstr);
            } else if (keystr.startsWith("as")) {
                curOptions.addAS(cmdstr);
            }
            options.put((Object)iIndex, (Object)curOptions);
        }
        ret = new MagnetOptions[options.size()];
        ret = (MagnetOptions[])options.values().toArray(ret);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

