/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagnetDownloader
extends ManagedDownloader
implements Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$MagnetDownloader == null ? (class$com$limegroup$gnutella$downloader$MagnetDownloader = MagnetDownloader.class$("com.limegroup.gnutella.downloader.MagnetDownloader")) : class$com$limegroup$gnutella$downloader$MagnetDownloader));
    static final long serialVersionUID = 9092913030585214105L;
    static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private String _textQuery;
    private URN _urn;
    private String _filename;
    private String[] _defaultURLs;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$MagnetDownloader;

    public MagnetDownloader(IncompleteFileManager ifm, URN urn, String textQuery, String filename, String[] defaultURLs) {
        super(new RemoteFileDesc[0], ifm, null);
        this._textQuery = textQuery;
        this._urn = urn;
        this._filename = filename;
        this._defaultURLs = defaultURLs;
    }

    protected void tryAllDownloads(boolean deserialized) {
        for (int i = 0; this._defaultURLs != null && i < this._defaultURLs.length; ++i) {
            RemoteFileDesc defaultRFD = MagnetDownloader.createRemoteFileDesc(this._defaultURLs[i], this._filename, this._urn);
            if (defaultRFD != null) {
                boolean added = super.addDownloadForced(defaultRFD, true);
                Assert.that(added, "Download rfd not accepted " + defaultRFD);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)("Ignoring magnet url: " + this._defaultURLs[i]));
        }
        super.tryAllDownloads(deserialized);
    }

    private static RemoteFileDesc createRemoteFileDesc(String defaultURL, String filename, URN urn) {
        if (defaultURL == null) {
            LOG.debug((Object)"createRemoteFileDesc called with null URL");
            return null;
        }
        URL url = null;
        try {
            url = new URL(defaultURL);
            int port = url.getPort();
            if (port < 0) {
                port = 80;
            }
            HashSet urns = new HashSet(1);
            if (urn != null) {
                urns.add((Object)urn);
            }
            return new URLRemoteFileDesc(url.getHost(), port, 0L, MagnetDownloader.filename(filename, url), MagnetDownloader.contentLength(url), new byte[16], 3000, false, 3, false, null, (Set)urns, false, false, "", 0L, url, null);
        }
        catch (IOException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("IOException while processing magnet URL: " + url), (Throwable)e);
            }
            return null;
        }
    }

    static String filename(String filename, URL url) {
        if (filename != null) {
            return filename;
        }
        String path = url.getFile();
        if (path.length() > 0) {
            int i = path.lastIndexOf(47);
            if (i < 0) {
                return path;
            }
            if (i >= 0 && i < path.length() - 1) {
                return path.substring(i + 1);
            }
        }
        return DOWNLOAD_PREFIX + url.getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int contentLength(URL url) throws IOException {
        try {
            new URI(url.toExternalForm().toCharArray());
        }
        catch (URIException e) {
            throw new IOException("invalid url: " + url);
        }
        HeadMethod head = new HeadMethod(url.toExternalForm());
        head.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        HttpClient client = HttpClientManager.getNewClient();
        try {
            client.executeMethod((HttpMethod)head);
            if (head.getStatusCode() != 200) {
                throw new IOException("Got " + head.getStatusCode() + " instead of 200");
            }
            int length = head.getResponseContentLength();
            if (length < 0) {
                throw new IOException("No content length");
            }
            int n = length;
            return n;
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
        }
    }

    protected QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this._textQuery != null) {
            return QueryRequest.createQuery(this._textQuery);
        }
        if (this._filename != null) {
            return QueryRequest.createQuery(this._filename);
        }
        if (this._urn != null) {
            return QueryRequest.createQuery(this._urn);
        }
        if (this._defaultURLs != null && this._defaultURLs.length > 0) {
            throw new CantResumeException("exact source");
        }
        return super.newRequery(numRequeries);
    }

    protected boolean allowAddition(RemoteFileDesc other) {
        int score;
        Set urns;
        if (this._urn != null && (urns = other.getUrns()) != null && urns.contains((Object)this._urn)) {
            return true;
        }
        return this._textQuery != null && (score = ResponseVerifier.score(this._textQuery, null, other)) == 100;
    }

    public synchronized String getFileName() {
        if (this._filename != null) {
            return this._filename;
        }
        String fname = null;
        if (this.hasRFD()) {
            fname = super.getFileName();
        }
        if (fname == null || fname.equals("")) {
            fname = this.getFileNameHint();
        }
        return fname;
    }

    private String getFileNameHint() {
        if (this._urn != null) {
            return this._urn.toString();
        }
        if (this._textQuery != null) {
            return this._textQuery;
        }
        if (this._defaultURLs != null && this._defaultURLs.length > 0) {
            return this._defaultURLs[0];
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

