/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescGrouper;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$ManagedDownloader == null ? (class$com$limegroup$gnutella$downloader$ManagedDownloader = ManagedDownloader.class$("com.limegroup.gnutella.downloader.ManagedDownloader")) : class$com$limegroup$gnutella$downloader$ManagedDownloader));
    static final long serialVersionUID = 2772570805975885257L;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 16000;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 100000;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    static final int OVERLAP_BYTES = 10;
    private static final int MAX_CORRUPTION_RECOVERY_ATTEMPTS = 5;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    private static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private RemoteFileDescGrouper buckets;
    private List currentRFDs;
    private int bucketNumber;
    private Thread dloaderManagerThread;
    private boolean stopped;
    private List dloaders;
    private List threads;
    private Map queuedThreads;
    private List files;
    private AlternateLocationCollection validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private File incompleteFile;
    private File completeFile;
    private String queuePosition;
    private String queuedVendor;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private RequeryLock reqLock = new RequeryLock();
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private HashTree hashTree = null;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private final GUID originalQueryGUID;
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private boolean initDone;
    private final long SIXTY_KB = 60000L;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    private static final int CONNECTION_DELAY = 500;
    static boolean NO_DELAY = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$ManagedDownloader;

    public ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc, GUID originalQueryGUID) {
        TRIVIAL_WORDS.add((Object)"the");
        TRIVIAL_WORDS.add((Object)"an");
        TRIVIAL_WORDS.add((Object)"a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        if (files == null) {
            throw new NullPointerException("null RFDS");
        }
        if (ifc == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.allFiles = files;
        this.incompleteFileManager = ifc;
        this.originalQueryGUID = originalQueryGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            stream.writeObject(this.incompleteFileManager);
        }
        stream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])stream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
        stream.readObject();
        this.reqLock = new RequeryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DownloadManager manager, FileManager fileManager, ActivityCallback callback, final boolean deserialized) {
        this.manager = manager;
        this.fileManager = fileManager;
        this.callback = callback;
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.queuedThreads = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap((Map)new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap((Map)new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
        this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
            if (this.shouldInitAltLocs(deserialized)) {
                this.initializeAlternateLocations();
            }
        }
        this.dloaderManagerThread = new ManagedThread("ManagedDownload"){

            public void managedRun() {
                try {
                    ManagedDownloader.this.tryAllDownloads(deserialized);
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    protected void initializeIncompleteFile(File incFile) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = incFile;
        this.commonOutFile = this.incompleteFileManager.getEntry(incFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeAlternateLocations() {
        if (this.incompleteFile == null) {
            return;
        }
        URN hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile);
        if (hash != null) {
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            FileDesc fd = this.fileManager.getFileDescForUrn(hash);
            if (fd != null) {
                AlternateLocationCollection coll;
                this.validAlts = AlternateLocationCollection.create(hash);
                AlternateLocationCollection alternateLocationCollection = coll = fd.getAlternateLocationCollection();
                synchronized (alternateLocationCollection) {
                    Iterator iter = coll.iterator();
                    while (iter.hasNext()) {
                        AlternateLocation loc = (AlternateLocation)iter.next();
                        this.addDownload(loc.createRemoteFileDesc((int)size), false);
                    }
                }
            }
        }
    }

    public boolean conflicts(RemoteFileDesc other) {
        try {
            File otherFile = this.incompleteFileManager.getFile(other);
            return this.conflicts(otherFile);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflicts(File incFile) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                try {
                    File thisFile = this.incompleteFileManager.getFile(rfd);
                    if (!thisFile.equals(incFile)) continue;
                    return true;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean conflicts(URN urn) {
        Assert.that(urn != null, "attempting to check conflicts with null urn");
        File otherFile = this.incompleteFileManager.getFileForUrn(urn);
        if (otherFile == null) {
            return false;
        }
        return this.conflicts(otherFile);
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this.allFiles.length < 0) {
            throw new CantResumeException(UNKNOWN_FILENAME);
        }
        if (this.allFiles[0].getSHA1Urn() == null) {
            return QueryRequest.createQuery(this.extractQueryString());
        }
        return QueryRequest.createQuery(this.extractQueryString());
    }

    protected int getQueryCount(boolean deserializedFromDisk) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pauseForRequery(int numRequeries, boolean deserializedFromDisk) throws InterruptedException {
        if (numRequeries >= 1) {
            return false;
        }
        boolean retVal = false;
        RequeryLock requeryLock = this.reqLock;
        synchronized (requeryLock) {
            this.setState(13);
            try {
                retVal = this.reqLock.lock(0L);
            }
            catch (InterruptedException stopException) {
                if (!this.stopped) {
                    ErrorService.error(stopException);
                }
                throw stopException;
            }
        }
        return retVal;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return false;
    }

    private final synchronized String extractQueryString() {
        Assert.that(this.allFiles.length > 0, "Precondition violated");
        String retString = null;
        int MAX_LEN = 30;
        Set intersection = ManagedDownloader.keywords(this.allFiles[0].getFileName());
        if (intersection.size() < 1) {
            retString = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
        } else {
            StringBuffer sb = new StringBuffer();
            int numWritten = 0;
            Iterator keys = intersection.iterator();
            while (keys.hasNext() && numWritten < 30) {
                String currKey = (String)keys.next();
                if (numWritten + currKey.length() >= 30) continue;
                if (numWritten > 0) {
                    sb.append(" ");
                }
                sb.append(currKey);
                numWritten += currKey.length() + (numWritten == 0 ? 0 : 1);
            }
            retString = sb.toString();
            if (retString.equals(UNKNOWN_FILENAME)) {
                retString = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
            }
        }
        Assert.that(retString.length() <= 30, "Original filename: " + this.allFiles[0].getFileName() + ", converted: " + retString);
        Assert.that(!retString.equals(UNKNOWN_FILENAME), "Original filename: " + this.allFiles[0].getFileName());
        Assert.that(retString != null, "Original filename: " + this.allFiles[0].getFileName());
        retString = I18NConvert.instance().getNorm(retString);
        Assert.that(!retString.equals(UNKNOWN_FILENAME), "I18N: Original filename: " + this.allFiles[0].getFileName());
        Assert.that(retString != null, "I18N: Original filename: " + this.allFiles[0].getFileName());
        return retString;
    }

    private static final Set keywords(String fileName) {
        fileName = ManagedDownloader.ripExtension(fileName);
        HashSet ret = new HashSet();
        StringTokenizer st = new StringTokenizer(fileName, " -._+/*()\\");
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            try {
                new Double(currToken);
            }
            catch (NumberFormatException normalWord) {
                if (TRIVIAL_WORDS.contains((Object)currToken)) continue;
                ret.add((Object)currToken);
            }
        }
        return ret;
    }

    private static String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        Object object;
        if (!this.initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            this.initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        if (!IPFilter.instance().allow(other.getHost())) {
            return false;
        }
        object = this.altLock;
        synchronized (object) {
            if (other.isFromAlternateLocation() && this.invalidAlts.contains((Object)other.getRemoteHostData())) {
                return false;
            }
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                RemoteFileDesc rfd = this.allFiles[i];
                URN urn = rfd.getSHA1Urn();
                if (otherUrn != null && urn != null) {
                    return otherUrn.equals(urn);
                }
                String thisName = rfd.getFileName();
                long thisLength = rfd.getSize();
                if (!this.sizeClose(otherLength, thisLength) || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean sizeClose(long one, long two) {
        boolean retVal = false;
        if (one == two) {
            retVal = true;
        } else {
            long sizeDiff = Math.abs(one - two);
            if (sizeDiff <= 60000L) {
                retVal = true;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)ManagedDownloader.ripExtension(one).length(), 0.1f * (float)ManagedDownloader.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MD.namesClose(): one = " + one));
            LOG.debug((Object)("MD.namesClose(): two = " + two));
            LOG.debug((Object)("MD.namesClose(): retVal = " + retVal));
        }
        return retVal;
    }

    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (!this.allowAddition(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    protected final synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        rfd.setDownloading(true);
        if (NetworkUtils.isMe(rfd.getHost(), rfd.getPort())) {
            return true;
        }
        if (cache) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                if (!rfd.equals(this.allFiles[i])) continue;
                cache = false;
                break;
            }
        }
        boolean added = false;
        if (this.shouldAllowRFD(rfd)) {
            boolean bl = added = this.buckets.add(rfd, true) != -1;
        }
        if (cache) {
            RemoteFileDesc[] newAllFiles = new RemoteFileDesc[this.allFiles.length + 1];
            System.arraycopy(this.allFiles, 0, newAllFiles, 0, this.allFiles.length);
            newAllFiles[newAllFiles.length - 1] = rfd;
            this.allFiles = newAllFiles;
        }
        if (added) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("added rfd: " + rfd));
            }
            if (this.state == 3 || this.state == 8 || this.state == 6 || this.state == 13) {
                this.reqLock.releaseDueToNewResults();
            } else {
                this.notify();
            }
        }
        return true;
    }

    private synchronized boolean shouldAllowRFD(RemoteFileDesc rfd) {
        if (this.buckets == null) {
            return false;
        }
        return this.currentRFDs == null || !this.currentRFDs.contains((Object)rfd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) throws IOException {
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(file, index, clientGUID);
        Object lock = this.miniRFDToLock.get((Object)mrfd);
        if (lock == null) {
            return false;
        }
        this.threadLockToSocket.put(lock, (Object)socket);
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            ((HTTPDownloader)iter.next()).stop();
        }
        iter = this.threads.iterator();
        while (iter.hasNext()) {
            ((Thread)iter.next()).interrupt();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        URN bucketHash = null;
        IncompleteFileDesc ifd = null;
        AlternateLocation loc = null;
        AlternateLocation forFD = null;
        if (!rfd.isAltLocCapable()) {
            return;
        }
        bucketHash = this.buckets.getURNForBucket(this.bucketNumber);
        Assert.that(bucketHash != null, "null bucketHash.");
        Assert.that(bucketHash.equals(rfd.getSHA1Urn()), "wrong loc SHA1");
        if (this.validAlts == null) {
            this.validAlts = AlternateLocationCollection.create(bucketHash);
        }
        try {
            loc = AlternateLocation.create(rfd);
            forFD = AlternateLocation.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader httpDloader = (HTTPDownloader)iter.next();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (r.getHost() == rfd.getHost() && r.getPort() == rfd.getPort()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(loc);
                continue;
            }
            httpDloader.addFailedAltLoc(loc);
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc && !bucketHash.equals((ifd = (IncompleteFileDesc)fd).getSHA1Urn())) {
            Assert.silent(false, "wrong IFD.\nours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + bucketHash + "\ntheir hashes: " + DataUtils.listSet(ifd.getUrns()) + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
            this.fileManager.removeFileIfShared(this.incompleteFile);
            ifd = null;
        }
        Object object = this.altLock;
        synchronized (object) {
            if (good) {
                if (!this.validAlts.contains(loc)) {
                    if (RECORD_STATS && rfd.isFromAlternateLocation()) {
                        DownloadStat.ALTERNATE_WORKED.incrementStat();
                    }
                    this.validAlts.add(loc);
                    if (ifd != null) {
                        ifd.addVerified(forFD);
                    }
                }
            } else {
                if (RECORD_STATS && rfd.isFromAlternateLocation()) {
                    DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                }
                this.validAlts.remove(loc);
                if (ifd != null) {
                    ifd.remove(forFD);
                }
                this.invalidAlts.add((Object)rfd.getRemoteHostData());
                this.recentInvalidAlts.add((Object)loc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() throws AlreadyDownloadingException {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state != 3 && this.state != 6 && this.state != 5 && this.state != 13) {
                return false;
            }
        }
        String conflict = this.manager.conflicts(this.allFiles, this);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            if (this.state == 6 || this.state == 5) {
                if (this.state == 6 && this.dloaderManagerThread != null && this.dloaderManagerThread.isAlive()) {
                    ManagedDownloader managedDownloader3 = this;
                    synchronized (managedDownloader3) {
                        this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
                    }
                    this.reqLock.releaseDueToNewResults();
                } else {
                    this.initialize(this.manager, this.fileManager, this.callback, false);
                }
            } else if (this.state == 3) {
                if (this.dloaderManagerThread != null) {
                    this.dloaderManagerThread.interrupt();
                }
            } else if (this.state == 13) {
                this.reqLock.releaseDueToRequery();
            }
            return true;
        }
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.completeFile;
        }
        return this.incompleteFile;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int size = this.amountForPreview();
            if (size <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, size, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.completeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iter = this.commonOutFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    protected long[] getFailedState(boolean deserialized, long timeSpentWaiting) {
        return new long[2];
    }

    public synchronized void finish() {
        if (this.commonOutFile != null) {
            this.commonOutFile.clearManagedDownloader();
        }
        if (this.allFiles != null) {
            for (int i = 0; i < this.allFiles.length; ++i) {
                this.allFiles[i].setDownloading(false);
            }
        }
    }

    private URN getBestURN() {
        URN retURN = null;
        List urns = this.buckets.getURNs();
        int currBigSize = 0;
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            VerifyingFile vF;
            File incomplete;
            URN currURN = (URN)iter.next();
            if (currURN == null || (incomplete = this.incompleteFileManager.getFileForUrn(currURN)) == null || (vF = this.incompleteFileManager.getEntry(incomplete)) == null || retURN != null && vF.getBlockSize() <= currBigSize) continue;
            currBigSize = vF.getBlockSize();
            retURN = currURN;
        }
        if (retURN == null) {
            retURN = this.buckets.getBestURN();
        }
        return retURN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tryAllDownloads(boolean deserializedFromDisk) {
        int numQueries = this.getQueryCount(deserializedFromDisk);
        long timeQuerySent = System.currentTimeMillis();
        long timeSpentWaiting = 0L;
        boolean triedLocatingSources = false;
        while (true) {
            try {
                while (true) {
                    boolean areThereNewResults;
                    MessageRouter mr;
                    Set guessLocs;
                    boolean waitForRetry;
                    block28: {
                        this.setState(0);
                        this.queuePosition = UNKNOWN_FILENAME;
                        this.queuedVendor = UNKNOWN_FILENAME;
                        this.manager.waitForSlot(this);
                        waitForRetry = false;
                        int currentBucket = 0;
                        try {
                            Iterator iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                this.bucketNumber = currentBucket;
                                this.cleanup();
                                this.files = (List)iter.next();
                                if (this.checkHosts()) {
                                    this.setState(6);
                                    return;
                                }
                                if (this.files.size() > 0) {
                                    int status = this.tryAllDownloads2();
                                    if (status == 4) {
                                        this.setState(4);
                                        this.manager.remove(this, true);
                                        return;
                                    }
                                    if (status == 7) {
                                        this.setState(7);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 9) {
                                        this.setState(9);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 3) {
                                        waitForRetry = true;
                                    } else {
                                        Assert.that(status == 6, "Bad status from tad2: " + status);
                                    }
                                }
                                ++currentBucket;
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.stopped) break block28;
                            ErrorService.error(e);
                        }
                    }
                    this.manager.yieldSlot(this);
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    Assert.that(this.getState() != 6);
                    Assert.that(this.getState() != 4);
                    Assert.that(this.getState() != 7);
                    Assert.that(this.getState() != 9);
                    if (this.originalQueryGUID != null && !triedLocatingSources && (guessLocs = (mr = RouterService.getMessageRouter()).getGuessLocs(this.originalQueryGUID)) != null && !guessLocs.isEmpty()) {
                        this.setState(15);
                        triedLocatingSources = true;
                        areThereNewResults = false;
                        URN bestURN = this.getBestURN();
                        Iterator i = guessLocs.iterator();
                        while (bestURN != null && i.hasNext()) {
                            GUESSEndpoint ep = (GUESSEndpoint)i.next();
                            OnDemandUnicaster.query(ep, bestURN);
                            if (areThereNewResults) continue;
                            areThereNewResults = this.reqLock.lock(750L);
                        }
                        if (areThereNewResults) continue;
                    }
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    long currTime = System.currentTimeMillis();
                    if (waitForRetry) {
                        ManagedDownloader areThereNewResults2 = this;
                        synchronized (areThereNewResults2) {
                            this.retriesWaiting = 0;
                            Iterator iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                List bucket = (List)iter.next();
                                this.retriesWaiting += bucket.size();
                            }
                        }
                        long time = this.calculateWaitTime();
                        this.setState(3, time);
                        this.reqLock.lock(time);
                        continue;
                    }
                    areThereNewResults = false;
                    long timeToWait = (long)TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - timeQuerySent);
                    if (numQueries > 0 && timeToWait > 0L) {
                        this.setState(8, timeToWait);
                        areThereNewResults = this.reqLock.lock(timeToWait);
                    }
                    if (areThereNewResults || this.pauseForRequery(numQueries, deserializedFromDisk)) continue;
                    if (numQueries < 1) {
                        this.waitForStableConnections();
                        try {
                            if (this.manager.sendQuery(this, this.newRequery(numQueries))) {
                                ++numQueries;
                            }
                            timeQuerySent = System.currentTimeMillis();
                        }
                        catch (CantResumeException ignore) {}
                        continue;
                    }
                    long[] instructions = this.getFailedState(deserializedFromDisk, timeSpentWaiting);
                    if (instructions[1] > 0L) {
                        this.setState((int)instructions[0], instructions[1]);
                        this.reqLock.lock(instructions[1]);
                        timeSpentWaiting += System.currentTimeMillis() - currTime;
                        continue;
                    }
                    this.setState(6);
                    this.reqLock.lock(0L);
                }
            }
            catch (InterruptedException e) {
                if (!this.stopped) continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    private void waitForStableConnections() throws InterruptedException {
        if (NO_DELAY) {
            return;
        }
        while (RouterService.countConnectionsWithNMessages(6) < 2 && RouterService.getActiveConnectionMessages() < 45) {
            this.setState(14);
            Thread.sleep(500L);
        }
    }

    private synchronized long calculateWaitTime() {
        if (this.files == null || this.files.size() == 0) {
            return 0L;
        }
        int waitTime = Integer.MAX_VALUE;
        for (int i = 0; i < this.files.size(); ++i) {
            waitTime = Math.min(waitTime, ((RemoteFileDesc)this.files.get(i)).getWaitTime());
        }
        return waitTime * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads2() throws InterruptedException {
        URN fileHash;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.files.size() == 0) {
                return 6;
            }
        }
        String fileName = this.getFileName();
        try {
            this.incompleteFile = this.incompleteFileManager.getFile((RemoteFileDesc)this.files.get(0));
            File saveDir = SharingSettings.getSaveDirectory();
            this.completeFile = new File(saveDir, fileName);
            String savePath = saveDir.getCanonicalPath();
            String completeFileParentPath = new File(this.completeFile.getParent()).getCanonicalPath();
            if (!savePath.equals(completeFileParentPath)) {
                return 7;
            }
        }
        catch (IOException e) {
            ErrorService.error(e, "incomplete: " + this.incompleteFile);
            return 7;
        }
        URN sha1 = this.buckets.getURNForBucket(this.bucketNumber);
        if (sha1 != null) {
            this.validAlts = AlternateLocationCollection.create(sha1);
            this.hashTree = TigerTreeCache.instance().getHashTree(sha1);
        }
        int i = 0;
        while (true) {
            int status = -1;
            try {
                status = this.tryAllDownloads3();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.commonOutFile.close();
            this.waitForCorruptResponse();
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (status == -1) {
                throw new InterruptedException();
            }
            if (status != 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("stopping early with status: " + status));
                }
                return status;
            }
            fileHash = this.scanForCorruption(i);
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.state != 16) break;
            ++i;
        }
        return this.saveFile(fileHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URN scanForCorruption(int iteration) {
        if (this.corruptState == 2) {
            return null;
        }
        URN bucketHash = this.buckets.getURNForBucket(this.bucketNumber);
        URN fileHash = null;
        try {
            this.setState(11);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException ignored) {
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (bucketHash == null) {
            return fileHash;
        }
        if (bucketHash.equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("hash verification problem, fileHash=" + fileHash + ", bucketHash=" + bucketHash));
        }
        Object ignored = this.corruptStateLock;
        synchronized (ignored) {
            this.setState(9);
            this.promptAboutCorruptDownload();
            this.waitForCorruptResponse();
        }
        if (this.corruptState == 2) {
            return fileHash;
        }
        if (iteration == 5) {
            this.treeRecoveryFailed(bucketHash);
        } else if (this.hashTree != null) {
            try {
                this.setState(16);
                LOG.debug((Object)"identifying corruption...");
                int deleted = this.commonOutFile.deleteCorruptedBlocks(this.hashTree, this.incompleteFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("deleted " + deleted + " blocks"));
                }
                this.corruptState = 0;
                if (deleted == 0) {
                    this.treeRecoveryFailed(bucketHash);
                }
            }
            catch (IOException ioe) {
                LOG.debug((Object)ioe);
                this.treeRecoveryFailed(bucketHash);
            }
        }
        return fileHash;
    }

    private void treeRecoveryFailed(URN hash) {
        TigerTreeCache.instance().purgeTree(hash);
        this.hashTree = null;
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        this.setState(17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveFile(URN fileHash) {
        FileDesc fd;
        this.setState(12);
        File completeFileDir = FileUtils.getParentFile(this.completeFile);
        FileUtils.setWriteable(completeFileDir);
        FileUtils.setWriteable(this.completeFile);
        this.completeFile.delete();
        boolean success = this.incompleteFile.renameTo(this.completeFile);
        if (!success && (fd = RouterService.getFileManager().getFileDescForFile(this.incompleteFile)) != null) {
            UploadManager upMan;
            UploadManager uploadManager = upMan = RouterService.getUploadManager();
            synchronized (uploadManager) {
                if (upMan.killUploadsForFileDesc(fd)) {
                    success = this.incompleteFile.renameTo(this.completeFile);
                }
            }
        }
        if (!success) {
            success = CommonUtils.copy(this.incompleteFile, this.completeFile);
        }
        if (!success) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        if (fileHash != null) {
            HashSet urns = new HashSet(1);
            urns.add((Object)fileHash);
            File file = this.completeFile;
            try {
                file = FileUtils.getCanonicalFile(this.completeFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            UrnCache.instance().addUrns(file, (Set)urns);
            SavedFileManager.instance().addSavedFile(file, (Set)urns);
        }
        FileDesc fileDesc = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.validAlts != null && fileDesc != null) {
            this.sendAlternateLocations(fileDesc);
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlternateLocations(FileDesc fileDesc) {
        URN fileHash = fileDesc.getSHA1Urn();
        if (fileHash.equals(this.validAlts.getSHA1Urn())) {
            LOG.trace((Object)"MANAGER: adding valid alts to FileDesc");
            this.addLocationsToFile(this.validAlts, fileDesc);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HashSet set = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                set = new HashSet((Collection)this.files);
            }
            if (fileDesc.getSize() < (long)HTTPDownloader.MIN_PARTIAL_FILE_BYTES || !UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                LOG.trace((Object)"MANAGER: starting HEAD request");
                HeadRequester requester = new HeadRequester((Set)set, fileHash, fileDesc, fileDesc.getAlternateLocationCollection());
                ManagedThread headThread = new ManagedThread(requester, "HEAD Request Thread");
                headThread.setDaemon(true);
                headThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToFile(AlternateLocationCollection validAlts, AlternateLocationCollector collector) {
        Object object = this.altLock;
        synchronized (object) {
            Iterator i = validAlts.iterator();
            while (i.hasNext()) {
                AlternateLocation al = (AlternateLocation)i.next();
                collector.add(al.createClone());
            }
        }
    }

    private boolean fileExists(File f) {
        return f.exists();
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryAllDownloads3() throws InterruptedException {
        LOG.trace((Object)"MANAGER: entered tryAllDownloads3");
        int completedSize = -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Assert.that(this.incompleteFile != null);
            completedSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                if (this.commonOutFile != null) {
                    this.commonOutFile.clearManagedDownloader();
                }
                this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
            }
            if (this.commonOutFile == null) {
                LOG.trace((Object)"creating a verifying file");
                this.commonOutFile = new VerifyingFile(true, completedSize);
                try {
                    this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
                }
                catch (IOException ioe) {
                    ErrorService.error(ioe, "file: " + this.incompleteFile);
                    return 7;
                }
            }
            try {
                this.commonOutFile.open(this.incompleteFile, this);
            }
            catch (IOException e) {
                if (!IOUtils.handleException(e, "DOWNLOAD")) {
                    ErrorService.error(e);
                }
                return 7;
            }
        }
        this.currentRFDs = new LinkedList();
        int size = -1;
        int connectTo = -1;
        int dloadsCount = -1;
        while (true) {
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                if (this.stopped) {
                    LOG.warn((Object)"MANAGER: terminating because of stop");
                    throw new InterruptedException();
                }
                if (this.dloaders.size() == 0 && this.commonOutFile.isComplete()) {
                    int doneSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
                    Assert.that(completedSize == doneSize, "incomplete files (or size!) changed!");
                    for (int i2 = this.threads.size(); i2 > 0; --i2) {
                        Thread t = (Thread)this.threads.get(i2 - 1);
                        t.interrupt();
                    }
                    LOG.trace((Object)"MANAGER: terminating because of completion");
                    return 4;
                }
                if (this.threads.size() == 0) {
                    if (this.files.size() > 0 && this.calculateWaitTime() > 0L) {
                        LOG.trace((Object)"MANAGER: terminating with busy");
                        return 3;
                    }
                    if (this.files.size() == 0) {
                        LOG.trace((Object)"MANAGER: terminating w/o hope");
                        return 6;
                    }
                }
            }
            size = this.files.size();
            connectTo = this.getNumAllowedDownloads();
            dloadsCount = this.dloaders.size();
            for (int i = 0; i < connectTo + 1 && i < size && dloadsCount < this.getSwarmCapacity(); ++i) {
                RemoteFileDesc rfd;
                ManagedDownloader i2 = this;
                synchronized (i2) {
                    rfd = this.removeBest(this.files);
                    if (rfd.isBusy()) {
                        this.files.add((Object)rfd);
                        break;
                    }
                    this.currentRFDs.add((Object)rfd);
                }
                ManagedThread connectCreator = new ManagedThread("DownloadWorker"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void managedRun() {
                        ManagedDownloader managedDownloader;
                        boolean iterate = false;
                        try {
                            try {
                                iterate = ManagedDownloader.this.connectAndDownload(rfd);
                            }
                            catch (Throwable e) {
                                iterate = true;
                                if (!(e instanceof InterruptedException)) {
                                    ErrorService.error(e);
                                }
                                Object var4_3 = null;
                                ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                                synchronized (managedDownloader3) {
                                    ManagedDownloader.this.currentRFDs.remove((Object)rfd);
                                    ManagedDownloader.this.threads.remove((Object)this);
                                    if (!iterate) return;
                                    ManagedDownloader.this.notifyAll();
                                    return;
                                }
                            }
                            Object var4_2 = null;
                            managedDownloader = ManagedDownloader.this;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                            synchronized (managedDownloader2) {
                                ManagedDownloader.this.currentRFDs.remove((Object)rfd);
                                ManagedDownloader.this.threads.remove((Object)this);
                                if (!iterate) throw throwable;
                                ManagedDownloader.this.notifyAll();
                                throw throwable;
                            }
                        }
                        synchronized (managedDownloader) {
                            ManagedDownloader.this.currentRFDs.remove((Object)rfd);
                            ManagedDownloader.this.threads.remove((Object)this);
                            if (!iterate) return;
                            ManagedDownloader.this.notifyAll();
                            return;
                        }
                    }
                };
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    this.threads.add((Object)connectCreator);
                }
                connectCreator.start();
            }
            managedDownloader2 = this;
            synchronized (managedDownloader2) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException ee) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectAndDownload(RemoteFileDesc rfd) {
        HTTPDownloader dloader;
        block33: {
            boolean addQueued22;
            block32: {
                boolean addQueued22;
                block31: {
                    ManagedDownloader managedDownloader;
                    boolean bl;
                    block30: {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("connectAndDownload for: " + rfd));
                        }
                        dloader = null;
                        dloader = this.establishConnection(rfd);
                        if (dloader == null) {
                            return true;
                        }
                        if (this.validAlts != null) {
                            Object object = this.altLock;
                            synchronized (object) {
                                Iterator iter = this.validAlts.iterator();
                                for (int count = 0; iter.hasNext() && count < 10; ++count) {
                                    dloader.addSuccessfulAltLoc((AlternateLocation)iter.next());
                                }
                                iter = this.recentInvalidAlts.iterator();
                                while (iter.hasNext()) {
                                    dloader.addFailedAltLoc((AlternateLocation)iter.next());
                                }
                            }
                        }
                        boolean http11 = true;
                        try {
                            while (http11) {
                                ConnectionStatus status;
                                block29: {
                                    http11 = rfd.isHTTP11();
                                    while (true) {
                                        HashTree temp22;
                                        status = null;
                                        if (dloader.hasHashTree() && (this.hashTree == null || !this.hashTree.isDepthGoodEnough()) && (status = dloader.requestHashTree()).isThexResponse() && (temp22 = status.getHashTree()).isBetterTree(this.hashTree)) {
                                            this.hashTree = temp22;
                                            TigerTreeCache.instance();
                                            TigerTreeCache.addHashTree(rfd.getSHA1Urn(), this.hashTree);
                                        }
                                        dloader.consumeBodyIfNecessary();
                                        Object temp22 = this.stealLock;
                                        synchronized (temp22) {
                                            if (status == null || !status.isQueued()) {
                                                status = this.assignAndRequest(dloader, http11);
                                            }
                                            if (!status.isConnected()) {
                                                this.releaseRanges(dloader);
                                            }
                                            if (status.isPartialData()) continue;
                                        }
                                        if (status.isNoFile() || status.isNoData()) break block29;
                                        Assert.that(status.isQueued() || status.isConnected());
                                        boolean addQueued22 = this.killQueuedIfNecessary(status);
                                        if (status.isConnected()) break block29;
                                        Assert.that(status.isQueued());
                                        if (!addQueued22 || this.handleQueued(status, dloader)) break;
                                    }
                                    bl = true;
                                    Object var10_14 = null;
                                    managedDownloader = this;
                                    break block30;
                                }
                                ManagedDownloader addQueued22 = this;
                                synchronized (addQueued22) {
                                    this.queuedThreads.remove((Object)Thread.currentThread());
                                }
                                switch (status.getType()) {
                                    case 0: {
                                        dloader.stop();
                                        addQueued22 = true;
                                        break block31;
                                    }
                                    case 3: {
                                        dloader.stop();
                                        addQueued22 = false;
                                        break block32;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("illegal status: " + status.getType());
                                    }
                                }
                                Assert.that(status.isConnected());
                                boolean downloadOK = this.doDownload(dloader, http11);
                                this.releaseRanges(dloader);
                                if (downloadOK) continue;
                                break block33;
                            }
                            break block33;
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            ManagedDownloader managedDownloader2 = this;
                            synchronized (managedDownloader2) {
                                this.dloaders.remove((Object)dloader);
                                throw throwable;
                            }
                        }
                    }
                    synchronized (managedDownloader) {
                        this.dloaders.remove((Object)dloader);
                        return bl;
                    }
                }
                Object var10_15 = null;
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    this.dloaders.remove((Object)dloader);
                    return addQueued22;
                }
            }
            Object var10_16 = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove((Object)dloader);
                return addQueued22;
            }
        }
        Object var10_17 = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.dloaders.remove((Object)dloader);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleQueued(ConnectionStatus status, HTTPDownloader dloader) {
        try {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove((Object)dloader);
            }
            Thread.sleep(status.getQueuePollTime());
            return false;
        }
        catch (InterruptedException ix) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("worker: interrupted while asleep in queue" + dloader));
            }
            this.queuedThreads.remove((Object)Thread.currentThread());
            dloader.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killQueuedIfNecessary(ConnectionStatus status) {
        Thread killThread = null;
        Thread currentThread = Thread.currentThread();
        int queuePos = status.isQueued() ? status.getQueuePosition() : -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.getNumDownloaders() < this.getSwarmCapacity()) {
                if (status.isQueued()) {
                    this.queuedThreads.put((Object)currentThread, (Object)new Integer(queuePos));
                }
                return true;
            }
            if (this.queuedThreads.containsKey((Object)currentThread)) {
                if (status.isQueued()) {
                    this.queuedThreads.put((Object)currentThread, (Object)new Integer(queuePos));
                }
                return true;
            }
            Iterator iter = this.queuedThreads.keySet().iterator();
            int highest = queuePos;
            while (iter.hasNext()) {
                Object o = iter.next();
                int currQueue = (Integer)this.queuedThreads.get(o);
                if (currQueue <= highest) continue;
                killThread = (Thread)o;
                highest = currQueue;
            }
            if (killThread == null) {
                return false;
            }
            killThread.interrupt();
            if (status.isQueued()) {
                this.queuedThreads.put((Object)currentThread, (Object)new Integer(queuePos));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader establishConnection(RemoteFileDesc rfd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("establishConnection(" + rfd + ")"));
        }
        if (rfd == null) {
            return null;
        }
        if (this.stopped) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add((Object)rfd);
            }
            return null;
        }
        File incFile = this.incompleteFile;
        boolean needsPush = ManagedDownloader.needsPush(rfd);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = rfd.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.getState() != 11 && this.getState() != 12 && this.queuedThreads.size() == 0) {
                this.setState(1, needsPush ? 16000L : 10000L);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: attempting connect to " + rfd.getHost() + ":" + rfd.getPort()));
        }
        if (RECORD_STATS) {
            DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        }
        if (rfd.isReplyToMulticast()) {
            HTTPDownloader ret;
            try {
                ret = this.connectWithPush(rfd, incFile);
            }
            catch (IOException e) {
                try {
                    ret = this.connectDirectly(rfd, incFile);
                }
                catch (IOException e2) {
                    return null;
                }
            }
            return ret;
        }
        if (!needsPush) {
            try {
                HTTPDownloader ret = this.connectDirectly(rfd, incFile);
                return ret;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.informMesh(rfd, false);
        try {
            HTTPDownloader ret = this.connectWithPush(rfd, incFile);
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }

    private HTTPDownloader connectDirectly(RemoteFileDesc rfd, File incFile) throws IOException {
        LOG.trace((Object)"WORKER: attempt direct connection");
        HTTPDownloader ret = new HTTPDownloader(rfd, incFile);
        try {
            ret.connectTCP(10000);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPDownloader connectWithPush(RemoteFileDesc rfd, File incFile) throws IOException {
        boolean pushSent;
        LOG.trace((Object)"WORKER: attempt push connection");
        Object threadLock = new Object();
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(rfd.getFileName(), rfd.getIndex(), rfd.getClientGUID());
        this.miniRFDToLock.put((Object)mrfd, threadLock);
        Object object = threadLock;
        synchronized (object) {
            pushSent = this.manager.sendPush(rfd);
            if (pushSent) {
                try {
                    threadLock.wait(16000L);
                }
                catch (InterruptedException e) {
                    if (RECORD_STATS) {
                        DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                    }
                    throw new IOException("push interupted.");
                }
            }
        }
        Socket pushSocket = (Socket)this.threadLockToSocket.remove(threadLock);
        if (pushSocket == null) {
            if (RECORD_STATS) {
                if (!pushSent) {
                    DownloadStat.PUSH_FAILURE_NO_ROUTE.incrementStat();
                } else {
                    DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
                }
            }
            throw new IOException("push socket is null");
        }
        this.miniRFDToLock.remove((Object)mrfd);
        HTTPDownloader ret = new HTTPDownloader(pushSocket, rfd, incFile);
        try {
            ret.connectTCP(0);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private ConnectionStatus assignAndRequest(HTTPDownloader dloader, boolean http11) {
        RemoteFileDesc rfd = dloader.getRemoteFileDesc();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("assignAndRequest for: " + rfd));
        }
        try {
            block104: {
                try {
                    if (this.commonOutFile.hasFreeBlocksToAssign()) {
                        this.assignWhite(dloader, http11);
                        break block104;
                    }
                    this.assignGrey(dloader, http11);
                }
                catch (NoSuchElementException nsex) {
                    if (RECORD_STATS) {
                        DownloadStat.NSE_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("nsex thrown in assingAndRequest " + dloader), (Throwable)nsex);
                    }
                    Object object = this;
                    // MONITORENTER : object
                    this.files.add((Object)rfd);
                    // MONITOREXIT : object
                    object = ConnectionStatus.getNoData();
                    Object var12_5 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return object;
                    AlternateLocationCollection alternateLocationCollection3 = c2;
                    // MONITORENTER : alternateLocationCollection3
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection3
                            return object;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (NoSuchRangeException nsrx) {
                    if (RECORD_STATS) {
                        DownloadStat.NSR_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("nsrx thrown in assignAndRequest " + dloader), (Throwable)nsrx);
                    }
                    Object object = this;
                    // MONITORENTER : object
                    rfd.setAvailableRanges(null);
                    if (!rfd.isBusy()) {
                        rfd.setRetryAfter(300);
                    }
                    this.files.add((Object)rfd);
                    // MONITOREXIT : object
                    rfd.resetFailedCount();
                    object = ConnectionStatus.getNoFile();
                    Object var12_6 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return object;
                    AlternateLocationCollection alternateLocationCollection4 = c2;
                    // MONITORENTER : alternateLocationCollection4
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection4
                            return object;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (TryAgainLaterException talx) {
                    if (RECORD_STATS) {
                        DownloadStat.TAL_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("talx thrown in assignAndRequest " + dloader), (Throwable)talx);
                    }
                    if (!rfd.isBusy()) {
                        rfd.setRetryAfter(60);
                    }
                    Object object = this;
                    // MONITORENTER : object
                    if (this.dloaders.size() > 0 && rfd.getWaitTime() < 600) {
                        rfd.setRetryAfter(600);
                    }
                    this.files.add((Object)rfd);
                    // MONITOREXIT : object
                    rfd.resetFailedCount();
                    object = ConnectionStatus.getNoFile();
                    Object var12_7 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return object;
                    AlternateLocationCollection alternateLocationCollection5 = c2;
                    // MONITORENTER : alternateLocationCollection5
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection5
                            return object;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (RangeNotAvailableException rnae) {
                    if (RECORD_STATS) {
                        DownloadStat.RNA_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("rnae thrown in assignAndRequest " + dloader), (Throwable)rnae);
                    }
                    rfd.resetFailedCount();
                    this.informMesh(rfd, true);
                    ConnectionStatus connectionStatus = ConnectionStatus.getPartialData();
                    Object var12_8 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection6 = c2;
                    // MONITORENTER : alternateLocationCollection6
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection6
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (FileNotFoundException fnfx) {
                    if (RECORD_STATS) {
                        DownloadStat.FNF_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("fnfx thrown in assignAndRequest" + dloader), (Throwable)fnfx);
                    }
                    this.informMesh(rfd, false);
                    ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                    Object var12_9 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection7 = c2;
                    // MONITORENTER : alternateLocationCollection7
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection7
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (NotSharingException nsx) {
                    if (RECORD_STATS) {
                        DownloadStat.NS_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("nsx thrown in assignAndRequest " + dloader), (Throwable)nsx);
                    }
                    this.informMesh(rfd, false);
                    ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                    Object var12_10 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection8 = c2;
                    // MONITORENTER : alternateLocationCollection8
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection8
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (QueuedException qx) {
                    if (RECORD_STATS) {
                        DownloadStat.Q_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("qx thrown in assignAndRequest " + dloader), (Throwable)qx);
                    }
                    Object object = this;
                    // MONITORENTER : object
                    if (this.dloaders.size() == 0) {
                        this.setState(10);
                    }
                    int oldPos = this.queuePosition.equals(UNKNOWN_FILENAME) ? Integer.MAX_VALUE : Integer.parseInt(this.queuePosition);
                    int newPos = qx.getQueuePosition();
                    if (newPos < oldPos) {
                        this.queuePosition = UNKNOWN_FILENAME + newPos;
                        this.queuedVendor = dloader.getVendor();
                    }
                    // MONITOREXIT : object
                    rfd.resetFailedCount();
                    object = ConnectionStatus.getQueued(qx.getQueuePosition(), qx.getMinPollTime());
                    Object var12_11 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return object;
                    AlternateLocationCollection alternateLocationCollection9 = c2;
                    // MONITORENTER : alternateLocationCollection9
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection9
                            return object;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (ProblemReadingHeaderException prhe) {
                    if (RECORD_STATS) {
                        DownloadStat.PRH_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("prhe thrown in assignAndRequest " + dloader), (Throwable)prhe);
                    }
                    this.informMesh(rfd, false);
                    ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                    Object var12_12 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection10 = c2;
                    // MONITORENTER : alternateLocationCollection10
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection10
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (UnknownCodeException uce) {
                    if (RECORD_STATS) {
                        DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("uce (" + uce.getCode() + ") thrown in assignAndRequest " + dloader), (Throwable)uce);
                    }
                    this.informMesh(rfd, false);
                    ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                    Object var12_13 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection11 = c2;
                    // MONITORENTER : alternateLocationCollection11
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection11
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (ContentUrnMismatchException cume) {
                    if (RECORD_STATS) {
                        DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("cume thrown in assignAndRequest " + dloader), (Throwable)cume);
                    }
                    ConnectionStatus connectionStatus = ConnectionStatus.getNoFile();
                    Object var12_14 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return connectionStatus;
                    AlternateLocationCollection alternateLocationCollection12 = c2;
                    // MONITORENTER : alternateLocationCollection12
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection12
                            return connectionStatus;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                catch (IOException iox) {
                    Object object;
                    if (RECORD_STATS) {
                        DownloadStat.IO_EXCEPTION.incrementStat();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("iox thrown in assignAndRequest " + dloader), (Throwable)iox);
                    }
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        rfd.setRetryAfter(60);
                        object = this;
                        // MONITORENTER : object
                        this.files.add((Object)rfd);
                        // MONITOREXIT : object
                    } else {
                        this.informMesh(rfd, false);
                    }
                    object = ConnectionStatus.getNoFile();
                    Object var12_15 = null;
                    AlternateLocationCollection c2 = dloader.getAltLocsReceived();
                    if (c2 == null) return object;
                    AlternateLocationCollection alternateLocationCollection13 = c2;
                    // MONITORENTER : alternateLocationCollection13
                    Iterator iter = c2.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            // MONITOREXIT : alternateLocationCollection13
                            return object;
                        }
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
            }
            Object var12_4 = null;
            AlternateLocationCollection c2 = dloader.getAltLocsReceived();
            if (c2 != null) {
                AlternateLocationCollection alternateLocationCollection = c2;
                // MONITORENTER : alternateLocationCollection
                Iterator iter = c2.iterator();
                while (iter.hasNext()) {
                    AlternateLocation al = (AlternateLocation)iter.next();
                    RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                    this.addDownload(rfd1, false);
                }
                // MONITOREXIT : alternateLocationCollection
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            AlternateLocationCollection c2 = dloader.getAltLocsReceived();
            if (c2 == null) throw throwable;
            AlternateLocationCollection alternateLocationCollection2 = c2;
            // MONITORENTER : alternateLocationCollection2
            Iterator iter = c2.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    // MONITOREXIT : alternateLocationCollection2
                    throw throwable;
                }
                AlternateLocation al = (AlternateLocation)iter.next();
                RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                this.addDownload(rfd1, false);
            }
        }
        if (RECORD_STATS && rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        rfd.resetFailedCount();
        ManagedDownloader managedDownloader = this;
        // MONITORENTER : managedDownloader
        this.setState(2);
        // MONITOREXIT : managedDownloader
        if (this.stopped) {
            LOG.trace((Object)"Stopped in assignAndRequest");
            managedDownloader = this;
            // MONITORENTER : managedDownloader
            this.files.add((Object)rfd);
            // MONITOREXIT : managedDownloader
            return ConnectionStatus.getNoData();
        }
        managedDownloader = this;
        // MONITORENTER : managedDownloader
        if (!this.dloaders.contains((Object)dloader)) {
            this.dloaders.add((Object)dloader);
        }
        this.chatList.addHost(dloader);
        this.browseList.addHost(dloader);
        // MONITOREXIT : managedDownloader
        if (!RECORD_STATS) return ConnectionStatus.getConnected();
        DownloadStat.RESPONSE_OK.incrementStat();
        return ConnectionStatus.getConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        if (this.validAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.validAlts.getAltLocsSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfInvalidAlternateLocations() {
        if (this.invalidAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            return this.invalidAlts.size();
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.files == null ? 0 : this.files.size();
    }

    public synchronized int getBusyHostCount() {
        if (this.files == null) {
            return 0;
        }
        int busy = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            if (!((RemoteFileDesc)this.files.get(i)).isBusy()) continue;
            ++busy;
        }
        return busy;
    }

    public synchronized int getQueuedHostCount() {
        return this.queuedThreads.size();
    }

    private void assignWhite(HTTPDownloader dloader, boolean http11) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, NoSuchRangeException, NoSuchElementException {
        Interval interval = null;
        if (!dloader.getRemoteFileDesc().isPartialSource()) {
            interval = http11 ? this.commonOutFile.leaseWhite(100000) : this.commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet availableRanges = dloader.getRemoteFileDesc().getAvailableRanges();
                interval = http11 ? this.commonOutFile.leaseWhite(availableRanges, 100000) : this.commonOutFile.leaseWhite(availableRanges);
            }
            catch (NoSuchElementException nsee) {
                throw new NoSuchRangeException();
            }
        }
        int low = interval.low;
        int high = interval.high;
        dloader.connectHTTP(this.getOverlapOffset(low), high + 1, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() - 1 + newLow;
        if (newLow > low) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: Host gave subrange, different low.  Was: " + low + ", is now: " + newLow));
            }
            this.commonOutFile.releaseBlock(new Interval(low, newLow - 1));
        }
        if (newHigh < high) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: Host gave subrange, different high.  Was: " + high + ", is now: " + newHigh));
            }
            this.commonOutFile.releaseBlock(new Interval(newHigh + 1, high));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: assigning white " + newLow + "-" + newHigh + " to " + dloader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader dloader, boolean http11) throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        if (dloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        HTTPDownloader biggest = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iter = this.dloaders.iterator();
            while (iter.hasNext()) {
                HTTPDownloader h = (HTTPDownloader)iter.next();
                if (!h.isActive()) continue;
                if (biggest == null) {
                    biggest = h;
                    continue;
                }
                int hLeft = h.getAmountToRead() - h.getAmountRead();
                int bLeft = biggest.getAmountToRead() - biggest.getAmountRead();
                if (hLeft <= 0 || hLeft <= bLeft) continue;
                biggest = h;
            }
        }
        if (biggest == null) {
            throw new NoSuchElementException();
        }
        int amountRead = biggest.getAmountRead();
        int left = biggest.getAmountToRead() - amountRead;
        if (http11 && left < 100000 || !http11 && left < 100000) {
            float bandwidthVictim = -1.0f;
            float bandwidthStealer = -1.0f;
            try {
                bandwidthVictim = biggest.getAverageBandwidth();
                biggest.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug((Object)"victim does not have datapoints", (Throwable)ide);
                bandwidthVictim = -1.0f;
            }
            try {
                bandwidthStealer = dloader.getAverageBandwidth();
                dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug((Object)"stealer does not have datapoints", (Throwable)ide);
                bandwidthStealer = -1.0f;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: " + dloader + " attempting to steal from " + biggest + ", stealer speed [" + bandwidthStealer + "], victim speed [ " + bandwidthVictim + "]"));
            }
            if (!(bandwidthVictim != -1.0f && bandwidthVictim < MIN_ACCEPTABLE_SPEED) && (!(bandwidthStealer > MIN_ACCEPTABLE_SPEED) || !(bandwidthStealer > bandwidthVictim))) throw new NoSuchElementException();
            int start = biggest.getInitialReadingPoint() + amountRead;
            int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
            if (stop <= start) {
                throw new NoSuchElementException();
            }
            dloader.connectHTTP(this.getOverlapOffset(start), stop, false);
            int newLow = dloader.getInitialReadingPoint();
            int newHigh = dloader.getAmountToRead() + newLow;
            if (newLow > start || newHigh < stop) {
                if (!LOG.isDebugEnabled()) throw new IOException("bad stealer.");
                LOG.debug((Object)("WORKER: not stealing because stealer gave a subrange.  Expected low: " + start + ", high: " + stop + ".  Was low: " + newLow + ", high: " + newHigh));
                throw new IOException("bad stealer.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: picking stolen grey " + start + "-" + stop + " from " + biggest + " to " + dloader));
            }
            biggest.stopAt(start);
            biggest.stop();
            return;
        }
        int start = http11 ? biggest.getInitialReadingPoint() + biggest.getAmountToRead() - 100000 + 1 : biggest.getInitialReadingPoint() + amountRead + left / 2;
        int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
        if (stop <= start) {
            throw new NoSuchElementException();
        }
        dloader.connectHTTP(this.getOverlapOffset(start), stop, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() + newLow;
        if (newHigh < stop) {
            if (!LOG.isDebugEnabled()) throw new IOException("bad stealer");
            LOG.debug((Object)("WORKER: not stealing because stealer gave a lower high.  Expected high: " + stop + ".  Was high: " + newHigh));
            throw new IOException("bad stealer");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: assigning split grey " + newLow + "-" + newHigh + " from " + biggest + " to " + dloader));
        }
        if (newLow > start) {
            start = newLow;
        }
        biggest.stopAt(start);
    }

    private int getOverlapOffset(int i) {
        return Math.max(0, i - 10);
    }

    private Interval addOverlap(Interval in) {
        if (in.low + 10 < in.high) {
            return new Interval(in.low + 10, in.high);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownload(HTTPDownloader downloader, boolean http11) {
        boolean problem;
        block33: {
            int stop2222;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: about to start downloading " + downloader));
            }
            problem = false;
            RemoteFileDesc rfd = downloader.getRemoteFileDesc();
            try {
                block31: {
                    try {
                        downloader.doDownload(this.commonOutFile);
                        rfd.resetFailedCount();
                        if (!RECORD_STATS) break block31;
                        if (http11) {
                            DownloadStat.SUCCESFULL_HTTP11.incrementStat();
                        } else {
                            DownloadStat.SUCCESFULL_HTTP10.incrementStat();
                        }
                    }
                    catch (IOException e) {
                        if (RECORD_STATS) {
                            if (http11) {
                                DownloadStat.FAILED_HTTP11.incrementStat();
                            } else {
                                DownloadStat.FAILED_HTTP10.incrementStat();
                            }
                        }
                        problem = true;
                        this.chatList.removeHost(downloader);
                        this.browseList.removeHost(downloader);
                        Object var7_6 = null;
                        int stop2222 = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("    WORKER: terminating from " + downloader + " at " + stop2222 + " error? " + problem));
                        }
                        ManagedDownloader managedDownloader2 = this;
                        synchronized (managedDownloader2) {
                            if (problem) {
                                downloader.stop();
                                rfd.incrementFailedCount();
                                if (rfd.getFailedCount() < 2) {
                                    rfd.setRetryAfter(60);
                                    this.files.add((Object)rfd);
                                } else {
                                    this.informMesh(rfd, false);
                                }
                            } else {
                                this.informMesh(rfd, true);
                                if (!http11) {
                                    this.files.add((Object)rfd);
                                }
                            }
                            break block33;
                        }
                    }
                }
                Object var7_5 = null;
                stop2222 = downloader.getInitialReadingPoint() + downloader.getAmountRead();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                int stop2222 = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("    WORKER: terminating from " + downloader + " at " + stop2222 + " error? " + problem));
                }
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    if (problem) {
                        downloader.stop();
                        rfd.incrementFailedCount();
                        if (rfd.getFailedCount() < 2) {
                            rfd.setRetryAfter(60);
                            this.files.add((Object)rfd);
                        } else {
                            this.informMesh(rfd, false);
                        }
                    } else {
                        this.informMesh(rfd, true);
                        if (http11) throw throwable;
                        this.files.add((Object)rfd);
                    }
                    throw throwable;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("    WORKER: terminating from " + downloader + " at " + stop2222 + " error? " + problem));
            }
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (problem) {
                    downloader.stop();
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        rfd.setRetryAfter(60);
                        this.files.add((Object)rfd);
                    } else {
                        this.informMesh(rfd, false);
                    }
                } else {
                    this.informMesh(rfd, true);
                    if (!http11) {
                        this.files.add((Object)rfd);
                    }
                }
            }
        }
        if (problem) return false;
        return true;
    }

    private synchronized void releaseRanges(HTTPDownloader dloader) {
        int low = dloader.getInitialReadingPoint();
        int high = dloader.getInitialReadingPoint() + dloader.getAmountToRead() - 1;
        if (high - low > 0) {
            this.commonOutFile.releaseBlock(new Interval(low, high));
        }
    }

    private synchronized int getNumAllowedDownloads() {
        int downloads = this.threads.size();
        return this.getSwarmCapacity() - downloads;
    }

    private int getSwarmCapacity() {
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return 2;
        }
        if (capacity <= 1000) {
            return 6;
        }
        return 8;
    }

    private synchronized RemoteFileDesc removeBest(List filesLeft) {
        Iterator iter = filesLeft.iterator();
        RemoteFileDesc ret = (RemoteFileDesc)iter.next();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (ret.isBusy()) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        filesLeft.remove((Object)ret);
        return ret;
    }

    private static boolean needsPush(RemoteFileDesc rfd) {
        if (rfd.isReplyToMulticast()) {
            return true;
        }
        if (rfd.isPrivate()) {
            return !(rfd instanceof URLRemoteFileDesc);
        }
        return !NetworkUtils.isValidPort(rfd.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            RouterService.getFileManager().removeFileIfShared(this.incompleteFile);
            if (this.corruptState == 0 && this.hashTree == null) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCorruptDownload(boolean delete) {
        if (this.hashTree != null) {
            this.corruptState = 3;
        } else if (delete) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized List getXMLDocuments() {
        ArrayList allDocs = new ArrayList();
        for (int i = 0; i < this.allFiles.length; ++i) {
            LimeXMLDocument doc;
            if (this.allFiles[i] == null || (doc = this.allFiles[i].getXMLDoc()) == null) continue;
            allDocs.add((Object)doc);
        }
        return allDocs;
    }

    private void cleanup() {
        this.miniRFDToLock.clear();
        this.threadLockToSocket.clear();
        this.files = null;
        this.validAlts = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState, long time) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = System.currentTimeMillis() + time;
        }
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
            case 8: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        String ret = null;
        if (this.allFiles.length > 0) {
            ret = this.allFiles[0].getFileName();
        } else {
            Assert.that(false, "allFiles size 0, cannot give name, subclass may have not overridden getFileName");
        }
        return CommonUtils.convertFileName(ret);
    }

    protected synchronized boolean hasRFD() {
        return this.allFiles != null && this.allFiles.length > 0;
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            if (this.allFiles.length > 0) {
                return this.allFiles[0].getSize();
            }
            return -1;
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized String getQueuePosition() {
        if (this.getState() != 10) {
            return UNKNOWN_FILENAME;
        }
        return this.queuePosition;
    }

    public synchronized int getNumDownloaders() {
        return this.dloaders.size() + this.queuedThreads.size();
    }

    private final Iterator getHosts(boolean chattableOnly) {
        LinkedList buf = new LinkedList();
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader dloader = (HTTPDownloader)iter.next();
            if (chattableOnly && !dloader.chatEnabled()) continue;
            buf.add((Object)new Endpoint(dloader.getInetAddress().getHostAddress(), dloader.getPort()));
        }
        return buf.iterator();
    }

    public synchronized String getVendor() {
        if (this.dloaders.size() > 0) {
            HTTPDownloader dl = (HTTPDownloader)this.dloaders.get(0);
            return dl.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float retVal = 0.0f;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] b = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String s = this.callback.getHostValue(new String(b));
        if (s == null) {
            return false;
        }
        return (s = s.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RequeryLock {
        private volatile boolean shouldWait = true;
        private volatile boolean newResults = false;

        private RequeryLock() {
        }

        public synchronized void releaseDueToNewResults() {
            this.shouldWait = false;
            this.newResults = true;
            this.notifyAll();
        }

        public synchronized void releaseDueToRequery() {
            this.notifyAll();
        }

        private synchronized boolean getAndClearNewResult() {
            boolean retVal = this.newResults;
            this.newResults = false;
            return retVal;
        }

        public synchronized boolean lock(long waitTime) throws InterruptedException {
            try {
                if (this.shouldWait) {
                    this.wait(waitTime);
                }
            }
            catch (InterruptedException ie) {
                this.shouldWait = true;
                throw ie;
            }
            this.shouldWait = true;
            return this.getAndClearNewResult();
        }
    }
}

