/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.Serializable;

public class RequeryDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = 8241301635419840924L;
    protected AutoDownloadDetails _add;
    private boolean _hasFile = false;
    static int MAX_WAIT_TIME = 300000;

    public RequeryDownloader(IncompleteFileManager incompleteFileManager, AutoDownloadDetails add, GUID queryGUID) {
        super(new RemoteFileDesc[0], incompleteFileManager, queryGUID);
        Assert.that(add != null, "Instantiated with a null AutoDownloadDetail!");
        this._add = add;
    }

    private String getQuery() {
        return this._add.getQuery();
    }

    private String getRichQuery() {
        return this._add.getRichQuery();
    }

    private final MediaType getMediaType() {
        return this._add.getMediaType();
    }

    public boolean conflicts(AutoDownloadDetails add) {
        return this.getQuery().equals(add.getQuery()) && this.getMediaType().toString().equals(add.getMediaType().toString());
    }

    protected long[] getFailedState(boolean deserialized, long timeSpentWaiting) {
        if (!deserialized && timeSpentWaiting < (long)MAX_WAIT_TIME) {
            long[] retLongs = new long[]{8L, (long)MAX_WAIT_TIME - timeSpentWaiting};
            return retLongs;
        }
        return super.getFailedState(deserialized, timeSpentWaiting);
    }

    protected int getQueryCount(boolean deserializedFromDisk) {
        if (deserializedFromDisk) {
            return 0;
        }
        return 1;
    }

    protected QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this._hasFile) {
            return super.newRequery(numRequeries);
        }
        return QueryRequest.createQuery(this.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (this._hasFile) {
            return super.allowAddition(other);
        }
        AutoDownloadDetails autoDownloadDetails = this._add;
        synchronized (autoDownloadDetails) {
            if (this._add.addDownload(other)) {
                this._add.commitDownload(other);
                this._hasFile = true;
                return true;
            }
            return false;
        }
    }

    public synchronized String getFileName() {
        if (this._hasFile) {
            return super.getFileName();
        }
        return "\"" + this.getQuery() + "\"";
    }

    public synchronized int getContentLength() {
        if (this._hasFile) {
            return super.getContentLength();
        }
        return -1;
    }

    boolean hasFile() {
        return this._hasFile;
    }
}

