/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;

public final class MutableGUIDFilter
extends SpamFilter {
    private static final MutableGUIDFilter INSTANCE = new MutableGUIDFilter();
    private Set _guids = new TreeSet((Comparator)new GUID.GUIDByteComparator());
    private final KeywordFilter FILTER = new KeywordFilter();

    private MutableGUIDFilter() {
        this.FILTER.disallowAdult();
    }

    public static MutableGUIDFilter instance() {
        return INSTANCE;
    }

    public synchronized void addGUID(byte[] guid) {
        TreeSet guids = new TreeSet((Comparator)new GUID.GUIDByteComparator());
        guids.addAll((Collection)guids);
        guids.add((Object)guid);
        this._guids = guids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] guid) {
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet guids = new TreeSet((Comparator)new GUID.GUIDByteComparator());
                guids.addAll((Collection)this._guids);
                guids.remove((Object)guid);
                this._guids = guids;
            }
        }
    }

    public boolean allow(QueryReply qr) {
        if (this._guids.contains((Object)qr.getGUID())) {
            return this.FILTER.allow(qr);
        }
        return true;
    }

    public boolean allow(Message m) {
        if (m instanceof QueryReply) {
            return this.allow((QueryReply)m);
        }
        return true;
    }
}

