/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GUIDFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.filters.RequeryFilter;
import com.limegroup.gnutella.filters.SpamReplyFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.FilterSettings;
import com.sun.java.util.collections.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        Vector buf = new Vector();
        String[] badIPs = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        if (badIPs.length != 0) {
            IPFilter bf = IPFilter.instance();
            buf.add((Object)bf);
        }
        String[] badWords = FilterSettings.BANNED_WORDS.getValue();
        boolean filterAdult = FilterSettings.FILTER_ADULT.getValue();
        boolean filterVbs = FilterSettings.FILTER_VBS.getValue();
        boolean filterHtml = FilterSettings.FILTER_HTML.getValue();
        if (badWords.length != 0 || filterAdult || filterVbs || filterHtml) {
            KeywordFilter kf = new KeywordFilter();
            for (int i = 0; i < badWords.length; ++i) {
                kf.disallow(badWords[i]);
            }
            if (filterAdult) {
                kf.disallowAdult();
            }
            if (filterVbs) {
                kf.disallowVbs();
            }
            if (filterHtml) {
                kf.disallowHtml();
            }
            buf.add((Object)kf);
        }
        SpamReplyFilter spf = new SpamReplyFilter();
        buf.add((Object)spf);
        MutableGUIDFilter mgf = MutableGUIDFilter.instance();
        buf.add((Object)mgf);
        return SpamFilter.compose(buf);
    }

    public static SpamFilter newRouteFilter() {
        Vector buf = new Vector();
        buf.add((Object)new RequeryFilter());
        buf.add((Object)new GUIDFilter());
        if (FilterSettings.FILTER_DUPLICATES.getValue()) {
            buf.add((Object)new DuplicateFilter());
        }
        if (FilterSettings.FILTER_GREEDY_QUERIES.getValue()) {
            buf.add((Object)new GreedyQueryFilter());
        }
        return SpamFilter.compose(buf);
    }

    private static SpamFilter compose(Vector filters) {
        if (filters.size() == 0) {
            return new AllowFilter();
        }
        if (filters.size() == 1) {
            return (SpamFilter)filters.get(0);
        }
        Object[] delegates = new SpamFilter[filters.size()];
        filters.copyInto(delegates);
        return new CompositeFilter((SpamFilter[])delegates);
    }

    public abstract boolean allow(Message var1);
}

