/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.security.Cookies;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.settings.SecuritySettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.util.Properties;

public abstract class AuthenticationHandshakeResponder
implements HandshakeResponder {
    private final Cookies COOKIES = Cookies.instance();
    protected static final boolean RECORD_STATS = !CommonUtils.isJava118();
    protected final ConnectionManager _manager;
    private final String _host;
    private boolean _cookieUsed = false;
    private boolean _authenticated = false;
    private HandshakeResponse _beforeAuthenticationRequest = null;

    public AuthenticationHandshakeResponder(ConnectionManager manager, String host) {
        this._manager = manager;
        this._host = host;
    }

    public HandshakeResponse respond(HandshakeResponse response, boolean outgoing) throws IOException {
        if (this._beforeAuthenticationRequest == null) {
            this._beforeAuthenticationRequest = response;
        }
        if (outgoing) {
            return this.respondOutgoing(response);
        }
        return this.respondIncoming(response);
    }

    protected String getRemoteIP() {
        return this._host;
    }

    private HandshakeResponse respondIncoming(HandshakeResponse response) throws IOException {
        if (this._authenticated || !SecuritySettings.ACCEPT_AUTHENTICATED_CONNECTIONS_ONLY.getValue()) {
            return this.respondUnauthenticated(response, false);
        }
        return this.respondIncomingAuthenticate(response);
    }

    private HandshakeResponse respondIncomingAuthenticate(HandshakeResponse response) throws IOException {
        Set domains = this.getDomainsAuthenticated(response.props());
        if (domains == null) {
            return new HandshakeResponse(401, "Unauthorized", null);
        }
        this._authenticated = true;
        HandshakeResponse ourResponse = this.respondUnauthenticated(this._beforeAuthenticationRequest, false);
        ourResponse.props().put("X-Domains-Authenticated", StringUtils.getEntriesAsString((Collection)domains));
        return ourResponse;
    }

    private Set getDomainsAuthenticated(Properties headersReceived) {
        return this._manager.getAuthenticator().authenticate(headersReceived.getProperty("X-Username"), headersReceived.getProperty("X-Password"), null);
    }

    private HandshakeResponse respondOutgoing(HandshakeResponse response) throws IOException {
        if (response.getStatusCode() != 401) {
            return this.respondUnauthenticated(response, true);
        }
        return this.respondOutgoingWithAuthentication();
    }

    private HandshakeResponse respondOutgoingWithAuthentication() throws IOException {
        int code = 200;
        String message = "OK";
        Properties ret = new Properties();
        User user = this.getUserInfo();
        if (user == null || user.getUsername().trim().equals("")) {
            code = 503;
            message = "Unable To Authenticate";
        } else {
            code = 200;
            message = "AUTHENTICATING";
            ret.put("X-Username", user.getUsername());
            ret.put("X-Password", user.getPassword());
            this.COOKIES.putCookie(this._host, user);
        }
        return new HandshakeResponse(code, message, ret);
    }

    private User getUserInfo() {
        User user = null;
        if (!this._cookieUsed) {
            this._cookieUsed = true;
            if (this._host != null) {
                user = this.COOKIES.getUserInfo(this._host);
            }
        }
        if (user == null) {
            // empty if block
        }
        return user;
    }

    public void setLocalePreferencing(boolean b) {
    }

    protected abstract HandshakeResponse respondUnauthenticated(HandshakeResponse var1, boolean var2) throws IOException;
}

