/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends AuthenticationHandshakeResponder {
    public UltrapeerHandshakeResponder(String host) {
        super(RouterService.getConnectionManager(), host);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse response, boolean outgoing) throws IOException {
        if (outgoing) {
            return this.respondToOutgoing(response);
        }
        return this.respondToIncoming(response);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (!this._manager.allowConnection(response)) {
            return HandshakeResponse.createRejectOutgoingResponse();
        }
        Properties ret = new Properties();
        if (response.hasLeafGuidance() && this._manager.allowLeafDemotion() && response.isGoodUltrapeer()) {
            ret.put("X-Ultrapeer", "False");
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse response) {
        if (response.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ret = new UltrapeerHeaders(this.getRemoteIP());
        ret.put("Listen-IP", NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort());
        if (this.reject(response, ret)) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(response);
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(response, ret);
    }

    private boolean reject(HandshakeResponse response, Properties ret) {
        boolean allowedAsLeaf = this._manager.allowConnectionAsLeaf(response);
        if (response.isLeaf()) {
            return !allowedAsLeaf;
        }
        boolean supernodeNeeded = this._manager.supernodeNeeded();
        if (allowedAsLeaf && !supernodeNeeded) {
            ret.put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return false;
        }
        boolean allowedAsUltrapeer = this._manager.allowConnection(response);
        if (allowedAsUltrapeer) {
            ret.put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return false;
        }
        return true;
    }
}

