/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName name, String value, OutputStream os) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (os == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        os.write(header.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    public static void writeHeader(HTTPHeaderName name, String value, Writer out) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (out == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value);
        out.write(header);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, OutputStream os) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (os == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value.httpStringValue());
        os.write(header.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    public static void writeHeader(HTTPHeaderName name, HTTPHeaderValue value, Writer out) throws IOException {
        if (name == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (value == null) {
            throw new NullPointerException("null value in writing http header: " + name);
        }
        if (out == null) {
            throw new NullPointerException("null os in writing http header: " + name);
        }
        String header = HTTPUtils.createHeader(name, value.httpStringValue());
        out.write(header);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(header.length());
        }
    }

    private static String createHeader(HTTPHeaderName name, String valueStr) throws IOException {
        if (name == null || valueStr == null) {
            throw new NullPointerException("null value in creating http header");
        }
        String nameStr = name.httpStringValue();
        if (nameStr == null) {
            throw new NullPointerException("null value in creating http header");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nameStr);
        sb.append(COLON_SPACE);
        sb.append(valueStr);
        sb.append(CRLF);
        return sb.toString();
    }

    public static String extractHeaderValue(String header) {
        int index = header.indexOf(COLON);
        if (index <= 0) {
            return null;
        }
        return header.substring(index + 1).trim();
    }

    public static void writeHeader(HTTPHeaderName name, int value, Writer writer) throws IOException {
        HTTPUtils.writeHeader(name, String.valueOf(value), writer);
    }

    public static void writeHeader(HTTPHeaderName name, int value, OutputStream stream) throws IOException {
        HTTPUtils.writeHeader(name, String.valueOf(value), stream);
    }

    public static void writeDate(Writer writer) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), writer);
    }

    public static void writeDate(OutputStream stream) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), stream);
    }

    public static void writeFeatures(Writer writer) throws IOException {
        Set features = HTTPUtils.getFeaturesValue();
        if (features.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)features), writer);
        }
    }

    public static void writeFeatures(OutputStream stream) throws IOException {
        Set features = HTTPUtils.getFeaturesValue();
        if (features.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)features), stream);
        }
    }

    private static Set getFeaturesValue() {
        HashSet features = new HashSet(2);
        features.add((Object)ConstantHTTPHeaderValue.BROWSE_FEATURE);
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            features.add((Object)ConstantHTTPHeaderValue.CHAT_FEATURE);
        }
        return features;
    }

    private static String getDateValue() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }
}

