/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.util.COBSUtil;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NameValue;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.OutputStream;

public class GGEP {
    public static final String GGEP_HEADER_BROWSE_HOST = "BH";
    public static final String GGEP_HEADER_DAILY_AVERAGE_UPTIME = "DU";
    public static final String GGEP_HEADER_UNICAST_SUPPORT = "GUE";
    public static final String GGEP_HEADER_VENDOR_INFO = "VC";
    public static final String GGEP_HEADER_UP_SUPPORT = "UP";
    public static final String GGEP_HEADER_QUERY_KEY_SUPPORT = "QK";
    public static final String GGEP_HEADER_MULTICAST_RESPONSE = "MCAST";
    public static final String GGEP_HEADER_PUSH_PROXY = "PUSH";
    public static final String GGEP_HEADER_ALTS = "ALT";
    public static final String GGEP_HEADER_IPPORT = "IP";
    public static final String GGEP_HEADER_UDP_HOST_CACHE = "UDPHC";
    public static final String GGEP_HEADER_SUPPORT_CACHE_PONGS = "SCP";
    public static final String GGEP_HEADER_PACKED_IPPORTS = "IPP";
    public static final String GGEP_HEADER_PACKED_HOSTCACHES = "PHC";
    public static final String GGEP_HEADER_FEATURE_QUERY = "WH";
    public static final String GGEP_HEADER_NO_PROXY = "NP";
    public static final String GGEP_HEADER_META = "M";
    public static final String GGEP_HEADER_CLIENT_LOCALE = "LOC";
    public static final String GGEP_HEADER_CREATE_TIME = "CT";
    public static final String GGEP_HEADER_FW_TRANS = "FW";
    public static final int MAX_KEY_SIZE_IN_BYTES = 15;
    public static final int MAX_VALUE_SIZE_IN_BYTES = 262143;
    public static final byte GGEP_PREFIX_MAGIC_NUMBER = -61;
    private final Map _props = new TreeMap(Comparators.stringComparator());
    public boolean notNeedCOBS = false;
    private volatile int hashCode = 0;

    public GGEP(boolean notNeedCOBS) {
        this.notNeedCOBS = notNeedCOBS;
    }

    public GGEP() {
        this(false);
    }

    public GGEP(byte[] data, int offset) throws BadGGEPBlockException {
        this(data, offset, null);
    }

    public GGEP(byte[] messageBytes, int beginOffset, int[] endOffset) throws BadGGEPBlockException {
        if (messageBytes.length < 4) {
            throw new BadGGEPBlockException();
        }
        if (messageBytes[beginOffset] != -61) {
            throw new BadGGEPBlockException();
        }
        boolean onLastExtension = false;
        int currIndex = beginOffset + 1;
        while (!onLastExtension) {
            try {
                this.sanityCheck(messageBytes[currIndex]);
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            onLastExtension = this.isLastExtension(messageBytes[currIndex]);
            boolean encoded = this.isEncoded(messageBytes[currIndex]);
            boolean compressed = this.isCompressed(messageBytes[currIndex]);
            int headerLen = this.deriveHeaderLength(messageBytes[currIndex]);
            ++currIndex;
            String extensionHeader = null;
            try {
                extensionHeader = new String(messageBytes, currIndex, headerLen);
            }
            catch (StringIndexOutOfBoundsException inputIsMalformed) {
                throw new BadGGEPBlockException();
            }
            int[] toIncrement = new int[1];
            int dataLength = this.deriveDataLength(messageBytes, currIndex += headerLen, toIncrement);
            byte[] extensionData = null;
            currIndex += toIncrement[0];
            if (dataLength > 0) {
                byte[] data = new byte[dataLength];
                try {
                    System.arraycopy(messageBytes, currIndex, data, 0, dataLength);
                }
                catch (ArrayIndexOutOfBoundsException malformedInput) {
                    throw new BadGGEPBlockException();
                }
                if (encoded) {
                    try {
                        data = COBSUtil.cobsDecode(data);
                    }
                    catch (IOException badCobsEncoding) {
                        throw new BadGGEPBlockException("Bad COBS Encoding");
                    }
                }
                if (compressed) {
                    try {
                        data = IOUtils.inflate(data);
                    }
                    catch (IOException badData) {
                        throw new BadGGEPBlockException("Bad compressed data");
                    }
                }
                extensionData = data;
                currIndex += dataLength;
            }
            if (compressed) {
                this._props.put((Object)extensionHeader, (Object)new NeedsCompression(extensionData));
                continue;
            }
            this._props.put((Object)extensionHeader, extensionData);
        }
        if (endOffset != null && endOffset.length > 0) {
            endOffset[0] = currIndex;
        }
    }

    public static GGEP[] read(byte[] b, int i) throws BadGGEPBlockException {
        return new GGEP[]{new GGEP(b, i)};
    }

    public static GGEP[] read(byte[] b, int i, int[] ia) throws BadGGEPBlockException {
        return new GGEP[]{new GGEP(b, i, ia)};
    }

    public void merge(GGEP other) {
        this._props.putAll(other._props);
    }

    private void sanityCheck(byte headerFlags) throws BadGGEPBlockException {
        if ((headerFlags & 0x10) != 0) {
            throw new BadGGEPBlockException();
        }
    }

    private boolean isLastExtension(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x80) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isEncoded(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x40) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isCompressed(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x20) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private int deriveHeaderLength(byte headerFlags) throws BadGGEPBlockException {
        int retInt = 0;
        retInt = headerFlags & 0xF;
        if (retInt == 0) {
            throw new BadGGEPBlockException();
        }
        return retInt;
    }

    private int deriveDataLength(byte[] buff, int beginOffset, int[] increment) throws BadGGEPBlockException {
        byte currByte;
        int length = 0;
        int iterations = 0;
        int MAX_ITERATIONS = 3;
        do {
            try {
                currByte = buff[beginOffset++];
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            length = length << 6 | currByte & 0x3F;
            if (++iterations <= 3) continue;
            throw new BadGGEPBlockException();
        } while (64 != (currByte & 0x40));
        increment[0] = iterations;
        return length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.getHeaders().size() > 0) {
            out.write(-61);
            Iterator headers = this.getHeaders().iterator();
            while (headers.hasNext()) {
                String currHeader = (String)headers.next();
                byte[] currData = this.get(currHeader);
                int dataLen = 0;
                boolean shouldEncode = this.shouldCOBSEncode(currData);
                boolean shouldCompress = this.shouldCompress(currHeader);
                if (currData != null) {
                    if (shouldCompress && (currData = IOUtils.deflate(currData)).length > 262143) {
                        throw new IllegalArgumentException("value for [" + currHeader + "] too large after compression");
                    }
                    if (shouldEncode) {
                        currData = COBSUtil.cobsEncode(currData);
                    }
                    dataLen = currData.length;
                }
                this.writeHeader(currHeader, dataLen, !headers.hasNext(), out, shouldEncode, shouldCompress);
                if (dataLen <= 0) continue;
                out.write(currData);
            }
        }
    }

    private final boolean shouldCOBSEncode(byte[] data) {
        return !this.notNeedCOBS && this.containsNull(data);
    }

    private final boolean shouldCompress(String header) {
        return this._props.get((Object)header) instanceof NeedsCompression;
    }

    private void writeHeader(String header, int dataLen, boolean isLast, OutputStream out, boolean isEncoded, boolean isCompressed) throws IOException {
        int middle;
        int toWrite;
        boolean shouldCompress = false;
        int flags = 0;
        if (isLast) {
            flags |= 0x80;
        }
        if (isEncoded) {
            flags |= 0x40;
        }
        if (isCompressed) {
            flags |= 0x20;
        }
        out.write(flags |= header.getBytes().length);
        out.write(header.getBytes());
        int begin = dataLen & 0x3F000;
        if (begin != 0) {
            toWrite = 0x80 | (begin >>= 12);
            out.write(toWrite);
        }
        if ((middle = dataLen & 0xFC0) != 0) {
            toWrite = 0x80 | (middle >>= 6);
            out.write(toWrite);
        }
        int end = dataLen & 0x3F;
        toWrite = 0x40 | end;
        out.write(toWrite);
    }

    public void putAll(List fields) throws IllegalArgumentException {
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            NameValue next = (NameValue)i.next();
            String key = next.getName();
            Object value = next.getValue();
            if (value == null) {
                this.put(key);
                continue;
            }
            if (value instanceof byte[]) {
                this.put(key, (byte[])value);
                continue;
            }
            if (value instanceof String) {
                this.put(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                this.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.put(key, (Long)value);
                continue;
            }
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }

    public void putCompressed(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        this._props.put((Object)key, (Object)new NeedsCompression(value));
    }

    public void put(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        this.validateValue(value);
        this._props.put((Object)key, (Object)value);
    }

    public void put(String key, String value) throws IllegalArgumentException {
        this.put(key, value == null ? null : value.getBytes());
    }

    public void put(String key, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(key, ByteOrder.int2minLeb(value));
    }

    public void put(String key, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(key, ByteOrder.long2minLeb(value));
    }

    public void put(String key) throws IllegalArgumentException {
        this.put(key, (byte[])null);
    }

    public byte[] getBytes(String key) throws BadGGEPPropertyException {
        byte[] ret = this.get(key);
        if (ret == null) {
            throw new BadGGEPPropertyException();
        }
        return ret;
    }

    public String getString(String key) throws BadGGEPPropertyException {
        return new String(this.getBytes(key));
    }

    public int getInt(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 4) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2int(bytes, 0, bytes.length);
    }

    public long getLong(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 8) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2long(bytes, 0, bytes.length);
    }

    public boolean hasKey(String key) {
        return this._props.containsKey((Object)key);
    }

    public Set getHeaders() {
        return this._props.keySet();
    }

    public byte[] get(String key) {
        Object value = this._props.get((Object)key);
        if (value instanceof NeedsCompression) {
            return ((NeedsCompression)value).data;
        }
        return (byte[])value;
    }

    private void validateKey(String key) throws IllegalArgumentException {
        byte[] bytes = key.getBytes();
        if (key == null || key.equals("") || bytes.length > 15 || this.containsNull(bytes)) {
            throw new IllegalArgumentException();
        }
    }

    private void validateValue(byte[] value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        if (value.length > 262143) {
            throw new IllegalArgumentException();
        }
    }

    private boolean containsNull(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GGEP)) {
            return false;
        }
        return this.subset((GGEP)o) && ((GGEP)o).subset(this);
    }

    private boolean subset(GGEP other) {
        Iterator iter = this._props.keySet().iterator();
        while (iter.hasNext()) {
            byte[] v2;
            String key = (String)iter.next();
            byte[] v1 = this.get(key);
            if (v1 == null != ((v2 = other.get(key)) == null)) {
                return false;
            }
            if (v1 == null || Arrays.equals((byte[])v1, (byte[])v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this._props.hashCode();
        }
        return this.hashCode;
    }

    private static class NeedsCompression {
        final byte[] data;

        NeedsCompression(byte[] data) {
            this.data = data;
        }
    }
}

