/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class PingReply
extends Message
implements Serializable,
IpPort {
    private final List PACKED_IP_PORTS;
    private final List PACKED_UDP_HOST_CACHES;
    private final String UDP_CACHE_ADDRESS;
    private final int FREE_ULTRAPEER_SLOTS;
    private final int FREE_LEAF_SLOTS;
    public static final int STANDARD_PAYLOAD_SIZE = 14;
    private final byte[] PAYLOAD;
    private final InetAddress IP;
    private final int PORT;
    private final InetAddress MY_IP;
    private final int MY_PORT;
    private final long FILES;
    private final long KILOBYTES;
    private final int DAILY_UPTIME;
    private final boolean SUPPORTS_UNICAST;
    private final String VENDOR;
    private final int VENDOR_MAJOR_VERSION;
    private final int VENDOR_MINOR_VERSION;
    private final QueryKey QUERY_KEY;
    private final boolean HAS_GGEP_EXTENSION;
    private static final byte[] CACHED_VENDOR = new byte[5];
    private String CLIENT_LOCALE;
    private int FREE_LOCALE_SLOTS;

    public static PingReply create(byte[] guid, byte ttl) {
        return PingReply.create(guid, ttl, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] guid, byte ttl, Collection hosts) {
        return PingReply.create(guid, ttl, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), (long)RouterService.getSharedFileSize() / 1024L, RouterService.isSupernode(), Statistics.instance().calculateDailyUptime(), UDPService.instance().isGUESSCapable(), ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue(), RouterService.getConnectionManager().getNumLimeWireLocalePrefSlots(), hosts);
    }

    public static PingReply create(byte[] guid, byte ttl, IpPort addr) {
        return PingReply.create(guid, ttl, addr, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] guid, byte ttl, IpPort returnAddr, Collection hosts) {
        GGEP ggep = PingReply.newGGEP(Statistics.instance().calculateDailyUptime(), RouterService.isSupernode(), UDPService.instance().isGUESSCapable());
        String locale = ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue();
        PingReply.addLocale(ggep, locale, RouterService.getConnectionManager().getNumLimeWireLocalePrefSlots());
        PingReply.addAddress(ggep, returnAddr);
        PingReply.addPackedHosts(ggep, hosts);
        return PingReply.create(guid, ttl, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), (long)RouterService.getSharedFileSize() / 1024L, RouterService.isSupernode(), ggep);
    }

    public static PingReply createQueryKeyReply(byte[] guid, byte ttl, QueryKey key) {
        return PingReply.create(guid, ttl, RouterService.getPort(), RouterService.getAddress(), RouterService.getNumSharedFiles(), RouterService.getSharedFileSize() / 1024, RouterService.isSupernode(), PingReply.qkGGEP(key));
    }

    public static PingReply createQueryKeyReply(byte[] guid, byte ttl, int port, byte[] ip, long sharedFiles, long sharedSize, boolean ultrapeer, QueryKey key) {
        return PingReply.create(guid, ttl, port, ip, sharedFiles, sharedSize, ultrapeer, PingReply.qkGGEP(key));
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] address) {
        return PingReply.create(guid, ttl, port, address, 0L, 0L, false, -1, false);
    }

    public static PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, boolean ultrapeer) {
        return PingReply.create(guid, ttl, port, address, 0L, 0L, ultrapeer, -1, false);
    }

    public static PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, int uptime, boolean ultrapeer) {
        return PingReply.create(guid, ttl, port, address, 0L, 0L, ultrapeer, uptime, false);
    }

    public static PingReply createGUESSReply(byte[] guid, byte ttl, Endpoint ep) throws UnknownHostException {
        return PingReply.create(guid, ttl, ep.getPort(), ep.getHostBytes(), 0L, 0L, true, -1, true);
    }

    public static PingReply createGUESSReply(byte[] guid, byte ttl, int port, byte[] address) {
        return PingReply.create(guid, ttl, port, address, 0L, 0L, true, -1, true);
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes) {
        return PingReply.create(guid, ttl, port, ip, files, kbytes, false, -1, false);
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGUESSCapable) {
        return PingReply.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, PingReply.newGGEP(dailyUptime, isUltrapeer, isGUESSCapable));
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGuessCapable, String locale, int slots) {
        return PingReply.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, dailyUptime, isGuessCapable, locale, slots, (Collection)Collections.EMPTY_LIST);
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGuessCapable, String locale, int slots, Collection hosts) {
        GGEP ggep = PingReply.newGGEP(dailyUptime, isUltrapeer, isGuessCapable);
        PingReply.addLocale(ggep, locale, slots);
        PingReply.addPackedHosts(ggep, hosts);
        return PingReply.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, ggep);
    }

    public PingReply mutateGUID(byte[] guid) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + guid.length);
        }
        try {
            return PingReply.createFromNetwork(guid, this.getTTL(), this.getHops(), this.PAYLOAD);
        }
        catch (BadPacketException ioe) {
            throw new IllegalArgumentException("Input pong was bad!");
        }
    }

    public static PingReply create(byte[] guid, byte ttl, int port, byte[] ipBytes, long files, long kbytes, boolean isUltrapeer, GGEP ggep) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (!NetworkUtils.isValidAddress(ipBytes)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(ipBytes));
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(NetworkUtils.ip2string(ipBytes));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        byte[] extensions = null;
        if (ggep != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ggep.write(baos);
            }
            catch (IOException e) {
                ErrorService.error(e);
            }
            extensions = baos.toByteArray();
        }
        int length = 14 + (extensions == null ? 0 : extensions.length);
        byte[] payload = new byte[length];
        ByteOrder.short2leb((short)port, payload, 0);
        payload[2] = ipBytes[0];
        payload[3] = ipBytes[1];
        payload[4] = ipBytes[2];
        payload[5] = ipBytes[3];
        ByteOrder.int2leb((int)files, payload, 6);
        ByteOrder.int2leb((int)(isUltrapeer ? PingReply.mark(kbytes) : kbytes), payload, 10);
        if (extensions != null) {
            System.arraycopy(extensions, 0, payload, 14, extensions.length);
        }
        return new PingReply(guid, ttl, 0, payload, ggep, ip);
    }

    public static PingReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (payload == null) {
            throw new NullPointerException("null payload");
        }
        if (payload.length < 14) {
            throw new BadPacketException("invalid payload length");
        }
        int port = ByteOrder.ubytes2int(ByteOrder.leb2short(payload, 0));
        if (!NetworkUtils.isValidPort(port)) {
            throw new BadPacketException("invalid port: " + port);
        }
        String ipString = NetworkUtils.ip2string(payload, 2);
        InetAddress ip = null;
        GGEP ggep = PingReply.parseGGEP(payload);
        if (ggep != null) {
            if (ggep.hasKey("VC")) {
                byte[] vendorBytes = null;
                try {
                    vendorBytes = ggep.getBytes("VC");
                }
                catch (BadGGEPPropertyException e) {
                    throw new BadPacketException("bad GGEP: " + vendorBytes);
                }
                if (vendorBytes.length < 4) {
                    throw new BadPacketException("invalid vendor length: " + vendorBytes.length);
                }
            }
            if (ggep.hasKey("LOC")) {
                try {
                    byte[] clocale = ggep.getBytes("LOC");
                }
                catch (BadGGEPPropertyException e) {
                    throw new BadPacketException("GGEP error : creating from network : client locale");
                }
            }
            if (ggep.hasKey("IPP")) {
                byte[] data = null;
                try {
                    data = ggep.getBytes("IPP");
                }
                catch (BadGGEPPropertyException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
                if (data == null || data.length % 6 != 0) {
                    throw new BadPacketException("invalid data");
                }
            }
            if (ggep.hasKey("PHC")) {
                try {
                    ggep.getBytes("PHC");
                }
                catch (BadGGEPPropertyException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
            }
            if (ggep.hasKey("UDPHC")) {
                try {
                    String dns = ggep.getString("UDPHC");
                    ip = InetAddress.getByName(dns);
                    ipString = ip.getHostAddress();
                }
                catch (BadGGEPPropertyException ignored) {
                }
                catch (UnknownHostException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
            }
        }
        if (!NetworkUtils.isValidAddress(ipString)) {
            throw new BadPacketException("invalid address: " + ipString);
        }
        if (ip == null) {
            try {
                ip = InetAddress.getByName(NetworkUtils.ip2string(payload, 2));
            }
            catch (UnknownHostException e) {
                throw new BadPacketException("bad IP:" + ipString + " " + e.getMessage());
            }
        }
        return new PingReply(guid, ttl, hops, payload, ggep, ip);
    }

    private PingReply(byte[] guid, byte ttl, byte hops, byte[] payload, GGEP ggep, InetAddress ip) {
        super(guid, (byte)1, ttl, hops, payload.length);
        this.PAYLOAD = payload;
        this.PORT = ByteOrder.ubytes2int(ByteOrder.leb2short(this.PAYLOAD, 0));
        this.FILES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 6));
        this.KILOBYTES = ByteOrder.ubytes2long(ByteOrder.leb2int(this.PAYLOAD, 10));
        this.IP = ip;
        int dailyUptime = -1;
        boolean supportsUnicast = false;
        String vendor = "";
        int vendorMajor = -1;
        int vendorMinor = -1;
        int freeLeafSlots = -1;
        int freeUltrapeerSlots = -1;
        QueryKey key = null;
        String locale = ApplicationSettings.DEFAULT_LOCALE.getValue();
        int slots = -1;
        InetAddress myIP = null;
        int myPort = 0;
        List packedIPs = Collections.EMPTY_LIST;
        List packedCaches = Collections.EMPTY_LIST;
        String cacheAddress = null;
        if (ggep != null) {
            Object data;
            block39: {
                byte[] bytes;
                if (ggep.hasKey("DU")) {
                    try {
                        dailyUptime = ggep.getInt("DU");
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                supportsUnicast = ggep.hasKey("GUE");
                if (ggep.hasKey("VC")) {
                    try {
                        bytes = ggep.getBytes("VC");
                        if (bytes.length >= 4) {
                            vendor = new String(bytes, 0, 4);
                        }
                        if (bytes.length > 4) {
                            vendorMajor = bytes[4] >> 4;
                            vendorMinor = bytes[4] & 0xF;
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("QK")) {
                    try {
                        bytes = ggep.getBytes("QK");
                        if (QueryKey.isValidQueryKeyBytes(bytes)) {
                            key = QueryKey.getQueryKey(bytes, false);
                        }
                    }
                    catch (BadGGEPPropertyException corrupt) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("UP")) {
                    try {
                        bytes = ggep.getBytes("UP");
                        if (bytes.length >= 3) {
                            freeLeafSlots = bytes[1];
                            freeUltrapeerSlots = bytes[2];
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("LOC")) {
                    try {
                        bytes = ggep.getBytes("LOC");
                        if (bytes.length >= 2) {
                            locale = new String(bytes, 0, 2);
                        }
                        if (bytes.length >= 3) {
                            slots = ByteOrder.ubyte2int(bytes[2]);
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("IP")) {
                    try {
                        data = ggep.getBytes("IP");
                        byte[] myip = new byte[4];
                        if (((byte[])data).length >= 6) {
                            System.arraycopy(data, 0, myip, 0, 4);
                        }
                        if (!NetworkUtils.isValidAddress(myip)) break block39;
                        try {
                            myIP = NetworkUtils.getByAddress(myip);
                            myPort = ByteOrder.ubytes2int(ByteOrder.leb2short(data, 4));
                            if (NetworkUtils.isPrivateAddress(myIP) || !NetworkUtils.isValidPort(myPort)) {
                                myIP = null;
                                myPort = 0;
                            }
                        }
                        catch (UnknownHostException bad) {}
                    }
                    catch (BadGGEPPropertyException ignored) {
                        // empty catch block
                    }
                }
            }
            if (ggep.hasKey("UDPHC")) {
                cacheAddress = "";
                try {
                    cacheAddress = ggep.getString("UDPHC");
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("IPP")) {
                try {
                    data = ggep.getBytes("IPP");
                    packedIPs = NetworkUtils.unpackIps(data);
                }
                catch (BadGGEPPropertyException bad) {
                }
                catch (BadPacketException bpe) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("PHC")) {
                try {
                    data = ggep.getString("PHC");
                    packedCaches = this.listCaches((String)data);
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
        }
        this.MY_IP = myIP;
        this.MY_PORT = myPort;
        this.HAS_GGEP_EXTENSION = ggep != null;
        this.DAILY_UPTIME = dailyUptime;
        this.SUPPORTS_UNICAST = supportsUnicast;
        this.VENDOR = vendor;
        this.VENDOR_MAJOR_VERSION = vendorMajor;
        this.VENDOR_MINOR_VERSION = vendorMinor;
        this.QUERY_KEY = key;
        this.FREE_LEAF_SLOTS = freeLeafSlots;
        this.FREE_ULTRAPEER_SLOTS = freeUltrapeerSlots;
        this.CLIENT_LOCALE = locale;
        this.FREE_LOCALE_SLOTS = slots;
        this.UDP_CACHE_ADDRESS = cacheAddress != null && "".equals(cacheAddress) ? this.getAddress() : cacheAddress;
        this.PACKED_IP_PORTS = packedIPs;
        this.PACKED_UDP_HOST_CACHES = packedCaches;
    }

    private static GGEP newGGEP(int dailyUptime, boolean isUltrapeer, boolean isGUESSCapable) {
        GGEP ggep = new GGEP(true);
        if (dailyUptime >= 0) {
            ggep.put("DU", dailyUptime);
        }
        if (isGUESSCapable && isUltrapeer) {
            byte[] vNum = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getGUESSMajorVersionNumber(), CommonUtils.getGUESSMinorVersionNumber())};
            ggep.put("GUE", vNum);
        }
        if (isUltrapeer) {
            PingReply.addUltrapeerExtension(ggep);
        }
        ggep.put("VC", CACHED_VENDOR);
        return ggep;
    }

    private static GGEP qkGGEP(QueryKey queryKey) {
        try {
            GGEP ggep = new GGEP(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            queryKey.write(baos);
            ggep.put("QK", baos.toByteArray());
            return ggep;
        }
        catch (IOException e) {
            Assert.that(false, "Couldn't encode QueryKey" + queryKey);
            return null;
        }
    }

    private static GGEP addLocale(GGEP ggep, String locale, int slots) {
        byte[] payload = new byte[3];
        byte[] s = locale.getBytes();
        payload[0] = s[0];
        payload[1] = s[1];
        payload[2] = (byte)slots;
        ggep.put("LOC", payload);
        return ggep;
    }

    private static GGEP addAddress(GGEP ggep, IpPort address) {
        byte[] payload = new byte[6];
        System.arraycopy(address.getInetAddress().getAddress(), 0, payload, 0, 4);
        ByteOrder.short2leb((short)address.getPort(), payload, 4);
        ggep.put("IP", payload);
        return ggep;
    }

    private static GGEP addPackedHosts(GGEP ggep, Collection hosts) {
        if (hosts == null || hosts.isEmpty()) {
            return ggep;
        }
        ggep.put("IPP", NetworkUtils.packIpPorts(hosts));
        return ggep;
    }

    private static void addUltrapeerExtension(GGEP ggep) {
        byte[] payload = new byte[]{PingReply.convertToGUESSFormat(CommonUtils.getUPMajorVersionNumber(), CommonUtils.getUPMinorVersionNumber()), (byte)RouterService.getNumFreeLimeWireLeafSlots(), (byte)RouterService.getNumFreeLimeWireNonLeafSlots()};
        ggep.put("UP", payload);
    }

    private static byte convertToGUESSFormat(int major, int minor) throws IllegalArgumentException {
        if (major < 0 || minor < 0 || major > 15 || minor > 15) {
            throw new IllegalArgumentException();
        }
        int retInt = major;
        retInt <<= 4;
        return (byte)(retInt |= minor);
    }

    public boolean hasFreeSlots() {
        return this.hasFreeLeafSlots() || this.hasFreeUltrapeerSlots();
    }

    public boolean hasFreeLeafSlots() {
        return this.FREE_LEAF_SLOTS > 0;
    }

    public boolean hasFreeUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS > 0;
    }

    public int getNumLeafSlots() {
        return this.FREE_LEAF_SLOTS;
    }

    public int getNumUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.PAYLOAD);
        SentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
    }

    public int getPort() {
        return this.PORT;
    }

    public String getAddress() {
        return this.IP.getHostAddress();
    }

    public byte[] getIPBytes() {
        byte[] ip = new byte[]{this.PAYLOAD[2], this.PAYLOAD[3], this.PAYLOAD[4], this.PAYLOAD[5]};
        return ip;
    }

    public long getFiles() {
        return this.FILES;
    }

    public long getKbytes() {
        return this.KILOBYTES;
    }

    public int getDailyUptime() {
        return this.DAILY_UPTIME;
    }

    public boolean supportsUnicast() {
        return this.SUPPORTS_UNICAST;
    }

    public String getVendor() {
        return this.VENDOR;
    }

    public int getVendorMajorVersion() {
        return this.VENDOR_MAJOR_VERSION;
    }

    public int getVendorMinorVersion() {
        return this.VENDOR_MINOR_VERSION;
    }

    public QueryKey getQueryKey() {
        return this.QUERY_KEY;
    }

    public List getPackedIPPorts() {
        return this.PACKED_IP_PORTS;
    }

    public List getPackedUDPHostCaches() {
        return this.PACKED_UDP_HOST_CACHES;
    }

    public boolean hasGGEPExtension() {
        return this.HAS_GGEP_EXTENSION;
    }

    private static GGEP parseGGEP(byte[] PAYLOAD) {
        if (PAYLOAD.length <= 14) {
            return null;
        }
        try {
            return new GGEP(PAYLOAD, 14, null);
        }
        catch (BadGGEPBlockException e) {
            return null;
        }
    }

    public Message stripExtendedPayload() {
        byte[] newPayload = new byte[14];
        System.arraycopy(this.PAYLOAD, 0, newPayload, 0, 14);
        return new PingReply(this.getGUID(), this.getTTL(), this.getHops(), newPayload, null, this.IP);
    }

    private List listCaches(String allCaches) {
        LinkedList theCaches = new LinkedList();
        StringTokenizer st = new StringTokenizer(allCaches, "\n");
        while (st.hasMoreTokens()) {
            int port;
            int i;
            String next;
            block7: {
                next = st.nextToken();
                i = next.indexOf("&");
                if (i != -1) {
                    next = next.substring(0, i);
                }
                i = next.indexOf(":");
                port = 6346;
                if (i == 0 || i == next.length()) continue;
                if (i != -1) {
                    try {
                        port = Integer.valueOf(next.substring(i + 1));
                        break block7;
                    }
                    catch (NumberFormatException invalid) {
                        continue;
                    }
                }
                i = next.length();
            }
            if (!NetworkUtils.isValidPort(port)) continue;
            String host = next.substring(0, i);
            try {
                theCaches.add((Object)new IpPortImpl(host, port));
            }
            catch (UnknownHostException invalid) {}
        }
        return Collections.unmodifiableList((List)theCaches);
    }

    public boolean isUltrapeer() {
        long kb = this.getKbytes();
        if (kb < 8L) {
            return false;
        }
        return PingReply.isPowerOf2(ByteOrder.long2int(kb));
    }

    public static boolean isPowerOf2(int x) {
        if (x <= 0) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PING_REPLIES.addMessage(this);
    }

    private static long mark(long kbytes) {
        int x = ByteOrder.long2int(kbytes);
        if (x < 12) {
            return 8L;
        }
        if (x < 24) {
            return 16L;
        }
        if (x < 48) {
            return 32L;
        }
        if (x < 96) {
            return 64L;
        }
        if (x < 192) {
            return 128L;
        }
        if (x < 384) {
            return 256L;
        }
        if (x < 768) {
            return 512L;
        }
        if (x < 1536) {
            return 1024L;
        }
        if (x < 3072) {
            return 2048L;
        }
        if (x < 6144) {
            return 4096L;
        }
        if (x < 12288) {
            return 8192L;
        }
        if (x < 24576) {
            return 16384L;
        }
        if (x < 49152) {
            return 32768L;
        }
        if (x < 98304) {
            return 65536L;
        }
        if (x < 196608) {
            return 131072L;
        }
        if (x < 393216) {
            return 262144L;
        }
        if (x < 786432) {
            return 524288L;
        }
        if (x < 0x180000) {
            return 0x100000L;
        }
        if (x < 0x300000) {
            return 0x200000L;
        }
        if (x < 0x600000) {
            return 0x400000L;
        }
        if (x < 0xC00000) {
            return 0x800000L;
        }
        if (x < 0x1800000) {
            return 0x1000000L;
        }
        if (x < 0x3000000) {
            return 0x2000000L;
        }
        if (x < 0x6000000) {
            return 0x4000000L;
        }
        if (x < 0xC000000) {
            return 0x8000000L;
        }
        if (x < 0x18000000) {
            return 0x10000000L;
        }
        if (x < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }

    public String toString() {
        return "PingReply(" + this.getAddress() + ":" + this.getPort() + ", free ultrapeers slots: " + this.hasFreeUltrapeerSlots() + ", free leaf slots: " + this.hasFreeLeafSlots() + ", vendor: " + this.VENDOR + " " + this.VENDOR_MAJOR_VERSION + "." + this.VENDOR_MINOR_VERSION + ", " + super.toString() + ", locale : " + this.CLIENT_LOCALE + ")";
    }

    public InetAddress getInetAddress() {
        return this.IP;
    }

    public InetAddress getMyInetAddress() {
        return this.MY_IP;
    }

    public int getMyPort() {
        return this.MY_PORT;
    }

    public String getClientLocale() {
        return this.CLIENT_LOCALE;
    }

    public int getNumFreeLocaleSlots() {
        return this.FREE_LOCALE_SLOTS;
    }

    public boolean isUDPHostCache() {
        return this.UDP_CACHE_ADDRESS != null;
    }

    public String getUDPCacheAddress() {
        return this.UDP_CACHE_ADDRESS;
    }

    static {
        System.arraycopy("LIME".getBytes(), 0, CACHED_VENDOR, 0, "LIME".getBytes().length);
        PingReply.CACHED_VENDOR[4] = PingReply.convertToGUESSFormat(CommonUtils.getMajorVersionNumber(), CommonUtils.getMinorVersionNumber());
    }
}

