/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NameValue;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PingRequest
extends Message {
    public static final byte SCP_ULTRAPEER_OR_LEAF_MASK = 1;
    public static final byte SCP_LEAF = 0;
    public static final byte SCP_ULTRAPEER = 1;
    private byte[] payload = null;
    private GGEP _ggep;

    public PingRequest(byte[] guid, byte ttl, byte hops) {
        super(guid, (byte)0, ttl, hops, 0);
    }

    protected PingRequest(byte[] guid, byte ttl, byte hops, byte length) {
        super(guid, (byte)0, ttl, hops, length);
    }

    public PingRequest(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)0, ttl, hops, payload.length);
        this.payload = payload;
    }

    public PingRequest(byte ttl) {
        super((byte)0, ttl, 0);
        this.addBasicGGEPs();
    }

    public PingRequest(byte[] guid, byte ttl) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addBasicGGEPs();
    }

    private PingRequest(byte[] guid, byte ttl, List ggeps) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addGGEPs(ggeps);
    }

    public static PingRequest createQueryKeyRequest() {
        LinkedList l = new LinkedList();
        l.add((Object)new NameValue("QK"));
        return new PingRequest(GUID.makeGuid(), 1, (List)l);
    }

    public static PingRequest createUDPPing() {
        GUID guid;
        LinkedList l = new LinkedList();
        if (ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue()) {
            guid = new GUID();
        } else {
            l.add((Object)new NameValue("IP"));
            guid = UDPService.instance().getSolicitedGUID();
        }
        byte[] data = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        l.add((Object)new NameValue("SCP", data));
        return new PingRequest(guid.bytes(), 1, (List)l);
    }

    public static PingRequest createMulticastPing() {
        GUID guid = new GUID();
        byte[] data = new byte[]{RouterService.isSupernode() ? (byte)1 : 0};
        LinkedList l = new LinkedList();
        l.add((Object)new NameValue("SCP", data));
        return new PingRequest(guid.bytes(), 1, (List)l);
    }

    protected void writePayload(OutputStream out) throws IOException {
        if (this.payload != null) {
            out.write(this.payload);
        }
        SentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public Message stripExtendedPayload() {
        if (this.payload == null) {
            return this;
        }
        return new PingRequest(this.getGUID(), this.getTTL(), this.getHops());
    }

    public void recordDrop() {
        DroppedSentMessageStatHandler.TCP_PING_REQUESTS.addMessage(this);
    }

    public String toString() {
        return "PingRequest(" + super.toString() + ")";
    }

    public boolean isHeartbeat() {
        return this.getHops() == 1 && this.getTTL() == 0;
    }

    public void addIPRequest() {
        LinkedList l = new LinkedList();
        l.add((Object)new NameValue("IP"));
        this.addGGEPs((List)l);
    }

    private void addBasicGGEPs() {
        LinkedList l = new LinkedList();
        l.add((Object)new NameValue("LOC", ApplicationSettings.LANGUAGE.getValue()));
        this.addGGEPs((List)l);
    }

    private void addGGEPs(List ggeps) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this._ggep == null) {
                this._ggep = new GGEP(true);
            }
            this._ggep.putAll(ggeps);
            this._ggep.write(baos);
            baos.write(0);
            this.payload = baos.toByteArray();
            this.updateLength(this.payload.length);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
    }

    public String getLocale() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("LOC")) {
                    return this._ggep.getString("LOC");
                }
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public boolean supportsCachedPongs() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("SCP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    public byte[] getSupportsCachedPongData() {
        byte[] ret = null;
        if (this.payload != null) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("SCP")) {
                    ret = DataUtils.EMPTY_BYTE_ARRAY;
                    return this._ggep.getBytes("SCP");
                }
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isQueryKeyRequest() {
        if (this.getTTL() != 0 || this.getHops() != 1) {
            return false;
        }
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("QK");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean requestsIP() {
        if (this.payload != null) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("IP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    private void parseGGEP() throws BadGGEPBlockException {
        if (this._ggep == null) {
            this._ggep = new GGEP(this.payload, 0, null);
        }
    }
}

