/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class QueryStatusResponse
extends VendorMessage {
    public static final int VERSION = 1;

    QueryStatusResponse(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_BEAR_VENDOR_ID, 12, version, payload);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public QueryStatusResponse(GUID replyGUID, int numResults) {
        super(F_BEAR_VENDOR_ID, 12, 1, QueryStatusResponse.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.getPayload(), 0));
    }

    public GUID getQueryGUID() {
        return new GUID(this.getGUID());
    }

    private static byte[] derivePayload(int numResults) {
        if (numResults < 0 || numResults > 65535) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[2];
        ByteOrder.short2leb((short)numResults, payload, 0);
        return payload;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (RECORD_STATS) {
            SentMessageStatHandler.UDP_REPLY_NUMBER.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

