/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class StatisticVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    private static final String DELIMITER = " | ";
    private static final String DELIMITER2 = " ^ ";

    public StatisticVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 15, version, payload);
    }

    public StatisticVendorMessage(GiveStatsVendorMessage giveStatVM) {
        super(F_LIME_VENDOR_ID, 15, 1, StatisticVendorMessage.derivePayload(giveStatVM));
    }

    public static boolean isSupported(GiveStatsVendorMessage vm) {
        switch (vm.getStatType()) {
            case 0: 
            case 1: {
                switch (vm.getStatControl()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] derivePayload(GiveStatsVendorMessage giveStatsVM) {
        byte control = giveStatsVM.getStatControl();
        byte type = giveStatsVM.getStatType();
        byte[] part1 = new byte[]{control, type};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(part1);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        switch (type) {
            case 0: 
            case 1: {
                boolean incoming = type == 0;
                byte[] part2 = StatisticVendorMessage.getGnutellaStats(control, incoming);
                break;
            }
            case 2: {
                StringBuffer buff = new StringBuffer();
                buff.append(BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.getTotal());
                buff.append(DELIMITER2);
                buff.append(BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.getTotal());
                byte[] part2 = buff.toString().getBytes();
                break;
            }
            case 3: {
                StringBuffer buff = new StringBuffer();
                buff.append(BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.getTotal());
                buff.append(DELIMITER2);
                buff.append(BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.getTotal());
                byte[] part2 = buff.toString().getBytes();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + type);
            }
        }
        try {
            void var5_6;
            baos.write((byte[])var5_6);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        return baos.toByteArray();
    }

    private static byte[] getGnutellaStats(byte control, boolean incoming) {
        List conns = RouterService.getConnectionManager().getConnections();
        StringBuffer buff = new StringBuffer();
        switch (control) {
            case 0: {
                Iterator iter = conns.iterator();
                while (iter.hasNext()) {
                    ManagedConnection c = (ManagedConnection)iter.next();
                    buff.append(c.toString());
                    buff.append(DELIMITER2);
                    if (incoming) {
                        buff.append(c.getNumMessagesReceived());
                        buff.append(DELIMITER);
                        buff.append(c.getNumReceivedMessagesDropped());
                    } else {
                        buff.append(c.getNumMessagesSent());
                        buff.append(DELIMITER);
                        buff.append(c.getNumSentMessagesDropped());
                    }
                    buff.append(DELIMITER2);
                }
                return buff.toString().getBytes();
            }
            case 1: {
                int messages = -1;
                int dropped = -1;
                Iterator iter = conns.iterator();
                while (iter.hasNext()) {
                    ManagedConnection c = (ManagedConnection)iter.next();
                    messages += incoming ? c.getNumMessagesReceived() : c.getNumMessagesSent();
                    dropped = (int)((long)dropped + (incoming ? c.getNumReceivedMessagesDropped() : (long)c.getNumSentMessagesDropped()));
                }
                buff.append(messages);
                buff.append(DELIMITER);
                buff.append(dropped);
                return buff.toString().getBytes();
            }
            case 3: {
                Iterator iter = conns.iterator();
                while (iter.hasNext()) {
                    ManagedConnection c = (ManagedConnection)iter.next();
                    if (!c.isSupernodeConnection()) continue;
                    buff.append(c.toString());
                    buff.append(DELIMITER2);
                    if (incoming) {
                        buff.append(c.getNumMessagesReceived());
                        buff.append(DELIMITER);
                        buff.append(c.getNumReceivedMessagesDropped());
                    } else {
                        buff.append(c.getNumMessagesSent());
                        buff.append(DELIMITER);
                        buff.append(c.getNumSentMessagesDropped());
                    }
                    buff.append(DELIMITER2);
                }
                return buff.toString().getBytes();
            }
            case 2: {
                Iterator iter = conns.iterator();
                while (iter.hasNext()) {
                    ManagedConnection c = (ManagedConnection)iter.next();
                    if (!c.isLeafConnection()) continue;
                    buff.append(c.toString());
                    buff.append(DELIMITER2);
                    if (incoming) {
                        buff.append(c.getNumMessagesReceived());
                        buff.append(DELIMITER);
                        buff.append(c.getNumReceivedMessagesDropped());
                    } else {
                        buff.append(c.getNumMessagesSent());
                        buff.append(DELIMITER);
                        buff.append(c.getNumSentMessagesDropped());
                    }
                    buff.append(DELIMITER2);
                }
                return buff.toString().getBytes();
            }
        }
        throw new IllegalArgumentException("unknown control: " + control);
    }

    public String getReportedStats() {
        return new String(this.getPayload());
    }
}

