/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.sun.java.util.collections.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class VendorMessage
extends Message {
    protected static final int F_MESSAGES_SUPPORTED = 0;
    protected static final int F_HOPS_FLOW = 4;
    protected static final int F_TCP_CONNECT_BACK = 7;
    protected static final int F_UDP_CONNECT_BACK = 7;
    protected static final int F_UDP_CONNECT_BACK_REDIR = 8;
    protected static final int F_CAPABILITIES = 10;
    protected static final int F_LIME_ACK = 11;
    protected static final int F_REPLY_NUMBER = 12;
    protected static final int F_PUSH_PROXY_REQ = 21;
    protected static final int F_PUSH_PROXY_ACK = 22;
    protected static final int F_GIVE_STATS = 14;
    protected static final int F_STATISTICS = 15;
    protected static final int F_GIVE_ULTRAPEER = 5;
    protected static final int F_ULTRAPEER_LIST = 6;
    protected static final byte[] F_LIME_VENDOR_ID = new byte[]{76, 73, 77, 69};
    protected static final byte[] F_BEAR_VENDOR_ID = new byte[]{66, 69, 65, 82};
    protected static final byte[] F_GTKG_VENDOR_ID = new byte[]{71, 84, 75, 71};
    protected static final byte[] F_NULL_VENDOR_ID = new byte[]{0, 0, 0, 0};
    private static final int LENGTH_MINUS_PAYLOAD = 8;
    private static final BadPacketException UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected VendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload) {
        this(vendorIDBytes, selector, version, payload, -1);
    }

    protected VendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload, int network) {
        super((byte)49, (byte)1, 8 + payload.length, network);
        if (vendorIDBytes.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + vendorIDBytes.length);
        }
        if ((selector & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + selector);
        }
        if ((version & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this._vendorID = vendorIDBytes;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected VendorMessage(byte[] guid, byte ttl, byte hops, byte[] vendorID, int selector, int version, byte[] payload) throws BadPacketException {
        this(guid, ttl, hops, vendorID, selector, version, payload, -1);
    }

    protected VendorMessage(byte[] guid, byte ttl, byte hops, byte[] vendorID, int selector, int version, byte[] payload, int network) throws BadPacketException {
        super(guid, (byte)49, ttl, hops, 8 + payload.length, network);
        if (vendorID.length != 4) {
            if (RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_ID.incrementStat();
            }
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((selector & 0xFFFF0000) != 0) {
            if (RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_SELECTOR.incrementStat();
            }
            throw new BadPacketException("Selector Invalid!");
        }
        if ((version & 0xFFFF0000) != 0) {
            if (RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_VERSION.incrementStat();
            }
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = vendorID;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = VendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int version, int selector, byte[] vendorID, byte[] payload) {
        int i;
        int hashCode = 0;
        hashCode += 17 * version;
        hashCode += 17 * selector;
        for (i = 0; i < vendorID.length; ++i) {
            hashCode += 17 * vendorID[i];
        }
        for (i = 0; i < payload.length; ++i) {
            hashCode += 17 * payload[i];
        }
        return hashCode;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    protected int getVersion() {
        return this._version;
    }

    public static VendorMessage deriveVendorMessage(byte[] guid, byte ttl, byte hops, byte[] fromNetwork, int network) throws BadPacketException {
        if (fromNetwork.length < 8) {
            if (RECORD_STATS) {
                ReceivedErrorStat.VENDOR_INVALID_PAYLOAD.incrementStat();
            }
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(fromNetwork);
        byte[] vendorID = null;
        byte[] restOf = null;
        int selector = -1;
        int version = -1;
        try {
            vendorID = new byte[4];
            bais.read(vendorID, 0, vendorID.length);
            selector = ByteOrder.ubytes2int(ByteOrder.leb2short(bais));
            version = ByteOrder.ubytes2int(ByteOrder.leb2short(bais));
            restOf = new byte[bais.available()];
            bais.read(restOf, 0, restOf.length);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        if (selector == 4 && Arrays.equals((byte[])vendorID, (byte[])F_BEAR_VENDOR_ID)) {
            return new HopsFlowVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 11 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new LimeACKVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 12 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new ReplyNumberVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 7 && Arrays.equals((byte[])vendorID, (byte[])F_BEAR_VENDOR_ID)) {
            return new TCPConnectBackVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 0 && Arrays.equals((byte[])vendorID, (byte[])F_NULL_VENDOR_ID)) {
            return new MessagesSupportedVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 7 && Arrays.equals((byte[])vendorID, (byte[])F_GTKG_VENDOR_ID)) {
            return new UDPConnectBackVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 21 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new PushProxyRequest(guid, ttl, hops, version, restOf);
        }
        if (selector == 22 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new PushProxyAcknowledgement(guid, ttl, hops, version, restOf);
        }
        if (selector == 11 && Arrays.equals((byte[])vendorID, (byte[])F_BEAR_VENDOR_ID)) {
            return new QueryStatusRequest(guid, ttl, hops, version, restOf);
        }
        if (selector == 12 && Arrays.equals((byte[])vendorID, (byte[])F_BEAR_VENDOR_ID)) {
            return new QueryStatusResponse(guid, ttl, hops, version, restOf);
        }
        if (selector == 7 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new TCPConnectBackRedirect(guid, ttl, hops, version, restOf);
        }
        if (selector == 8 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPConnectBackRedirect(guid, ttl, hops, version, restOf);
        }
        if (selector == 10 && Arrays.equals((byte[])vendorID, (byte[])F_NULL_VENDOR_ID)) {
            return new CapabilitiesVM(guid, ttl, hops, version, restOf);
        }
        if (selector == 14 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new GiveStatsVendorMessage(guid, ttl, hops, version, restOf, network);
        }
        if (selector == 15 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new StatisticVendorMessage(guid, ttl, hops, version, restOf);
        }
        if (selector == 5 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPCrawlerPing(guid, ttl, hops, version, restOf);
        }
        if (selector == 6 && Arrays.equals((byte[])vendorID, (byte[])F_LIME_VENDOR_ID)) {
            return new UDPCrawlerPong(guid, ttl, hops, version, restOf);
        }
        if (RECORD_STATS) {
            ReceivedErrorStat.VENDOR_UNRECOGNIZED.incrementStat();
        }
        throw UNRECOGNIZED_EXCEPTION;
    }

    public boolean equals(Object other) {
        if (other instanceof VendorMessage) {
            VendorMessage vmp = (VendorMessage)other;
            return this._selector == vmp._selector && Arrays.equals((byte[])this._vendorID, (byte[])vmp._vendorID) && Arrays.equals((byte[])this._payload, (byte[])vmp._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, out);
        ByteOrder.short2leb((short)this._version, out);
        out.write(this.getPayload());
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

