/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.StringUtils;

public class HashFunction {
    private static final int A_INT = 1327217884;

    private static int hashFast(int x, byte bits) {
        return x * 1327217884 >>> 32 - bits;
    }

    public static int hash(String x, byte bits) {
        return HashFunction.hash(x, 0, x.length(), bits);
    }

    public static int hash(String x, int start, int end, byte bits) {
        int xor = 0;
        int j = 0;
        for (int i = start; i < end; ++i) {
            xor ^= (Character.toLowerCase(x.charAt(i)) & 0xFF) << j;
            j = j + 8 & 0x18;
        }
        return HashFunction.hashFast(xor, bits);
    }

    public static String[] keywords(String filePath) {
        return StringUtils.split(I18NConvert.instance().getNorm(filePath), " -._+/*()\\");
    }

    public static int keywordStart(String query, int i) {
        String DELIMETERS = " -._+/*()\\";
        while (i < query.length()) {
            char c = query.charAt(i);
            if (" -._+/*()\\".indexOf(c) < 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int keywordEnd(String query, int i) {
        String DELIMETERS = " -._+/*()\\";
        while (i < query.length()) {
            char c = query.charAt(i);
            if (" -._+/*()\\".indexOf(c) >= 0) {
                return i;
            }
            ++i;
        }
        return query.length();
    }

    public static String[] getPrefixes(String[] words) {
        int prefixable = 0;
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() <= 4) continue;
            ++prefixable;
        }
        if (prefixable == 0) {
            return words;
        }
        String[] retArray = new String[words.length + prefixable * 2];
        int j = 0;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            retArray[j++] = word;
            int len = word.length();
            if (len <= 4) continue;
            retArray[j++] = word.substring(0, len - 1);
            retArray[j++] = word.substring(0, len - 2);
        }
        return retArray;
    }
}

