/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.util.BitSet;
import com.limegroup.gnutella.util.Utilities;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class QueryRouteTable {
    public static final byte DEFAULT_INFINITY = 7;
    public static final byte KEYWORD_NO_CHANGE = 0;
    public static final int DEFAULT_TABLE_SIZE = 65536;
    public static final int MAX_PATCH_SIZE = 4096;
    private byte infinity;
    private byte keywordPresent;
    private byte keywordAbsent;
    private BitSet bitTable;
    private QueryRouteTable resizedQRT = null;
    private int bitTableLength;
    private int sequenceNumber;
    private int sequenceSize;
    private int nextPatch;
    private Inflater uncompressor;

    public QueryRouteTable() {
        this(65536);
    }

    public QueryRouteTable(int size) {
        this(size, 7);
    }

    public QueryRouteTable(int size, byte infinity) {
        this.initialize(size, infinity);
    }

    private void initialize(int size, byte infinity) {
        this.bitTableLength = size;
        this.bitTable = new BitSet();
        this.sequenceNumber = -1;
        this.sequenceSize = -1;
        this.nextPatch = 0;
        this.keywordPresent = (byte)(1 - infinity);
        this.keywordAbsent = (byte)(infinity - 1);
        this.infinity = infinity;
    }

    public int getSize() {
        return this.bitTableLength;
    }

    public double getPercentFull() {
        double set = this.bitTable.cardinality();
        return set / (double)this.bitTableLength * 100.0;
    }

    public boolean contains(QueryRequest qr) {
        int j;
        byte bits = Utilities.log2(this.bitTableLength);
        String query = qr.getQuery();
        LimeXMLDocument richQuery = qr.getRichQuery();
        if (query.length() == 0 && richQuery == null && !qr.hasQueryUrns()) {
            return false;
        }
        if (qr.hasQueryUrns()) {
            Set urns = qr.getQueryUrns();
            Iterator iter = urns.iterator();
            while (iter.hasNext()) {
                URN qurn = (URN)iter.next();
                int hash = HashFunction.hash(qurn.toString(), bits);
                if (!this.contains(hash)) continue;
                return true;
            }
            return false;
        }
        int i = 0;
        while ((j = HashFunction.keywordStart(query, i)) >= 0) {
            int k = HashFunction.keywordEnd(query, j);
            int hash = HashFunction.hash(query, j, k, bits);
            if (!this.contains(hash)) {
                return false;
            }
            i = k + 1;
        }
        if (richQuery == null) {
            return true;
        }
        String docSchemaURI = richQuery.getSchemaURI();
        int hash = HashFunction.hash(docSchemaURI, bits);
        if (!this.contains(hash)) {
            return false;
        }
        int wordCount = 0;
        int matchCount = 0;
        Iterator iter = richQuery.getKeyWords().iterator();
        while (iter.hasNext()) {
            int j2;
            String words = (String)iter.next();
            int i2 = 0;
            while ((j2 = HashFunction.keywordStart(words, i2)) >= 0) {
                int k = HashFunction.keywordEnd(words, j2);
                int wordHash = HashFunction.hash(words, j2, k, bits);
                if (this.contains(wordHash)) {
                    ++matchCount;
                }
                ++wordCount;
                i2 = k + 1;
            }
        }
        if (wordCount < 3) {
            return wordCount == matchCount;
        }
        return (double)((float)matchCount / (float)wordCount) > 0.67;
    }

    private final boolean contains(int hash) {
        return this.bitTable.get(hash);
    }

    public void add(String filePath) {
        this.addBTInternal(filePath);
    }

    private void addBTInternal(String filePath) {
        String[] words = HashFunction.keywords(filePath);
        String[] keywords = HashFunction.getPrefixes(words);
        byte log2 = Utilities.log2(this.bitTableLength);
        for (int i = 0; i < keywords.length; ++i) {
            int hash = HashFunction.hash(keywords[i], log2);
            if (this.bitTable.get(hash)) continue;
            this.resizedQRT = null;
            this.bitTable.set(hash);
        }
    }

    public void addIndivisible(String iString) {
        int hash = HashFunction.hash(iString, Utilities.log2(this.bitTableLength));
        if (!this.bitTable.get(hash)) {
            this.resizedQRT = null;
            this.bitTable.set(hash);
        }
    }

    public void addAll(QueryRouteTable qrt) {
        this.bitTable.or(qrt.resize(this.bitTableLength));
    }

    private BitSet resize(int newSize) {
        if (this.bitTableLength == newSize) {
            return this.bitTable;
        }
        if (this.resizedQRT != null && this.resizedQRT.bitTableLength == newSize) {
            return this.resizedQRT.bitTable;
        }
        this.resizedQRT = new QueryRouteTable(newSize);
        int m = this.bitTableLength;
        int m2 = this.resizedQRT.bitTableLength;
        int i = this.bitTable.nextSetBit(0);
        while (i >= 0) {
            int firstSet = (int)((long)i * (long)m2 / (long)m);
            i = this.bitTable.nextClearBit(i + 1);
            int lastNotSet = (int)(((long)i * (long)m2 - 1L) / (long)m + 1L);
            this.resizedQRT.bitTable.set(firstSet, lastNotSet);
            i = this.bitTable.nextSetBit(i + 1);
        }
        return this.resizedQRT.bitTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryRouteTable)) {
            return false;
        }
        QueryRouteTable other = (QueryRouteTable)o;
        if (this.bitTableLength != other.bitTableLength) {
            return false;
        }
        return this.bitTable.equals(other.bitTable);
    }

    public int hashCode() {
        return this.bitTable.hashCode() * 17;
    }

    public String toString() {
        return "QueryRouteTable : " + this.bitTable.toString();
    }

    public void reset(ResetTableMessage rtm) {
        this.initialize(rtm.getTableSize(), rtm.getInfinity());
    }

    public void patch(PatchTableMessage patch) throws BadPacketException {
        this.handlePatch(patch);
    }

    private void handlePatch(PatchTableMessage m) throws BadPacketException {
        if (this.sequenceSize != -1 && this.sequenceSize != m.getSequenceSize()) {
            throw new BadPacketException("Inconsistent seq size: " + m.getSequenceSize() + " vs. " + this.sequenceSize);
        }
        if (this.sequenceNumber == -1 ? m.getSequenceNumber() != 1 : this.sequenceNumber + 1 != m.getSequenceNumber()) {
            throw new BadPacketException("Inconsistent seq number: " + m.getSequenceNumber() + " vs. " + this.sequenceNumber);
        }
        byte[] data = m.getData();
        if (m.getCompressor() == 1) {
            try {
                if (m.getSequenceNumber() == 1) {
                    this.uncompressor = new Inflater();
                }
                Assert.that(this.uncompressor != null, "Null uncompressor.  Sequence: " + m.getSequenceNumber());
                data = this.uncompress(data);
            }
            catch (IOException e) {
                throw new BadPacketException("Couldn't uncompress data: " + e);
            }
        } else if (m.getCompressor() != 0) {
            throw new BadPacketException("Unknown compressor");
        }
        if (m.getEntryBits() == 4) {
            data = QueryRouteTable.unhalve(data);
        } else if (m.getEntryBits() != 8) {
            throw new BadPacketException("Unknown value for entry bits");
        }
        for (int i = 0; i < data.length; ++i) {
            if (this.nextPatch >= this.bitTableLength) {
                throw new BadPacketException("Tried to patch " + this.nextPatch + " on a bitTable of size " + this.bitTableLength);
            }
            if (data[i] < 0) {
                this.bitTable.set(this.nextPatch);
                this.resizedQRT = null;
            } else if (data[i] > 0) {
                this.bitTable.clear(this.nextPatch);
                this.resizedQRT = null;
            }
            ++this.nextPatch;
        }
        this.sequenceSize = m.getSequenceSize();
        if (m.getSequenceNumber() != m.getSequenceSize()) {
            this.sequenceNumber = m.getSequenceNumber();
        } else {
            this.sequenceNumber = -1;
            this.sequenceSize = -1;
            this.nextPatch = 0;
            if (this.uncompressor != null) {
                this.uncompressor.end();
                this.uncompressor = null;
            }
        }
    }

    public List encode(QueryRouteTable prev) {
        return this.encode(prev, true);
    }

    public List encode(QueryRouteTable prev, boolean allowCompression) {
        byte[] patchCompressed;
        LinkedList buf = new LinkedList();
        if (prev == null) {
            buf.add((Object)new ResetTableMessage(this.bitTableLength, this.infinity));
        } else {
            Assert.that(prev.bitTableLength == this.bitTableLength, "TODO: can't deal with tables of different lengths");
        }
        byte[] data = new byte[this.bitTableLength];
        Utilities.fill(data, 0, this.bitTableLength, (byte)0);
        boolean needsPatch = false;
        if (prev != null) {
            if (!this.bitTable.equals(prev.bitTable)) {
                BitSet xOr = (BitSet)this.bitTable.clone();
                xOr.xor(prev.bitTable);
                int i = xOr.nextSetBit(0);
                while (i >= 0) {
                    data[i] = this.bitTable.get(i) ? this.keywordPresent : this.keywordAbsent;
                    needsPatch = true;
                    i = xOr.nextSetBit(i + 1);
                }
            }
        } else {
            int i = this.bitTable.nextSetBit(0);
            while (i >= 0) {
                data[i] = this.keywordPresent;
                needsPatch = true;
                i = this.bitTable.nextSetBit(i + 1);
            }
        }
        if (!needsPatch) {
            return buf;
        }
        byte bits = 8;
        if (this.keywordPresent >= -8 && this.keywordAbsent <= 7) {
            bits = 4;
            data = QueryRouteTable.halve(data);
        }
        byte compression = 0;
        if (allowCompression && (patchCompressed = this.compress(data)).length < data.length) {
            data = patchCompressed;
            compression = 1;
        }
        int chunks = (int)Math.ceil((float)data.length / 4096.0f);
        int chunk = 1;
        for (int i = 0; i < data.length; i += 4096) {
            int stop = Math.min(i + 4096, data.length);
            buf.add((Object)new PatchTableMessage((short)chunk, (short)chunks, compression, bits, data, i, stop));
            ++chunk;
        }
        return buf;
    }

    private byte[] compress(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream(baos);
            dos.write(data, 0, data.length);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    private byte[] uncompress(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.uncompressor.setInput(data);
        try {
            int read;
            byte[] buf = new byte[1024];
            while ((read = this.uncompressor.inflate(buf)) != 0) {
                baos.write(buf, 0, read);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (DataFormatException e) {
            throw new IOException("Bad deflate format");
        }
    }

    static byte[] halve(byte[] array) {
        byte[] ret = new byte[array.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(array[2 * i] << 4 | array[2 * i + 1] & 0xF);
        }
        return ret;
    }

    static byte[] unhalve(byte[] array) {
        byte[] ret = new byte[array.length * 2];
        for (int i = 0; i < array.length; ++i) {
            ret[2 * i] = (byte)(array[i] >> 4);
            ret[2 * i + 1] = QueryRouteTable.extendNibble((byte)(array[i] & 0xF));
        }
        return ret;
    }

    static byte extendNibble(byte b) {
        if ((b & 8) != 0) {
            return (byte)(0xF0 | b);
        }
        return b;
    }
}

