/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryHandler;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;

final class ProbeQuery {
    private final List TTL_1_PROBES;
    private final List TTL_2_PROBES;
    private final QueryHandler QUERY_HANDLER;

    ProbeQuery(List connections, QueryHandler qh) {
        this.QUERY_HANDLER = qh;
        LinkedList[] lists = ProbeQuery.createProbeLists(connections, qh.QUERY);
        this.TTL_1_PROBES = lists[0];
        this.TTL_2_PROBES = lists[1];
    }

    long getTimeToWait() {
        if (!this.TTL_2_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * 1.3);
        }
        if (!this.TTL_1_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * ((double)this.TTL_1_PROBES.size() / 2.0));
        }
        return 0L;
    }

    int sendProbe() {
        ManagedConnection mc;
        Iterator iter = this.TTL_1_PROBES.iterator();
        int hosts = 0;
        QueryRequest query = this.QUERY_HANDLER.createQuery((byte)1);
        while (iter.hasNext()) {
            mc = (ManagedConnection)iter.next();
            hosts += QueryHandler.sendQueryToHost(query, mc, this.QUERY_HANDLER);
        }
        query = this.QUERY_HANDLER.createQuery((byte)2);
        iter = this.TTL_2_PROBES.iterator();
        while (iter.hasNext()) {
            mc = (ManagedConnection)iter.next();
            hosts += QueryHandler.sendQueryToHost(query, mc, this.QUERY_HANDLER);
        }
        this.TTL_1_PROBES.clear();
        this.TTL_2_PROBES.clear();
        return hosts;
    }

    private static LinkedList[] createProbeLists(List connections, QueryRequest query) {
        boolean adequateData;
        Iterator iter = connections.iterator();
        LinkedList missConnections = new LinkedList();
        LinkedList oldConnections = new LinkedList();
        LinkedList hitConnections = new LinkedList();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (mc.isUltrapeerQueryRoutingConnection()) {
                if (mc.shouldForwardQuery(query)) {
                    hitConnections.add((Object)mc);
                    continue;
                }
                missConnections.add((Object)mc);
                continue;
            }
            oldConnections.add((Object)mc);
        }
        LinkedList[] returnLists = new LinkedList[2];
        LinkedList ttl1List = new LinkedList();
        LinkedList ttl2List = new LinkedList();
        returnLists[0] = ttl1List;
        returnLists[1] = ttl2List;
        boolean bl = adequateData = missConnections.size() + hitConnections.size() > 8;
        if (hitConnections.size() == 0 || !adequateData) {
            return ProbeQuery.createAggressiveProbe((List)oldConnections, (List)missConnections, (List)hitConnections, returnLists);
        }
        int numHitConnections = hitConnections.size();
        double popularity = (double)numHitConnections / ((double)missConnections.size() + (double)numHitConnections);
        if (popularity == 1.0) {
            ttl1List.add(hitConnections.removeFirst());
            return returnLists;
        }
        if (numHitConnections > 3) {
            int numToTry = Math.min(9, numHitConnections);
            int startIndex = numHitConnections - numToTry;
            int endIndex = numHitConnections;
            ttl1List.addAll((Collection)hitConnections.subList(startIndex, endIndex));
            return returnLists;
        }
        ttl1List.addAll((Collection)hitConnections);
        ProbeQuery.addToList((List)ttl2List, (List)oldConnections, (List)missConnections, 3);
        return returnLists;
    }

    private static void addToList(List listToAddTo, List list1, List list2, int numElements) {
        if (list1.size() >= numElements) {
            listToAddTo.addAll((Collection)list1.subList(0, numElements));
            return;
        }
        listToAddTo.addAll((Collection)list1);
        if (list2.size() >= (numElements -= list1.size())) {
            listToAddTo.addAll((Collection)list2.subList(0, numElements));
        } else {
            listToAddTo.addAll((Collection)list2);
        }
    }

    private static LinkedList[] createAggressiveProbe(List oldConnections, List missConnections, List hitConnections, LinkedList[] returnLists) {
        ProbeQuery.addToList((List)returnLists[1], oldConnections, missConnections, 3);
        int maxIndex = Math.min(4, hitConnections.size());
        returnLists[0].addAll((Collection)hitConnections.subList(0, maxIndex));
        return returnLists;
    }
}

