/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public final class QueryDispatcher
implements Runnable {
    private final Map QUERIES = new HashMap();
    private final List NEW_QUERIES = Collections.synchronizedList((List)new LinkedList());
    private static volatile boolean _done = true;
    private static final QueryDispatcher INSTANCE = new QueryDispatcher();
    private final Set TO_REMOVE = Collections.synchronizedSet((Set)new HashSet());

    public static QueryDispatcher instance() {
        return INSTANCE;
    }

    private QueryDispatcher() {
    }

    public void start() {
        ManagedThread dispatcher = new ManagedThread(this, "QueryDispatcher");
        dispatcher.setDaemon(true);
        dispatcher.start();
    }

    public void addQuery(QueryHandler handler) {
        handler.sendQuery();
        this.NEW_QUERIES.add((Object)handler);
    }

    public void removeReplyHandler(ReplyHandler handler) {
        if (!handler.isSupernodeClientConnection()) {
            return;
        }
        QueryDispatcher.removeFromCollection((Collection)this.NEW_QUERIES, handler);
        QueryDispatcher.removeFromMap(this.QUERIES, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID queryGUID, int numResults) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get((Object)queryGUID);
            if (qh != null) {
                qh.updateLeafResults(numResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID queryGUID) {
        Map map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = (QueryHandler)this.QUERIES.get((Object)queryGUID);
            if (qh == null) {
                return -1;
            }
            return qh.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromCollection(Collection coll, ReplyHandler handler) {
        LinkedList toRemove = new LinkedList();
        Collection collection = coll;
        synchronized (collection) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)iter.next();
                ReplyHandler rh = qh.getReplyHandler();
                if (handler != rh) continue;
                toRemove.add((Object)qh);
            }
            coll.removeAll((Collection)toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromMap(Map map, ReplyHandler handler) {
        LinkedList toRemove = new LinkedList();
        Map map2 = map;
        synchronized (map2) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                QueryHandler qh = (QueryHandler)((Map.Entry)iter.next()).getValue();
                if (qh.getReplyHandler() != handler) continue;
                toRemove.add((Object)qh.getGUID());
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                map.remove((Object)((GUID)iter.next()));
            }
        }
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(400L);
                this.processQueries();
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueries() {
        QueryHandler qh;
        Iterator iter;
        Map map;
        if (!_done) {
            return;
        }
        _done = false;
        List list = this.NEW_QUERIES;
        synchronized (list) {
            map = this.QUERIES;
            synchronized (map) {
                iter = this.NEW_QUERIES.iterator();
                while (iter.hasNext()) {
                    qh = (QueryHandler)iter.next();
                    this.QUERIES.put((Object)qh.getGUID(), (Object)qh);
                }
            }
            this.NEW_QUERIES.clear();
        }
        LinkedList expiredQueries = new LinkedList();
        map = this.QUERIES;
        synchronized (map) {
            iter = this.QUERIES.entrySet().iterator();
            while (iter.hasNext()) {
                QueryHandler handler = (QueryHandler)((Map.Entry)iter.next()).getValue();
                if (this.TO_REMOVE.contains((Object)handler.getGUID())) {
                    this.TO_REMOVE.remove((Object)handler.getGUID());
                    expiredQueries.add((Object)handler);
                } else {
                    handler.sendQuery();
                }
                if (!handler.hasEnoughResults()) continue;
                expiredQueries.add((Object)handler);
            }
            iter = expiredQueries.iterator();
            while (iter.hasNext()) {
                qh = (QueryHandler)iter.next();
                this.QUERIES.remove((Object)qh.getGUID());
            }
        }
        _done = true;
    }

    public void addToRemove(GUID g) {
        this.TO_REMOVE.add((Object)g);
    }
}

