/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;

public final class ThemeSettings
extends LimeProps {
    public static final String EXTENSION = "lwtp";
    public static final File THEME_DIR_FILE;
    public static final String DEFAULT_THEME_NAME = "default_theme.lwtp";
    public static final String DEFAULT_OSX_THEME_NAME = "default_osx_theme.lwtp";
    public static final String WINDOWS_LAF_THEME_NAME = "windows_theme.lwtp";
    public static final String DEFAULT_PRO_THEME_NAME = "limewirePro_theme.lwtp";
    public static final String LIMEWIRE_THEME_NAME = "limewire_theme.lwtp";
    static final File DEFAULT_THEME_FILE;
    static final File DEFAULT_OSX_THEME_FILE;
    static final File WINDOWS_LAF_THEME_FILE;
    static final File DEFAULT_PRO_THEME_FILE;
    public static final FileSetting THEME_DEFAULT;
    public static final FileSetting THEME_DEFAULT_DIR;
    public static final FileSetting THEME_FILE;
    public static final FileSetting THEME_DIR;
    static /* synthetic */ Class class$com$limegroup$gnutella$settings$ThemeSettings;

    private ThemeSettings() {
    }

    private static void copyZipWithNewTimestamp(String name, File themeFile) {
        CommonUtils.copyResourceFile(name, themeFile, true);
        File themeDir = ThemeSettings.extractThemeDir(themeFile);
        ThemeSettings.expandTheme(themeFile, themeDir, true);
    }

    static void expandTheme(File themeFile, File themeDir, boolean overwrite) {
        themeDir.mkdirs();
        try {
            FileUtils.setWriteable(themeDir);
            Expand.expandFile(themeFile, themeDir, overwrite);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
    }

    static File extractThemeDir(File themeFile) {
        String dirName = themeFile.getName();
        dirName = dirName.substring(0, dirName.length() - 5);
        return new File(new File(CommonUtils.getUserSettingsDir(), "themes"), dirName);
    }

    static boolean isThemeFile(File f) {
        return f.getName().toLowerCase().endsWith(".lwtp");
    }

    public static boolean isDefaultTheme() {
        return THEME_FILE.getValue().equals(THEME_DEFAULT.getValue());
    }

    public static boolean isWindowsTheme() {
        return THEME_FILE.getValue().equals(WINDOWS_LAF_THEME_FILE);
    }

    public static boolean isNativeOSXTheme() {
        return CommonUtils.isMacOSX() && ThemeSettings.isDefaultTheme();
    }

    public static boolean isNativeTheme() {
        return ThemeSettings.isNativeOSXTheme() || ThemeSettings.isWindowsTheme();
    }

    public static String formatName(String name) {
        name = name.substring(0, name.length() - 5);
        StringBuffer formatted = new StringBuffer(name.length());
        StringTokenizer st = new StringTokenizer(name, "_");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            formatted.append(" " + next.substring(0, 1).toUpperCase(Locale.US));
            if (next.length() <= 1) continue;
            formatted.append(next.substring(1));
        }
        return formatted.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block13: {
            ThemeSettings.THEME_DIR_FILE = new File(CommonUtils.getUserSettingsDir(), "themes");
            ThemeSettings.DEFAULT_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "default_theme.lwtp");
            ThemeSettings.DEFAULT_OSX_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "default_osx_theme.lwtp");
            ThemeSettings.WINDOWS_LAF_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "windows_theme.lwtp");
            ThemeSettings.DEFAULT_PRO_THEME_FILE = new File(ThemeSettings.THEME_DIR_FILE, "limewirePro_theme.lwtp");
            themesJar = new File("themes.jar");
            if (!themesJar.isFile() && (url = (ThemeSettings.class$com$limegroup$gnutella$settings$ThemeSettings == null ? (ThemeSettings.class$com$limegroup$gnutella$settings$ThemeSettings = ThemeSettings.class$("com.limegroup.gnutella.settings.ThemeSettings")) : ThemeSettings.class$com$limegroup$gnutella$settings$ThemeSettings).getClassLoader().getResource("default_theme.lwtp").toString()) != null && url.startsWith("jar:file:")) {
                url = url.substring("jar:file:".length(), url.length());
                url = url.substring(0, url.length() - "default_theme.lwtp".length() - "!/".length());
                themesJar = new File(url);
            }
            if (themesJar.isFile()) {
                zf = null;
                try {
                    try {
                        jarMod = themesJar.lastModified();
                        zf = new ZipFile(themesJar);
                        entries = zf.entries();
                        while (entries.hasMoreElements()) {
                            ze = entries.nextElement();
                            name = ze.getName();
                            if (!name.endsWith(".lwtp")) continue;
                            existingFile = new File(ThemeSettings.THEME_DIR_FILE, name);
                            if (existingFile.isFile()) {
                                if (jarMod <= existingFile.lastModified()) continue;
                                ThemeSettings.copyZipWithNewTimestamp(name, existingFile);
                                continue;
                            }
                            if (existingFile.exists()) continue;
                            ThemeSettings.copyZipWithNewTimestamp(name, existingFile);
                        }
                        var9_8 = null;
                        if (zf == null) break block13;
                    }
                    catch (IOException ioe) {
                        ErrorService.error(ioe);
                        var9_9 = null;
                        if (zf != null) {
                            try {
                                zf.close();
                            }
                            catch (IOException ignored) {}
                        }
                        break block13;
                    }
                }
                catch (Throwable var8_14) {
                    var9_10 = null;
                    if (zf == null) throw var8_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 345->352)] { 
lbl48:
                    // 1 sources

                    zf.close();
                    throw var8_14;
lbl50:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var8_14;
                }
                try {}
                catch (IOException ignored) {}
                zf.close();
            }
        }
        ThemeSettings.THEME_DEFAULT = ThemeSettings.FACTORY.createFileSetting("THEME_DEFAULT", CommonUtils.isMacOSX() != false ? ThemeSettings.DEFAULT_OSX_THEME_FILE : (CommonUtils.isPro() != false ? ThemeSettings.DEFAULT_PRO_THEME_FILE : ThemeSettings.DEFAULT_THEME_FILE));
        ThemeSettings.THEME_DEFAULT_DIR = ThemeSettings.FACTORY.createFileSetting("THEME_DEFAULT_DIR", CommonUtils.isMacOSX() != false ? new File(ThemeSettings.THEME_DIR_FILE, "default_osx_theme") : new File(ThemeSettings.THEME_DIR_FILE, "default_theme"));
        ThemeSettings.THEME_FILE = ThemeSettings.FACTORY.createFileSetting("THEME_FILE", ThemeSettings.THEME_DEFAULT.getValue());
        ThemeSettings.THEME_DIR = ThemeSettings.FACTORY.createFileSetting("THEME_DIR", ThemeSettings.THEME_DEFAULT_DIR.getValue());
    }
}

