/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.Statistic;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;

public final class StatisticsManager
implements Runnable {
    private volatile List BASIC_STATS = new LinkedList();
    private volatile List ADVANCED_STATS = new LinkedList();
    private volatile List NUMERICAL_STATS = new LinkedList();
    private volatile boolean _recordAdvancedStatistics;
    private static final StatisticsManager INSTANCE = new StatisticsManager();

    public static StatisticsManager instance() {
        return INSTANCE;
    }

    private StatisticsManager() {
        RouterService.schedule(this, 0L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBasicStatistic(Statistic stat) {
        List list = this.BASIC_STATS;
        synchronized (list) {
            this.BASIC_STATS.add((Object)stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAdvancedStatistic(Statistic stat) {
        List list = this.ADVANCED_STATS;
        synchronized (list) {
            this.ADVANCED_STATS.add((Object)stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNumericalStatistic(Statistic stat) {
        List list = this.NUMERICAL_STATS;
        synchronized (list) {
            this.NUMERICAL_STATS.add((Object)stat);
        }
    }

    public void setRecordAdvancedStats(boolean record) {
        this._recordAdvancedStatistics = record;
    }

    public boolean getRecordAdvancedStats() {
        return this._recordAdvancedStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                Statistic stat;
                List list = this.BASIC_STATS;
                synchronized (list) {
                    Iterator iter = this.BASIC_STATS.iterator();
                    while (iter.hasNext()) {
                        stat = (Statistic)iter.next();
                        stat.storeCurrentStat();
                    }
                }
                if (!this._recordAdvancedStatistics) break block10;
                list = this.ADVANCED_STATS;
                synchronized (list) {
                    Iterator advancedIter = this.ADVANCED_STATS.iterator();
                    while (advancedIter.hasNext()) {
                        stat = (Statistic)advancedIter.next();
                        stat.storeCurrentStat();
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

