/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache
implements Serializable {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final transient Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$TigerTreeCache == null ? (class$com$limegroup$gnutella$tigertree$TigerTreeCache = TigerTreeCache.class$("com.limegroup.gnutella.tigertree.TigerTreeCache")) : class$com$limegroup$gnutella$tigertree$TigerTreeCache));
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$TigerTreeCache;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fd) {
        HashTree tree = (HashTree)TREE_MAP.get((Object)fd.getSHA1Urn());
        if (tree == null) {
            QUEUE.add(new HashRunner(fd));
        }
        return tree;
    }

    public synchronized HashTree getHashTree(URN sha1) {
        HashTree tree = (HashTree)TREE_MAP.get((Object)sha1);
        return tree;
    }

    public synchronized void purgeTree(URN sha1) {
        TREE_MAP.remove((Object)sha1);
    }

    public static synchronized void addHashTree(URN sha1, HashTree tree) {
        if (tree.isGoodDepth()) {
            TREE_MAP.put((Object)sha1, (Object)tree);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + sha1 + ";" + tree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + sha1 + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        ois = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(TigerTreeCache.CACHE_FILE));
                var1_1 = (Map)ois.readObject();
                var4_10 = null;
                if (ois == null) return var1_1;
            }
            catch (IOException e) {
                var2_30 = new HashMap();
                var4_11 = null;
                if (ois == null) return var2_30;
                try {
                    ois.close();
                    return var2_30;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var2_30;
            }
            catch (ClassCastException e) {
                var2_31 = new HashMap();
                var4_12 = null;
                if (ois == null) return var2_31;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl27:
                // 1 sources

                ois.close();
                return var2_31;
lbl29:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_31;
            }
            catch (ClassNotFoundException e) {
                var2_32 = new HashMap();
                var4_13 = null;
                if (ois == null) return var2_32;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl38:
                // 1 sources

                ois.close();
                return var2_32;
lbl40:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_32;
            }
            catch (ArrayStoreException e) {
                var2_33 = new HashMap();
                var4_14 = null;
                if (ois == null) return var2_33;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl49:
                // 1 sources

                ois.close();
                return var2_33;
lbl51:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_33;
            }
            catch (IndexOutOfBoundsException e) {
                var2_34 = new HashMap();
                var4_15 = null;
                if (ois == null) return var2_34;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl60:
                // 1 sources

                ois.close();
                return var2_34;
lbl62:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_34;
            }
            catch (NegativeArraySizeException e) {
                var2_35 = new HashMap();
                var4_16 = null;
                if (ois == null) return var2_35;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl71:
                // 1 sources

                ois.close();
                return var2_35;
lbl73:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_35;
            }
            catch (IllegalStateException e) {
                var2_36 = new HashMap();
                var4_17 = null;
                if (ois == null) return var2_36;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl82:
                // 1 sources

                ois.close();
                return var2_36;
lbl84:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_36;
            }
            catch (SecurityException e) {
                var2_37 = new HashMap();
                var4_18 = null;
                if (ois == null) return var2_37;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl93:
                // 1 sources

                ois.close();
                return var2_37;
lbl95:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var2_37;
            }
        }
        catch (Throwable var3_38) {
            var4_19 = null;
            if (ois == null) throw var3_38;
            try {}
            catch (IOException e) {
                throw var3_38;
            }
            ois.close();
            throw var3_38;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var1_1;
        }
        ois.close();
        return var1_1;
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            URN sha1 = (URN)iter.next();
            if (RouterService.getFileManager().getFileDescForUrn(sha1) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(sha1) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove((Object)sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        TigerTreeCache.removeOldEntries(TREE_MAP);
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(CACHE_FILE));
        oos.writeObject(TREE_MAP);
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (Exception e) {
                ErrorService.error(e);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fd) {
            this.FD = fd;
        }

        public void run() {
            try {
                URN sha1 = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(sha1) == null) {
                    HashTree tree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(sha1, tree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

