/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.updates.UpdateFileParser;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.xml.sax.SAXException;

public class UpdateMessageVerifier {
    private byte[] data;
    private byte[] signature;
    private byte[] xmlMessage;
    private boolean fromDisk;
    private static boolean testing118 = false;

    public UpdateMessageVerifier(byte[] fromStream, boolean fromDisk) {
        if (fromStream == null) {
            throw new IllegalArgumentException();
        }
        this.data = fromStream;
        this.fromDisk = fromDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean verifySource() {
        PublicKey pubKey;
        block34: {
            IOException e2222;
            ObjectInputStream ois;
            FileInputStream fis;
            block29: {
                boolean parsed = this.parse();
                if (!parsed) {
                    return false;
                }
                if (CommonUtils.isJava118()) {
                    if (this.fromDisk) {
                        return true;
                    }
                    return this.checkVersionForJava118();
                }
                pubKey = null;
                fis = null;
                ois = null;
                File file = new File(CommonUtils.getUserSettingsDir(), "public.key");
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                pubKey = (PublicKey)ois.readObject();
                Object var8_11 = null;
                if (ois == null) break block29;
                try {
                    ois.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e2222) {}
            }
            break block34;
            {
                catch (ClassNotFoundException cnfx) {
                    IOException e2222;
                    boolean bl = false;
                    Object var8_12 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                catch (IOException iox) {
                    IOException e2222;
                    boolean bl;
                    block32: {
                        try {
                            bl = false;
                            Object var8_13 = null;
                            if (ois == null) break block32;
                        }
                        catch (Throwable throwable) {
                            IOException e2222;
                            Object var8_14 = null;
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException e2222) {
                                    // empty catch block
                                }
                            }
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException e2222) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        try {
                            ois.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
        }
        try {
            Signature verifier = Signature.getInstance("DSA");
            verifier.initVerify(pubKey);
            verifier.update(this.xmlMessage, 0, this.xmlMessage.length);
            return verifier.verify(this.signature);
        }
        catch (NoSuchAlgorithmException nsax) {
            ErrorService.error(nsax);
            return false;
        }
        catch (InvalidKeyException ikx) {
            return false;
        }
        catch (SignatureException sx) {
            return false;
        }
    }

    private boolean parse() {
        int i = this.findPipe(0);
        int j = this.findPipe(i + 1);
        if (i < 0 || j < 0) {
            return false;
        }
        if (this.data.length - j < 10) {
            return false;
        }
        byte[] temp = new byte[i];
        System.arraycopy(this.data, 0, temp, 0, i);
        String base32 = new String(temp);
        this.signature = Base32.decode(base32);
        this.xmlMessage = new byte[this.data.length - 1 - j];
        System.arraycopy(this.data, j + 1, this.xmlMessage, 0, this.data.length - 1 - j);
        return true;
    }

    private int findPipe(int startIndex) {
        int i;
        int b = -1;
        boolean found = false;
        for (i = startIndex; i < this.data.length; ++i) {
            if (this.data[i] != 124) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private boolean checkVersionForJava118() {
        ConnectionManager connManager = RouterService.getConnectionManager();
        if (!testing118 && !connManager.isShieldedLeaf()) {
            return false;
        }
        UpdateFileParser parser = null;
        String xml = null;
        try {
            xml = new String(this.getMessageBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            return false;
        }
        try {
            parser = new UpdateFileParser(xml);
        }
        catch (SAXException sx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        String version = parser.getVersion();
        if (version == null || version.equals("")) {
            return false;
        }
        Iterator iter = connManager.getConnections().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Connection c = (Connection)iter.next();
            String v = c.getVersion();
            if (!version.equals(v)) continue;
            ++count;
        }
        return count >= 3;
    }

    public byte[] getMessageBytes() throws IllegalStateException {
        if (this.xmlMessage == null) {
            throw new IllegalStateException();
        }
        return this.xmlMessage;
    }
}

