/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;

public class LimitReachedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();

    public LimitReachedUploadState(HTTPUploader uploader) {
        this.UPLOADER = uploader;
        this.FILE_DESC = uploader.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        String str = "HTTP/1.1 503 Service Unavailable\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        ostream.write(str.getBytes());
        if (this.FILE_DESC != null) {
            URN sha1 = this.FILE_DESC.getSHA1Urn();
            if (sha1 != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, ostream);
                Set alts = this.UPLOADER.getNextSetOfAltsToSend();
                if (alts.size() > 0) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)alts), ostream);
                }
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, alts.size() == 0 ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER, ostream);
                ostream.write(str.getBytes());
                if (this.FILE_DESC instanceof IncompleteFileDesc) {
                    HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), ostream);
                }
            } else {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, NO_ALT_LOCS_RETRY_AFTER, ostream);
            }
        }
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, ostream);
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }
}

