/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Map;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;

public final class PushProxyUploadState
implements HTTPMessage {
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    private final HTTPUploader _uploader;
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public PushProxyUploadState(HTTPUploader uploader) {
        this._uploader = uploader;
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        byte[] clientGUID = GUID.fromHexString(this._uploader.getFileName());
        InetAddress hostAddress = this._uploader.getNodeAddress();
        int hostPort = this._uploader.getNodePort();
        if (clientGUID.length != 16 || hostAddress == null || !NetworkUtils.isValidPort(hostPort) || !NetworkUtils.isValidAddress(hostAddress)) {
            String str = "HTTP/1.1 400 Push Proxy: Bad Request\r\n\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this.debug("PPUS.doUpload(): unknown host.");
            UploadStat.PUSH_PROXY_REQ_BAD.incrementStat();
            return;
        }
        Map params = this._uploader.getParameters();
        int fileIndex = 0;
        Object index = params.get((Object)P_FILE);
        if (index != null) {
            fileIndex = (Integer)index;
        }
        PushRequest push = new PushRequest(GUID.makeGuid(), 0, clientGUID, fileIndex, hostAddress.getAddress(), hostPort);
        try {
            RouterService.getMessageRouter().sendPushRequest(push);
        }
        catch (IOException ioe) {
            String str = "HTTP/1.1 410 Push Proxy: Servent not connected\r\n\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this.debug("PPUS.doUpload(): push failed.");
            this.debug(ioe);
            UploadStat.PUSH_PROXY_REQ_FAILED.incrementStat();
            return;
        }
        UploadStat.PUSH_PROXY_REQ_SUCCESS.incrementStat();
        String str = "HTTP/1.1 202 Push Proxy: Message Sent\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: application/x-gnutella-packets\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + this.BAOS.size() + "\r\n";
        ostream.write(str.getBytes());
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(this.BAOS.toByteArray());
        this._uploader.setAmountUploaded(this.BAOS.size());
        this.debug("PPUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception out) {
    }
}

