/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Expand {
    private Expand() {
    }

    public static void expandFile(File source, File dest) throws IOException {
        Expand.expandFile(source, dest, false);
    }

    public static void expandFile(File source, File dest, boolean overwrite) throws IOException {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(source));
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            File f = new File(dest, ze.getName());
            File dirF = new File(f.getParent());
            dirF.mkdirs();
            if (ze.isDirectory()) {
                f.mkdirs();
                continue;
            }
            if (ze.getTime() <= f.lastModified() && !overwrite) continue;
            FileUtils.setWriteable(f);
            byte[] buffer = new byte[1024];
            int length = 0;
            FileOutputStream fos = new FileOutputStream(f);
            while ((length = zis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fos.close();
        }
        zis.close();
    }
}

