/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SystemUtils;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final Set UNWRITEABLE = Collections.synchronizedSet((Set)new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMap(String filename, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(filename));
            out.writeObject(map);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(filename));
            Map map = (Map)in.readObject();
            return map;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static File[] listFiles(File f) {
        String[] children = f.list();
        if (children == null) {
            return null;
        }
        File[] ret = new File[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = new File(f, children[i]);
        }
        return ret;
    }

    public static File[] listFiles(File f, FilenameFilter filter) {
        String[] children = f.list(filter);
        if (children == null) {
            return null;
        }
        File[] ret = new File[children.length];
        for (int i = 0; i < children.length; ++i) {
            ret[i] = new File(f, children[i]);
        }
        return ret;
    }

    public static File getParentFile(File f) {
        String name = f.getParent();
        if (name == null) {
            return null;
        }
        try {
            return FileUtils.getCanonicalFile(new File(name));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        if (index == name.length() - 1) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (f.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        if (UNWRITEABLE.contains((Object)fName)) {
            return false;
        }
        String[] cmds = null;
        if (CommonUtils.isWindows()) {
            SystemUtils.setWriteable(fName);
        } else {
            cmds = CommonUtils.isMacClassic() ? null : (CommonUtils.isOS2() ? null : (f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName}));
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!f.canWrite()) {
            UNWRITEABLE.add((Object)fName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void touch(File f) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            Object var3_2 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (fos == null) throw throwable;
            try {
                ((OutputStream)fos).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)fos).close();
            return;
        }
        catch (IOException ignored) {}
    }
}

