/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class FixedSizeExpiringSet
implements Set,
Collection {
    private static final int DEFAULT_SIZE = 50;
    private static final long DEFAULT_EXPIRE_TIME = 600000L;
    private final int _maxSize;
    private final long _expireTime;
    private Map _map;

    public FixedSizeExpiringSet() {
        this(50);
    }

    public FixedSizeExpiringSet(int size) {
        this(size, 600000L);
    }

    public FixedSizeExpiringSet(int size, long expireTime) {
        this._maxSize = size;
        this._expireTime = expireTime;
        this._map = new HashMap();
    }

    public int size() {
        this.expire(false);
        return this._map.size();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean contains(Object arg0) {
        Long time = (Long)this._map.get(arg0);
        if (time == null) {
            return false;
        }
        if (time < System.currentTimeMillis()) {
            this._map.remove(arg0);
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        this.expire(false);
        return this._map.keySet().iterator();
    }

    public Object[] toArray() {
        this.expire(false);
        return this._map.keySet().toArray();
    }

    public Object[] toArray(Object[] arg0) {
        this.expire(false);
        return this._map.keySet().toArray(arg0);
    }

    public boolean add(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        this.expire(this.size() >= this._maxSize);
        if (this._map.containsKey(arg0)) {
            return false;
        }
        this._map.put(arg0, (Object)new Long(System.currentTimeMillis() + this._expireTime));
        return true;
    }

    public boolean remove(Object arg0) {
        return this._map.remove(arg0) != null;
    }

    public boolean containsAll(Collection arg0) {
        return this._map.keySet().containsAll(arg0);
    }

    public boolean addAll(Collection coll) {
        if (coll.isEmpty()) {
            return false;
        }
        Iterator iter = coll.iterator();
        for (int i = 0; i < this._maxSize && iter.hasNext(); ++i) {
            this.add(iter.next());
        }
        return true;
    }

    public boolean retainAll(Collection arg0) {
        HashMap map = new HashMap();
        boolean ret = false;
        Iterator iter = this._map.keySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (arg0.contains(o)) {
                map.put(o, this._map.get(o));
                continue;
            }
            ret = true;
        }
        if (ret) {
            this._map = map;
        }
        return ret;
    }

    public boolean removeAll(Collection arg0) {
        if (arg0.isEmpty()) {
            return false;
        }
        boolean ret = false;
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            ret |= this.remove(iter.next());
        }
        return ret;
    }

    public void clear() {
        this._map.clear();
    }

    private void expire(boolean forceRemove) {
        if (this._map.size() == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long min = Long.MAX_VALUE;
        Object oldest = null;
        HashSet expired = new HashSet();
        Iterator iter = this._map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Long l = (Long)this._map.get(key);
            long time = l;
            if (time < now) {
                expired.add(key);
                forceRemove = false;
                continue;
            }
            if (!forceRemove || time >= min) continue;
            min = time;
            oldest = key;
        }
        if (expired.size() > 0) {
            this.removeAll((Collection)expired);
        }
        if (forceRemove) {
            this.remove(oldest);
        }
    }
}

