/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.SortedSet;
import com.sun.java.util.collections.TreeSet;

public class FixedsizePriorityQueue {
    private SortedSet tree;
    private int capacity;
    private Comparator comparator;
    private static int nextID = 0;
    static boolean DEBUG = false;

    public FixedsizePriorityQueue(Comparator comparator, int capacity) throws IllegalArgumentException {
        this.comparator = comparator;
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.tree = new TreeSet();
        this.capacity = capacity;
    }

    public Object insert(Object x) {
        this.repOk();
        Node node = new Node(x);
        if (this.size() < this.capacity()) {
            boolean added = this.tree.add((Object)node);
            Assert.that(added);
            this.repOk();
            return null;
        }
        Node smallest = (Node)this.tree.first();
        if (node.compareTo(smallest) > 0) {
            this.tree.remove((Object)smallest);
            boolean added = this.tree.add((Object)node);
            Assert.that(added);
            this.repOk();
            return smallest.getData();
        }
        this.repOk();
        return x;
    }

    public Object getMax() throws NoSuchElementException {
        return ((Node)this.tree.last()).getData();
    }

    public Object getMin() throws NoSuchElementException {
        return ((Node)this.tree.first()).getData();
    }

    public boolean contains(Object o) {
        Iterator iter = this.tree.iterator();
        while (iter.hasNext()) {
            if (!o.equals(((Node)iter.next()).getData())) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        Iterator iter = this.tree.iterator();
        while (iter.hasNext()) {
            if (!o.equals(((Node)iter.next()).getData())) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new DataIterator();
    }

    public int size() {
        return this.tree.size();
    }

    public int capacity() {
        return this.capacity;
    }

    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        Assert.that(this.size() <= this.capacity());
        Iterator iter = this.tree.iterator();
        while (iter.hasNext()) {
            Assert.that(iter.next() instanceof Node);
        }
    }

    public String toString() {
        return this.tree.toString();
    }

    private class DataIterator
    implements Iterator {
        Iterator delegate;

        private DataIterator() {
            this.delegate = FixedsizePriorityQueue.this.tree.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return ((Node)this.delegate.next()).getData();
        }

        public void remove() {
            this.delegate.remove();
        }
    }

    private class Node
    implements Comparable {
        private Object data;
        private int myID;

        Node(Object data) {
            this.data = data;
            this.myID = nextID++;
        }

        public Object getData() {
            return this.data;
        }

        public int compareTo(Object o) {
            Node other = (Node)o;
            int c = FixedsizePriorityQueue.this.comparator.compare(this.getData(), other.getData());
            if (c != 0) {
                return c;
            }
            return this.myID - other.myID;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

