/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class IOUtils {
    public static boolean handleException(IOException ioe, String friendly) {
        if (friendly == null) {
            friendly = "GENERIC";
        }
        return IOUtils.handle(ioe, friendly);
    }

    private static boolean handle(Throwable e, String friendly) {
        while (e != null) {
            String msg = e.getMessage();
            if (msg != null) {
                if (StringUtils.contains(msg = msg.toLowerCase(), "no space left") || StringUtils.contains(msg, "not enough space")) {
                    MessageService.showError("ERROR_DISK_FULL_" + friendly);
                    return true;
                }
                if (StringUtils.contains(msg, "being used by another process")) {
                    MessageService.showError("ERROR_LOCKED_BY_PROCESS_" + friendly);
                    return true;
                }
                if (StringUtils.contains(msg, "access is denied") || StringUtils.contains(msg, "permission denied")) {
                    MessageService.showError("ERROR_ACCESS_DENIED_" + friendly);
                    return true;
                }
                if (StringUtils.contains(msg, "invalid argument")) {
                    MessageService.showError("ERROR_INVALID_NAME_" + friendly);
                    return true;
                }
            }
            e = null;
        }
        return false;
    }

    public static String readWord(InputStream in, int maxSize) throws IOException {
        char[] buf = new char[maxSize];
        int i = 0;
        try {
            int got;
            while ((got = in.read()) >= 0) {
                if ((char)got != ' ') {
                    if (i < maxSize) {
                        buf[i++] = (char)got;
                        continue;
                    }
                    throw new IOException("could not read word");
                }
                return new String(buf, 0, i);
            }
            throw new IOException("unexpected end of file");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static String readLargestWord(InputStream in, int maxSize) throws IOException {
        char[] buf = new char[maxSize];
        int i = 0;
        try {
            block5: {
                block6: {
                    while (true) {
                        int got;
                        if ((got = in.read()) == -1) {
                            if (i == 0) {
                                throw new IOException("could not read any word.");
                            }
                            return new String(buf, 0, i);
                        }
                        if (got < 0) break block5;
                        if ((char)got == ' ') break block6;
                        if (i >= maxSize) break;
                        buf[i++] = (char)got;
                    }
                    throw new IOException("could not read word");
                }
                return new String(buf, 0, i);
            }
            throw new IOException("unknown got amount");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static long ensureSkip(InputStream in, long length) throws IOException {
        long skipped;
        long current;
        for (skipped = 0L; skipped < length; skipped += current) {
            current = in.skip(length - skipped);
            if (current != -1L && current != 0L) continue;
            throw new EOFException("eof");
        }
        return skipped;
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Socket s) {
        if (s != null) {
            try {
                IOUtils.close(s.getInputStream());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                IOUtils.close(s.getOutputStream());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflate(byte[] data) {
        byte[] byArray;
        DeflaterOutputStream dos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DeflaterOutputStream(baos);
            ((OutputStream)dos).write(data, 0, data.length);
            ((OutputStream)dos).close();
            byArray = baos.toByteArray();
        }
        catch (IOException impossible) {
            byte[] byArray2;
            try {
                ErrorService.error(impossible);
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(dos);
                throw throwable;
            }
            IOUtils.close(dos);
            return byArray2;
        }
        IOUtils.close(dos);
        return byArray;
    }

    public static byte[] inflate(byte[] data) throws IOException {
        byte[] byArray;
        InflaterInputStream in = null;
        try {
            int read;
            in = new InflaterInputStream(new ByteArrayInputStream(data));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[64];
            while ((read = ((InputStream)in).read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, read);
            }
            byArray = out.toByteArray();
        }
        catch (OutOfMemoryError oome) {
            try {
                throw new IOException(oome.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
        }
        IOUtils.close(in);
        return byArray;
    }
}

