/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.sun.java.util.collections.Comparator;
import java.net.InetAddress;

public interface IpPort {
    public static final Comparator COMPARATOR = new IpPortComparator();

    public InetAddress getInetAddress();

    public int getPort();

    public String getAddress();

    public static class IpPortComparator
    implements Comparator {
        public int compare(Object a, Object b) {
            if (a == b) {
                return 0;
            }
            IpPort ip1 = (IpPort)a;
            IpPort ip2 = (IpPort)b;
            int diff = ip1.getPort() - ip2.getPort();
            if (diff == 0) {
                byte[] netb;
                byte[] neta = ip1.getInetAddress().getAddress();
                if (neta[0] == (netb = ip2.getInetAddress().getAddress())[0]) {
                    if (neta[1] == netb[1]) {
                        if (neta[2] == netb[2]) {
                            if (neta[3] == netb[3]) {
                                return 0;
                            }
                            return neta[3] - netb[3];
                        }
                        return neta[2] - netb[2];
                    }
                    return neta[1] - netb[1];
                }
                return neta[0] - netb[0];
            }
            return diff;
        }
    }
}

