/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.BinaryHeap;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.SimpleTimerTask;
import com.sun.java.util.collections.Comparable;

public class SimpleTimer {
    private BinaryHeap _queue = new BinaryHeap(4, true);
    private static final int INITIAL_HEAP_SIZE = 4;
    private TimerRunnerThread _runner;
    private volatile boolean _isCancelled = false;

    public SimpleTimer(boolean isDaemon) {
        this._runner = new TimerRunnerThread(isDaemon);
        this._runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable task, long delay, long period) throws IllegalStateException {
        if (this._isCancelled) {
            throw new IllegalStateException("Timer cancelled");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Negative period: " + period);
        }
        long now = System.currentTimeMillis();
        SimpleTimerTask ttask = new SimpleTimerTask(task, period, now + delay);
        BinaryHeap binaryHeap = this._queue;
        synchronized (binaryHeap) {
            Comparable discarded = this._queue.insert(ttask);
            Assert.that(discarded == null, "heap didn't resize");
            this._queue.notify();
        }
    }

    public void cancel() {
        this._isCancelled = true;
        this._runner.interrupt();
    }

    private class TimerRunnerThread
    extends ManagedThread {
        TimerRunnerThread(boolean isDaemon) {
            super("TimerRunner");
            this.setDaemon(isDaemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void managedRun() {
            try {
                while (!SimpleTimer.this._isCancelled) {
                    SimpleTimerTask ttask = null;
                    try {
                        ttask = this.waitForTask();
                        if (ttask == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        Assert.that(SimpleTimer.this._isCancelled, "Interrupted without cancel");
                        return;
                    }
                    if (!ttask.runAndReschedule()) continue;
                    BinaryHeap binaryHeap = SimpleTimer.this._queue;
                    synchronized (binaryHeap) {
                        SimpleTimer.this._queue.insert(ttask);
                    }
                }
                return;
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SimpleTimerTask waitForTask() throws InterruptedException {
            BinaryHeap binaryHeap = SimpleTimer.this._queue;
            synchronized (binaryHeap) {
                if (SimpleTimer.this._queue.isEmpty()) {
                    SimpleTimer.this._queue.wait();
                    return null;
                }
                SimpleTimerTask task = (SimpleTimerTask)SimpleTimer.this._queue.getMax();
                long time = task.timeUntilExecution();
                if (time > 0L) {
                    SimpleTimer.this._queue.wait(time);
                    return null;
                }
                SimpleTimerTask task2 = (SimpleTimerTask)SimpleTimer.this._queue.extractMax();
                Assert.that(task2 == task, "Queue modified without lock");
                return task;
            }
        }
    }
}

