/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Sockets {
    private static Constructor _inetAddressConstructor;
    private static Class _socketClass;
    private static Class _socketAddressClass;
    private static Method _setKeepAliveMethod;
    private static Method _connectMethod;
    private static volatile int _attempts;
    static /* synthetic */ Class class$java$lang$String;

    private Sockets() {
    }

    public static int getAttempts() {
        return _attempts;
    }

    public static void clearAttempts() {
        _attempts = 0;
    }

    public static boolean setKeepAlive(Socket socket, boolean on) {
        if (CommonUtils.isJava13OrLater()) {
            try {
                _setKeepAliveMethod.invoke((Object)socket, on ? Boolean.TRUE : Boolean.FALSE);
                return true;
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Socket connect(String host, int port, int timeout) throws IOException {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        int connectionType = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (connectionType != 0) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new IOException();
            }
            if (!NetworkUtils.isPrivateAddress(address) || ConnectionSettings.USE_PROXY_FOR_PRIVATE.getValue()) {
                if (connectionType == 1) {
                    return Sockets.connectHTTP(host, port, timeout);
                }
                if (connectionType == 4) {
                    return Sockets.connectSocksV4(host, port, timeout);
                }
                if (connectionType == 5) {
                    return Sockets.connectSocksV5(host, port, timeout);
                }
            }
        }
        ++_attempts;
        return Sockets.connectPlain(host, port, timeout);
    }

    private static Socket connectPlain(String host, int port, int timeout) throws IOException {
        if (CommonUtils.isJava14OrLater()) {
            try {
                Socket ret = (Socket)_socketClass.newInstance();
                Object addr = _inetAddressConstructor.newInstance(host, new Integer(port));
                _connectMethod.invoke((Object)ret, addr, new Integer(timeout));
                return ret;
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                if (!(e2 instanceof IOException)) {
                    ErrorService.error(e2);
                }
                throw (IOException)e2;
            }
            catch (InstantiationException e) {
                ErrorService.error(e);
            }
            catch (IllegalAccessException e) {
                ErrorService.error(e);
            }
        }
        if (timeout != 0) {
            return new SocketOpener(host, port).connect(timeout);
        }
        return new Socket(host, port);
    }

    private static Socket connectSocksV4(String host, int port, int timeout) throws IOException {
        byte[] hostBytes;
        try {
            hostBytes = InetAddress.getByName(host).getAddress();
        }
        catch (UnknownHostException e) {
            throw new IOException("invalid host name");
        }
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        String proxyHost = ConnectionSettings.PROXY_HOST.getValue();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream os = null;
        InputStream in = null;
        Socket proxySocket = Sockets.connectPlain(proxyHost, proxyPort, timeout);
        proxySocket.setSoTimeout(timeout);
        os = proxySocket.getOutputStream();
        in = proxySocket.getInputStream();
        os.write(4);
        os.write(1);
        os.write(portBytes);
        os.write(hostBytes);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            os.write(ConnectionSettings.PROXY_USERNAME.getValue().getBytes());
        }
        os.write(0);
        os.flush();
        int version = in.read();
        if (version != 0 && version != 4) {
            proxySocket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 0 or 4");
        }
        int status = in.read();
        if (status != 90) {
            proxySocket.close();
            throw new IOException("Request rejected with status: " + status);
        }
        byte[] connectedHostPort = new byte[2];
        byte[] connectedHostAddress = new byte[4];
        if (in.read(connectedHostPort) == -1 || in.read(connectedHostAddress) == -1) {
            proxySocket.close();
            throw new IOException("Connection failed");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    private static Socket connectSocksV5(String host, int port, int timeout) throws IOException {
        byte[] hostBytes;
        try {
            hostBytes = InetAddress.getByName(host).getAddress();
        }
        catch (UnknownHostException e) {
            throw new IOException("invalid host name");
        }
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        String proxyHost = ConnectionSettings.PROXY_HOST.getValue();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream os = null;
        InputStream in = null;
        Socket proxySocket = Sockets.connectPlain(proxyHost, proxyPort, timeout);
        proxySocket.setSoTimeout(timeout);
        os = proxySocket.getOutputStream();
        in = proxySocket.getInputStream();
        os.write(5);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            os.write(2);
            os.write(0);
            os.write(2);
        } else {
            os.write(1);
            os.write(0);
        }
        os.flush();
        int version = in.read();
        if (version != 5) {
            proxySocket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        int auth_method = in.read();
        if (auth_method != 0 && auth_method == 2) {
            String username = ConnectionSettings.PROXY_USERNAME.getValue();
            String password = ConnectionSettings.PROXY_PASS.getValue();
            os.write(1);
            os.write((byte)username.length());
            os.write(username.getBytes());
            os.write((byte)password.length());
            os.write(password.getBytes());
            os.flush();
            version = in.read();
            if (version != 1) {
                proxySocket.close();
                throw new IOException("Invalid version for authentication: " + version + " expected 1");
            }
            int status = in.read();
            if (status != 0) {
                proxySocket.close();
                throw new IOException("Authentication failed with status: " + status);
            }
        }
        os.write(5);
        os.write(1);
        os.write(0);
        os.write(1);
        os.write(hostBytes);
        os.write(portBytes);
        os.flush();
        version = in.read();
        if (version != 5) {
            proxySocket.close();
            throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
        }
        int status = in.read();
        if (status != 0) {
            proxySocket.close();
            throw new IOException("Request rejected with status: " + status);
        }
        in.read();
        int addrType = in.read();
        int bytesToSkip = 0;
        if (addrType == 1) {
            bytesToSkip = 6;
        } else if (addrType == 3) {
            bytesToSkip = in.read() + 2;
        } else if (addrType == 4) {
            bytesToSkip = 18;
        }
        for (int i = 0; i < bytesToSkip; ++i) {
            if (in.read() != -1) continue;
            throw new IOException("Connection failed");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    private static Socket connectHTTP(String host, int port, int timeout) throws IOException {
        String connectString = "CONNECT " + host + ":" + port + " HTTP/1.0\r\n\r\n";
        String proxyHost = ConnectionSettings.PROXY_HOST.getValue();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream os = null;
        InputStream in = null;
        Socket proxySocket = Sockets.connectPlain(proxyHost, proxyPort, timeout);
        proxySocket.setSoTimeout(timeout);
        os = proxySocket.getOutputStream();
        in = proxySocket.getInputStream();
        os.write(connectString.getBytes());
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        if (line == null || line.indexOf("200") == -1) {
            throw new IOException("HTTP connection failed");
        }
        while (!line.equals("")) {
            line = reader.readLine();
            if (line != null) continue;
            throw new IOException("end of stream");
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _attempts = 0;
        try {
            if (CommonUtils.isJava13OrLater()) {
                _socketClass = Class.forName("java.net.Socket");
                _setKeepAliveMethod = _socketClass.getMethod("setKeepAlive", Boolean.TYPE);
            }
            if (CommonUtils.isJava14OrLater()) {
                Class<?> socketAddress = Class.forName("java.net.InetSocketAddress");
                _inetAddressConstructor = socketAddress.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Sockets.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                _socketAddressClass = Class.forName("java.net.SocketAddress");
                _connectMethod = _socketClass.getMethod("connect", _socketAddressClass, Integer.TYPE);
            }
        }
        catch (Exception e) {
            ErrorService.error(e);
        }
    }

    private static class SocketOpener {
        private String host;
        private int port;
        private Socket socket = null;
        private boolean timedOut = false;
        private boolean completed = false;

        public SocketOpener(String host, int port) {
            if ((port & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("port out of range: " + port);
            }
            this.host = host;
            this.port = port;
        }

        public synchronized Socket connect(int timeout) throws IOException {
            ManagedThread t = new ManagedThread(new SocketOpenerThread(), "SocketOpener");
            t.setDaemon(true);
            t.start();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                if (this.socket == null) {
                    this.timedOut = true;
                } else {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw new IOException();
            }
            if (!this.completed) {
                t.interrupt();
            }
            if (this.socket != null) {
                return this.socket;
            }
            this.timedOut = true;
            throw new IOException();
        }

        private class SocketOpenerThread
        implements Runnable {
            private SocketOpenerThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    Socket sock = null;
                    try {
                        try {
                            sock = new Socket(SocketOpener.this.host, SocketOpener.this.port);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        SocketOpener e = SocketOpener.this;
                        synchronized (e) {
                            SocketOpener.this.completed = true;
                            if (SocketOpener.this.timedOut && sock != null) {
                                try {
                                    sock.close();
                                }
                                catch (IOException iOException) {}
                            } else {
                                SocketOpener.this.socket = sock;
                                SocketOpener.this.notify();
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) break block11;
                        ErrorService.error(t);
                    }
                }
            }
        }
    }
}

