/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.settings.ApplicationSettings;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.text.Collator;
import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtils {
    private static Collator _col = Collator.getInstance(new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue()));

    public static final boolean contains(String input, String pattern) {
        return StringUtils.contains(input, pattern, false);
    }

    public static final boolean contains(String input, String pattern, boolean ignoreCase) {
        int n = pattern.length();
        int last = 0;
        int i = 0;
        while (i < n) {
            int k;
            int j;
            int c = 32;
            for (j = i; j < n; ++j) {
                char c2 = pattern.charAt(j);
                if (c2 != ' ' && c2 != '+' && c2 != '*') continue;
                c = c2;
                break;
            }
            if ((k = StringUtils.subset(pattern, i, j, input, last, ignoreCase)) < 0) {
                return false;
            }
            if (c == 32 || c == 43) {
                last = 0;
            } else if (c == 42) {
                last = k + j - i;
            }
            i = j + 1;
        }
        return true;
    }

    private static final int subset(String little, int littleStart, int littleStop, String big, int bigStart, boolean ignoreCase) {
        if (ignoreCase) {
            int n = big.length() - (littleStop - littleStart) + 1;
            block0: for (int i = bigStart; i < n; ++i) {
                int n2 = littleStop - littleStart;
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c1 = big.charAt(i + j);
                    if (c1 != (c2 = little.charAt(littleStart + j)) && c1 != StringUtils.toOtherCase(c2)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n = big.length() - (littleStop - littleStart) + 1;
        block2: for (int i = bigStart; i < n; ++i) {
            int n2 = littleStop - littleStart;
            for (int j = 0; j < n2; ++j) {
                char c2;
                char c1 = big.charAt(i + j);
                if (c1 != (c2 = little.charAt(littleStart + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char i = c;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        int SHIFT = 32;
        if (i < 'A') {
            return c;
        }
        if (i <= 'Z') {
            return (char)(i + 32);
        }
        if (i < 'a') {
            return c;
        }
        if (i <= 'z') {
            return (char)(i - 32);
        }
        return c;
    }

    public static String[] split(String s, char delimeter) {
        return StringUtils.split(s, delimeter + "");
    }

    public static String[] split(String s, String delimeters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimeters);
        Vector buf = new Vector();
        while (tokenizer.hasMoreTokens()) {
            buf.add((Object)tokenizer.nextToken());
        }
        String[] ret = new String[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = (String)buf.get(i);
        }
        return ret;
    }

    public static String[] splitNoCoalesce(String s, char delimeter) {
        return StringUtils.splitNoCoalesce(s, delimeter + "");
    }

    public static String[] splitNoCoalesce(String s, String delimeters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimeters, true);
        Vector buf = new Vector();
        boolean gotDelimeter = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimeters.indexOf(token) >= 0) {
                if (gotDelimeter) {
                    buf.add((Object)"");
                }
                gotDelimeter = true;
                continue;
            }
            buf.add((Object)token);
            gotDelimeter = false;
        }
        if (gotDelimeter && !buf.isEmpty()) {
            buf.add((Object)"");
        }
        String[] ret = new String[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = (String)buf.get(i);
        }
        return ret;
    }

    public static int compareIgnoreCase(String s1, String s2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int lim = Math.min(n1, n2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = s1.charAt(k);
            if (c1 == (c2 = s2.charAt(k)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return n1 - n2;
    }

    public static int compareFullPrimary(String s1, String s2) {
        return _col.compare(s1, s2);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int pl = prefix.length();
        if (s.length() < pl) {
            return false;
        }
        for (int i = 0; i < pl; ++i) {
            char pc;
            char sc = s.charAt(i);
            if (sc == (pc = prefix.charAt(i)) || (sc = Character.toUpperCase(sc)) == (pc = Character.toUpperCase(pc)) || (sc = Character.toLowerCase(sc)) == (pc = Character.toLowerCase(pc))) continue;
            return false;
        }
        return true;
    }

    public static String getEntriesAsString(Collection collection) {
        StringBuffer buffer = new StringBuffer();
        boolean isFirstEntry = true;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object entry = iter.next();
            if (!isFirstEntry) {
                buffer.append(",");
            } else {
                isFirstEntry = false;
            }
            buffer.append(entry.toString());
        }
        return buffer.toString();
    }

    public static Set getSetofValues(String values) {
        HashSet valueSet = new HashSet();
        StringTokenizer st = new StringTokenizer(values, ",");
        while (st.hasMoreTokens()) {
            valueSet.add((Object)st.nextToken());
        }
        return valueSet;
    }

    public static String replace(String str, String old_str, String new_str) {
        int o = 0;
        StringBuffer buf = new StringBuffer();
        int i = str.indexOf(old_str);
        while (i > -1) {
            if (i > o) {
                buf.append(str.substring(o, i));
            }
            buf.append(new_str);
            o = i + old_str.length();
            i = str.indexOf(old_str, i + 1);
        }
        buf.append(str.substring(o, str.length()));
        return buf.toString();
    }

    public static String truncate(String string, int maxLen) {
        int max = string.length() > maxLen ? maxLen : string.length();
        return string.substring(0, max);
    }

    public static int indexOfIgnoreCase(String str, String substring) {
        return str.toLowerCase().indexOf(substring.toLowerCase());
    }

    static {
        _col.setDecomposition(2);
        _col.setStrength(0);
    }
}

