/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class UDataFileCreator {
    int numEx = 0;

    public static void main(String[] args) {
        UDataFileCreator ufc = new UDataFileCreator();
        ufc.createFile();
    }

    public void createFile() {
        BitSet dontExclude = new BitSet();
        TreeMap codepoints = new TreeMap((Comparator)new StringComparator());
        HashMap caseMap = new HashMap();
        BitSet excludedChars = new BitSet();
        BitSet replaceWithSpace = new BitSet();
        HashMap tempNFKC = new HashMap();
        try {
            this.readNonExclusion(dontExclude);
            this.dealWithUnicodeData((Map)codepoints, dontExclude, excludedChars, replaceWithSpace);
            this.readNTestPopKD((Map)codepoints, (Map)tempNFKC);
            this.readCaseFolding((Map)caseMap);
            this.replaceCase((Map)codepoints, (Map)caseMap, excludedChars);
            this.writeOutObjects((Map)codepoints, (Map)caseMap, excludedChars, replaceWithSpace, tempNFKC);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("number of excluded code points : " + this.numEx);
    }

    private void writeOutObjects(Map codepoint, Map caseMap, BitSet excludedChars, BitSet replaceWithSpace, HashMap nfkc) throws IOException {
        FileOutputStream fo = new FileOutputStream(new File("nudata.txt"));
        BufferedWriter bufo = new BufferedWriter(new OutputStreamWriter(fo));
        Iterator iter = codepoint.keySet().iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            udata u = (udata)codepoint.get((Object)s);
            if (u.deKomp.equals("")) continue;
            bufo.write(s + ";");
            String composition = (String)nfkc.get((Object)u.deKomp);
            composition = composition == null || composition.equals(u.deKomp) ? "" : composition;
            bufo.write(u.deKomp + ";" + composition + ";\n");
        }
        bufo.flush();
        bufo.close();
        fo = new FileOutputStream(new File("excluded.dat"));
        ObjectOutputStream oo = new ObjectOutputStream(fo);
        oo.writeObject(excludedChars);
        fo = new FileOutputStream(new File("caseMap.dat"));
        oo = new ObjectOutputStream(fo);
        oo.writeObject(caseMap);
        fo = new FileOutputStream(new File("replaceSpace.dat"));
        oo = new ObjectOutputStream(fo);
        oo.writeObject(replaceWithSpace);
    }

    private void readNonExclusion(BitSet ex) throws IOException {
        String line;
        BufferedReader buf = this.getBR("MnKeep.txt");
        while ((line = buf.readLine()) != null) {
            int dI = line.indexOf(59);
            String codepoint = line.substring(0, dI).trim();
            if (codepoint.indexOf("..") > -1) {
                String[] s = StringUtils.split(codepoint, "..");
                int start = Integer.parseInt(s[0], 16) - 1;
                int end = Integer.parseInt(s[1], 16);
                while (end != start) {
                    ex.set(end--);
                }
                continue;
            }
            ex.set(Integer.parseInt(codepoint, 16));
        }
        buf.close();
    }

    private void dealWithUnicodeData(Map cp, BitSet ex, BitSet excluded, BitSet replaceWithSpace) throws IOException {
        String line;
        BufferedReader buf = this.getBR("UnicodeData.txt");
        boolean go = true;
        while ((line = buf.readLine()) != null && go) {
            go = this.processLine(cp, ex, line, excluded, replaceWithSpace);
        }
        buf.close();
    }

    private boolean processLine(Map cp, BitSet ex, String line, BitSet excluded, BitSet replaceWithSpace) {
        String[] parts = StringUtils.splitNoCoalesce(line, ";");
        if (parts[0].equals("FFEE")) {
            return false;
        }
        if (parts[2].charAt(0) == 'P' || parts[2].equals("Zs")) {
            if (this.excludedPClass(parts[0])) {
                ++this.numEx;
                excluded.set(Integer.parseInt(parts[0], 16));
            } else if (!this.isExcluded(parts, ex)) {
                udata u = new udata();
                u.cat = parts[2];
                u.CC = parts[3];
                cp.put((Object)parts[0], (Object)u);
            } else {
                replaceWithSpace.set(Integer.parseInt(parts[0], 16));
                udata u = new udata();
                u.cat = parts[2];
                u.CC = parts[3];
                cp.put((Object)parts[0], (Object)u);
            }
        } else if (this.isExcluded(parts, ex)) {
            ++this.numEx;
            excluded.set(Integer.parseInt(parts[0], 16));
        } else {
            udata u = new udata();
            u.cat = parts[2];
            u.CC = parts[3];
            cp.put((Object)parts[0], (Object)u);
        }
        return true;
    }

    private boolean excludedPClass(String codepoint) {
        return codepoint.equals("0027");
    }

    private boolean isExcluded(String[] p, BitSet ex) {
        String cat = p[2];
        String cc = p[3];
        char first = cat.charAt(0);
        if (ex.get(Integer.parseInt(p[0].trim(), 16))) {
            return false;
        }
        if (cat.equals("Lu") || cat.equals("Ll") || cat.equals("Lt") || cat.equals("Lo") || cat.equals("Lm") || cat.equals("Nd") || cat.equals("Mc") || cat.equals("Cs") || cat.equals("Co") || cat.equals("Zs") || cat.equals("So") || first == 'P') {
            return false;
        }
        return !cat.equals("Mn") || !cc.equals("0");
    }

    private void readCaseFolding(Map c) throws IOException {
        String line;
        BufferedReader buf = this.getBR("CaseFolding.txt");
        while ((line = buf.readLine()) != null) {
            int index;
            String[] splitUp;
            String status;
            if (line.length() <= 0 || line.charAt(0) == '#' || !(status = (splitUp = StringUtils.split(line = line.substring(0, index = line.indexOf(35)).trim(), ";"))[1].trim()).equals("C") && !status.equals("F")) continue;
            c.put((Object)this.code2char(splitUp[0].trim()), (Object)this.code2char(splitUp[2].trim()));
        }
        buf.close();
    }

    private String code2char(String s) {
        StringBuffer b = new StringBuffer();
        if (s.indexOf(" ") > -1) {
            String[] splitup = StringUtils.split(s, " ");
            for (int i = 0; i < splitup.length; ++i) {
                b.append((char)Integer.parseInt(splitup[i], 16));
            }
        } else {
            b.append((char)Integer.parseInt(s, 16));
        }
        return b.toString();
    }

    private String char2code(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            String temp = Integer.toString(s.charAt(i), 16);
            if (temp.length() < 4) {
                b.append("00");
                b.append(temp);
            } else {
                b.append(temp);
            }
            b.append(" ");
        }
        return b.toString().trim();
    }

    private void replaceCase(Map codepoint, Map casF, BitSet ex) {
        Iterator iter = codepoint.keySet().iterator();
        int CJKLow = Integer.parseInt("3400", 16);
        int CJKHigh = Integer.parseInt("9FA5", 16);
        while (iter.hasNext()) {
            String up;
            String code = (String)iter.next();
            udata u = (udata)codepoint.get((Object)code);
            if (u.cat.indexOf("P") > -1 || u.cat.equals("Zs")) {
                u.deKomp = "0020";
                continue;
            }
            if (u.deKomp.equals("")) {
                up = (String)casF.get((Object)this.code2char(code));
                if (up == null) continue;
                u.deKomp = this.char2code(up);
                continue;
            }
            StringBuffer dek = new StringBuffer();
            String[] splitUp = StringUtils.split(u.deKomp, " ");
            boolean removed = false;
            for (int i = 0; i < splitUp.length; ++i) {
                int codeInt = Integer.parseInt(splitUp[i], 16);
                if (ex.get(codeInt)) continue;
                up = this.char2code((String)casF.get((Object)this.code2char(splitUp[i])));
                if (up != null) {
                    dek.append(up + " ");
                    continue;
                }
                udata ud = (udata)codepoint.get((Object)splitUp[i]);
                String cat = ud == null ? "" : ud.cat;
                up = cat.indexOf("P") > -1 ? "0020" : splitUp[i];
                dek.append(up + " ");
            }
            u.deKomp = dek.toString().trim();
        }
    }

    private void readNTestPopKD(Map c, Map kc) throws IOException {
        String line;
        BufferedReader buf = this.getBR("NormalizationTest-3.2.0.txt");
        boolean skip = false;
        int hangulFirst = 44032;
        int hangulLast = 55203;
        while ((line = buf.readLine()) != null) {
            char first = line.charAt(0);
            if (first == '#') continue;
            if (first == '@') {
                if (line.indexOf("Part2") > -1) break;
                if (line.indexOf("Part0") > -1) {
                    skip = true;
                    continue;
                }
                skip = false;
                continue;
            }
            if (skip) continue;
            String[] parts = StringUtils.split(line = line.substring(0, line.indexOf(35)).trim(), ";");
            udata u = (udata)c.get((Object)parts[0].trim());
            if (u != null) {
                u.deKomp = parts[4].trim();
            }
            kc.put((Object)parts[4].trim(), (Object)parts[3].trim());
        }
        buf.close();
    }

    private BufferedReader getBR(String filename) throws IOException {
        FileInputStream fi = new FileInputStream(new File(filename));
        return new BufferedReader(new InputStreamReader(fi));
    }

    private class udata {
        public String cat;
        public String CC;
        public String deKomp = "";

        private udata() {
        }
    }
}

