/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Weighable;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class WeightBasedHashMap {
    HashMap hashMap;
    private int numOfEntries = 0;
    private int maxEntries = 0;
    private long sumOfWeights = 0L;
    private HashSet probableRemovableEntries;
    private int maxProbableRemovableEntries = 0;

    public WeightBasedHashMap(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException();
        }
        this.hashMap = new HashMap((int)((double)maxSize / 0.75 + 10.0), 0.75f);
        this.maxEntries = maxSize;
        this.probableRemovableEntries = new HashSet((int)((double)maxSize / 0.75 + 5.0), 0.75f);
        this.maxProbableRemovableEntries = maxSize / 10 + 1;
    }

    public boolean incrementWeight(Object key) {
        Weighable weighable = null;
        weighable = (Weighable)this.hashMap.get(key);
        if (weighable != null) {
            weighable.addWeight(1);
            ++this.sumOfWeights;
            return true;
        }
        return false;
    }

    public Weighable get(Object key) {
        return (Weighable)this.hashMap.get(key);
    }

    public Weighable remove(Object key) {
        Weighable value = (Weighable)this.hashMap.remove(key);
        if (value != null) {
            this.sumOfWeights -= (long)value.getWeight();
            --this.numOfEntries;
        }
        return value;
    }

    public Object add(Object key, Weighable value) {
        Object entryRemoved = null;
        Weighable oldValue = (Weighable)this.hashMap.put(key, (Object)value);
        this.sumOfWeights += (long)value.getWeight();
        if (oldValue == null) {
            ++this.numOfEntries;
            if (this.numOfEntries > this.maxEntries) {
                entryRemoved = this.removeSomeLessWeightedEntry();
            }
        } else {
            this.sumOfWeights -= (long)oldValue.getWeight();
        }
        return entryRemoved;
    }

    private Object removeSomeLessWeightedEntry() {
        if (this.probableRemovableEntries.size() <= 0) {
            this.fillProbableRemovableEntries();
        }
        Object entryRemoved = this.probableRemovableEntries.iterator().next();
        Weighable removedValue = (Weighable)this.hashMap.remove(entryRemoved);
        this.probableRemovableEntries.remove(entryRemoved);
        --this.numOfEntries;
        this.sumOfWeights -= (long)removedValue.getWeight();
        return entryRemoved;
    }

    public boolean isWeightedEnough(Weighable value) {
        int average = (int)(this.sumOfWeights / (long)this.numOfEntries);
        return value.getWeight() > average + 5;
    }

    public boolean isFull() {
        return this.numOfEntries >= this.maxEntries;
    }

    private void fillProbableRemovableEntries() {
        Iterator iterator = this.hashMap.entrySet().iterator();
        float avg = this.sumOfWeights / (long)this.numOfEntries;
        int scaledAvg = (int)(1.1 * (double)avg) + 1;
        while (iterator.hasNext() && this.probableRemovableEntries.size() < this.maxProbableRemovableEntries) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Weighable weighable = (Weighable)entry.getValue();
            if (weighable.getWeight() >= scaledAvg) continue;
            this.probableRemovableEntries.add(entry.getKey());
        }
    }

    public Set entrySet() {
        return this.hashMap.entrySet();
    }

    public String toString() {
        return this.hashMap.toString();
    }
}

