/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = new LimeXMLSchemaRepository();

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] schemaFiles = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (schemaFiles != null) {
            for (int i = 0; i < schemaFiles.length; ++i) {
                try {
                    LimeXMLSchema limeXmlSchema = new LimeXMLSchema(schemaFiles[i]);
                    this._uriSchemaMap.put((Object)limeXmlSchema.getSchemaURI(), (Object)limeXmlSchema);
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLSchema getSchema(String uri) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            return (LimeXMLSchema)this._uriSchemaMap.get((Object)uri);
        }
    }

    public Collection getAvailableSchemas() {
        return Collections.unmodifiableCollection((Collection)this._uriSchemaMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSchemaURIs() {
        Object[] schemaURIs;
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set keySet = this._uriSchemaMap.keySet();
            schemaURIs = (String[])keySet.toArray((Object[])new String[0]);
        }
        Arrays.sort((Object[])schemaURIs, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                String a = (String)o1;
                String b = (String)o2;
                return a.compareTo(b);
            }
        });
        return schemaURIs;
    }
}

