/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.io.NIOServerSocket;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor));
    static long INCOMING_EXPIRE_TIME = 1800000L;
    static long WAIT_TIME_AFTER_REQUESTS = 30000L;
    static long TIME_BETWEEN_VALIDATES = 600000L;
    private static final UPnPManager UPNP_MANAGER = CommonUtils.isJava14OrLater() && !ConnectionSettings.DISABLE_UPNP.getValue() ? UPnPManager.instance() : null;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address = new byte[4];
    private static byte[] _externalAddress = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return;
        }
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean bl = false;
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            if (!Arrays.equals(_address, byArray)) {
                _address = byArray;
                bl = true;
            }
        }
        if (bl) {
            RouterService.addressChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            _externalAddress = byArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        boolean bl;
        int n;
        boolean bl3;
        block19: {
            int n2;
            bl3 = ConnectionSettings.PORT.isDefault() && !ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && !ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            Random random = null;
            if (bl3) {
                random = new Random();
                n2 = random.nextInt(50000) + 2000;
            } else {
                n2 = ConnectionSettings.PORT.getValue();
            }
            try {
                this.setAddress(UPNP_MANAGER != null ? UPnPManager.getLocalAddress() : InetAddress.getLocalHost());
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            n = n2;
            try {
                this.setListeningPort(n2);
                this._port = n2;
            }
            catch (IOException iOException) {
                void var6_11;
                LOG.warn((Object)"can't set initial port", (Throwable)iOException);
                int bl2 = 20;
                for (bl = false; bl < var6_11; bl += 1) {
                    if (random == null) {
                        random = new Random();
                    }
                    n2 = random.nextInt(50000);
                    if ((n2 += 2000) == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++var6_11;
                        continue;
                    }
                    try {
                        this.setListeningPort(n2);
                        this._port = n2;
                        break;
                    }
                    catch (IOException iOException2) {
                        LOG.warn((Object)"can't set port", (Throwable)iOException2);
                    }
                }
                if (this._socket != null) break block19;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        if (this._port != n || bl3) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        if (this._socket != null && UPNP_MANAGER != null) {
            UPNP_MANAGER.waitForDevice();
            UPNP_MANAGER.stop();
            boolean bl4 = UPNP_MANAGER.isNATPresent();
            boolean bl2 = NetworkUtils.isValidPort(this._port);
            boolean bl5 = bl = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Natted: " + bl4 + ", validPort: " + bl2 + ", forcedIP: " + bl));
            }
            if (bl4 && bl2 && !bl) {
                int n2 = UPNP_MANAGER.mapPort(this._port);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("UPNP port mapped: " + n2));
                }
                if (n2 != 0) {
                    UPNP_MANAGER.clearMappingsOnShutdown();
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(n2);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (n2 != this._port) {
                        RouterService.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    UDPService.instance().resetLastConnectBackTime();
                }
            }
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        ManagedThread managedThread = new ManagedThread(this, "Acceptor");
        managedThread.setDaemon(true);
        managedThread.start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return Arrays.equals(this.getAddress(true), _externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean bl) {
        Object object;
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            object = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                return inetAddress.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        object = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (object) {
            return _address;
        }
    }

    public int getPort(boolean bl) {
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int n) throws IOException {
        Object object;
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            LOG.trace((Object)"shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object2 = this.SOCKET_LOCK;
            synchronized (object2) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace((Object)"service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("changing port to " + n));
        }
        DatagramSocket datagramSocket = UDPService.instance().newListeningSocket(n);
        LOG.trace((Object)"UDP Service is ready.");
        MulticastSocket multicastSocket = null;
        try {
            object = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            multicastSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), (InetAddress)object);
            LOG.trace((Object)"multicast service setup");
        }
        catch (IOException iOException) {
            LOG.warn((Object)"can't create multicast socket", (Throwable)iOException);
            multicastSocket = null;
        }
        object = null;
        try {
            object = new NIOServerSocket(n);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"can't create ServerSocket", (Throwable)iOException);
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn((Object)"can't create ServerSocket", (Throwable)illegalArgumentException);
            datagramSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object3 = this.SOCKET_LOCK;
        synchronized (object3) {
            this._socket = object;
            this._port = n;
            this.SOCKET_LOCK.notify();
        }
        LOG.trace((Object)"Acceptor ready..");
        UDPService.instance().setListeningSocket(datagramSocket);
        if (multicastSocket != null) {
            MulticastService.instance().setListeningSocket(multicastSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("listening UDP/TCP on " + this._port));
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    private boolean setIncoming(boolean bl) {
        if (this._acceptedIncoming == bl) {
            return false;
        }
        this._acceptedIncoming = bl;
        RouterService.getCallback().acceptedIncomingChanged(bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirewall(Socket socket) {
        boolean bl = false;
        if (this.isOutsideConnection(socket.getInetAddress())) {
            Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
            synchronized (clazz) {
                bl = this.setIncoming(true);
                ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
                this._lastIncomingTime = System.currentTimeMillis();
            }
        }
        if (bl) {
            RouterService.incomingStatusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: while (true) {
            try {
                while (true) {
                    Socket socket = null;
                    Object object = this.SOCKET_LOCK;
                    synchronized (object) {
                        block20: {
                            if (this._socket != null) {
                                try {
                                    socket = this._socket.accept();
                                    break block20;
                                }
                                catch (IOException iOException) {
                                    LOG.warn((Object)"IOX while accepting", (Throwable)iOException);
                                    continue;
                                }
                            }
                            try {
                                this.SOCKET_LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    object = socket.getInetAddress();
                    if (object == null) {
                        LOG.warn((Object)"connection closed while accepting");
                        try {
                            socket.close();
                            continue block13;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    if (this.isBannedIP(((InetAddress)object).getAddress())) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Ignoring banned host: " + object));
                        }
                        HTTPStat.BANNED_REQUESTS.incrementStat();
                        try {
                            socket.close();
                            continue block13;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    if (!ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                        this.checkFirewall(socket);
                    }
                    InetAddress inetAddress = socket.getLocalAddress();
                    this.setAddress(inetAddress);
                    ConnectionDispatchRunner connectionDispatchRunner = new ConnectionDispatchRunner(socket);
                    ManagedThread managedThread = new ManagedThread(connectionDispatchRunner, "ConnectionDispatchRunner");
                    managedThread.setDaemon(true);
                    managedThread.start();
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                continue;
            }
            break;
        }
    }

    private boolean isOutsideConnection(InetAddress inetAddress) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        byte[] byArray = inetAddress.getAddress();
        return !RouterService.isConnectedTo(inetAddress) && !NetworkUtils.isLocalAddress(inetAddress);
    }

    public boolean isBannedIP(byte[] byArray) {
        return !IPFilter.instance().allow(byArray);
    }

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME - 1L;
    }

    public void shutdown() {
        if (UPNP_MANAGER != null && UPNP_MANAGER.isNATPresent() && UPNP_MANAGER.mappingsExist() && ConnectionSettings.UPNP_IN_USE.getValue()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$600(Acceptor acceptor, boolean bl) {
        return acceptor.setIncoming(bl);
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            long l = System.currentTimeMillis();
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && l - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && l - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && connectionManager.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable runnable = new Runnable(this, l){
                    private final /* synthetic */ long val$currTime;
                    private final /* synthetic */ IncomingValidator this$1;
                    {
                        this.this$1 = incomingValidator;
                        this.val$currTime = l;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean bl = false;
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            if (Acceptor.access$300(IncomingValidator.access$500(this.this$1)) < this.val$currTime) {
                                bl = Acceptor.access$600(IncomingValidator.access$500(this.this$1), false);
                            }
                        }
                        if (bl) {
                            RouterService.incomingStatusChanged();
                        }
                    }
                };
                RouterService.schedule(runnable, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }

        static /* synthetic */ Acceptor access$500(IncomingValidator incomingValidator) {
            return incomingValidator.Acceptor.this;
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            UploadManager uploadManager = RouterService.getUploadManager();
            DownloadManager downloadManager = RouterService.getDownloadManager();
            Acceptor acceptor = RouterService.getAcceptor();
            try {
                InputStream inputStream = null;
                try {
                    inputStream = this._socket.getInputStream();
                }
                catch (IOException iOException) {
                    HTTPStat.CLOSED_REQUESTS.incrementStat();
                    throw iOException;
                }
                catch (NullPointerException nullPointerException) {
                    throw new IOException(nullPointerException.getMessage());
                }
                this._socket.setSoTimeout(8000);
                String string = IOUtils.readLargestWord(inputStream, 8);
                this._socket.setSoTimeout(0);
                boolean bl = NetworkUtils.isLocalHost(this._socket);
                if (!string.equals("MAGNET")) {
                    if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && bl) {
                        LOG.trace((Object)"Killing localhost connection with non-magnet.");
                        this._socket.close();
                        return;
                    }
                } else if (!bl) {
                    LOG.trace((Object)"Killing non-local ExternalControl request.");
                    this._socket.close();
                    return;
                }
                boolean bl2 = ConnectionSettings.CONNECT_STRING.isDefault();
                if (string.equals("GNUTELLA")) {
                    HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                    connectionManager.acceptConnection(this._socket);
                } else if (bl2 && string.equals("LIMEWIRE")) {
                    HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                    connectionManager.acceptConnection(this._socket);
                } else if (string.equals("GET")) {
                    HTTPStat.GET_REQUESTS.incrementStat();
                    uploadManager.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                } else if (string.equals("HEAD")) {
                    HTTPStat.HEAD_REQUESTS.incrementStat();
                    uploadManager.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                } else if (string.equals("GIV")) {
                    HTTPStat.GIV_REQUESTS.incrementStat();
                    downloadManager.acceptDownload(this._socket);
                } else if (string.equals("MAGNET")) {
                    HTTPStat.MAGNET_REQUESTS.incrementStat();
                    ExternalControl.fireMagnet(this._socket);
                } else if (string.equals("CONNECT") || string.equals("\n\n")) {
                    if (ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                        acceptor.checkFirewall(this._socket);
                    }
                    IOUtils.close(this._socket);
                } else {
                    HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Unknown protocol: " + string));
                    }
                    IOUtils.close(this._socket);
                }
            }
            catch (IOException iOException) {
                LOG.warn((Object)"IOX while dispatching", (Throwable)iOException);
                IOUtils.close(this._socket);
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
    }
}

